/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.looper;

import android.content.Context;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.Nullable;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.IConfigListener;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.PerformanceConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.guid.GuidFactory;
import com.yy.base.logger.MLog;
import com.yy.base.stuckminor.LooperMonitorUtil;
import com.yy.base.stuckminor.base.IANRListener;
import com.yy.base.stuckminor.base.IMsgListener;
import com.yy.base.stuckminor.base.MsgInfo;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.HashMap;

public class MainLooperMonitor {
    private static LooperMsgStatHelper sMsgStatHelper;
    private static LooperAnrStatHelper sAnrStatHelper;
    private static Handler sMainLooperHandler;
    private static volatile boolean sRunning;
    private static boolean sCollectMsgSwitch;
    private static boolean sCollectMsgListSwitch;
    private static volatile IConfigListener<PerformanceConfigData> sConfigListener;

    public static void start() {
        if (sRunning) {
            return;
        }
        sCollectMsgSwitch = SettingFlags.getBoolean((String)"msgcollect", (boolean)false);
        sCollectMsgListSwitch = SettingFlags.getBoolean((String)"msglistcollect", (boolean)false);
        if (!MainLooperMonitor.isCollectMsgDataSwitchOn()) {
            LooperMsgStatHelper.clearMsgNumPercent();
            if (!MainLooperMonitor.isCollectMsgListDataSwitchOn()) {
                return;
            }
        }
        if (Looper.myLooper() != Looper.getMainLooper()) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    MainLooperMonitor.start();
                }
            });
            return;
        }
        MainLooperMonitor.initConfigListener();
        sRunning = true;
        if (sMsgStatHelper == null) {
            sMsgStatHelper = new LooperMsgStatHelper();
        }
        if (RuntimeContext.sIsDebuggable && sAnrStatHelper == null) {
            sAnrStatHelper = new LooperAnrStatHelper();
        }
        LooperMonitorUtil.start((Context)RuntimeContext.sApplicationContext, (IANRListener)sAnrStatHelper, (IMsgListener)sMsgStatHelper);
    }

    private static void initConfigListener() {
        if (sConfigListener == null) {
            sConfigListener = new IConfigListener<PerformanceConfigData>(){

                public void onUpdateConfig(@Nullable PerformanceConfigData data) {
                    sCollectMsgSwitch = SettingFlags.getBoolean((String)"msgcollect", (boolean)false);
                    sCollectMsgListSwitch = SettingFlags.getBoolean((String)"msglistcollect", (boolean)false);
                    if (MainLooperMonitor.isCollectMsgDataSwitchOn() || MainLooperMonitor.isCollectMsgListDataSwitchOn()) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MainLooperMonitor.start();
                            }
                        });
                    } else {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MainLooperMonitor.stop();
                            }
                        });
                    }
                }
            };
            UnifyConfig.INSTANCE.registerListener(BssCode.PERFORMANCE_CONFIG, sConfigListener);
        }
    }

    private static void stop() {
        sRunning = false;
        LooperMsgStatHelper.clearMsgNumPercent();
        if (Looper.myLooper() != Looper.getMainLooper()) {
            return;
        }
        if (sMsgStatHelper != null) {
            sMsgStatHelper.onStop();
        }
        LooperMonitorUtil.setMsgListener(null);
        LooperMonitorUtil.setAnrListener(null);
        LooperMonitorUtil.stop();
    }

    public static void onStartupFinished() {
        if (!MainLooperMonitor.isCollectMsgDataSwitchOn()) {
            return;
        }
        if (sMsgStatHelper != null) {
            sMsgStatHelper.uploadNumPercentData();
        }
    }

    private static void postRunnable(Runnable runnable, long delayTime) {
        if (sMainLooperHandler == null) {
            sMainLooperHandler = new Handler(Looper.getMainLooper());
        }
        sMainLooperHandler.postDelayed(runnable, delayTime);
    }

    private static void removeRunnable(Runnable runnable) {
        if (sMainLooperHandler != null) {
            sMainLooperHandler.removeCallbacks(runnable);
        }
    }

    private static boolean isCollectMsgDataSwitchOn() {
        return sCollectMsgSwitch || RuntimeContext.sIsDebuggable;
    }

    private static boolean isCollectMsgListDataSwitchOn() {
        return sCollectMsgListSwitch || RuntimeContext.sIsDebuggable;
    }

    static {
        sRunning = false;
        sCollectMsgSwitch = false;
        sCollectMsgListSwitch = false;
    }

    private static class LooperMsgStatHelper
    implements IMsgListener {
        private static final String LOOPER_MSG_STAT_PERCENT = "lmsperCent";
        private static final String SPLIT_CHAR = "-";
        private static final int COLLECT_MSG_DEFAULT_TIME;
        private static final int MAX_STAT_MSG_NUM_EVERY_HOUR = 30;
        private static final int WARNING_TIME;
        private final long[] mStates = new long[10];
        private Runnable mSaveStatesRunnable;
        private Runnable mUploadStatesRunnable;
        private boolean mSaving = false;
        private boolean mUploading = false;
        private int mHasStatMsgNumThisHour = 0;
        private long mTimeInThisHour = 0L;
        private static HashMap<String, String> sExcludeList;

        LooperMsgStatHelper() {
            String numPercent = SettingFlags.getStringValue((String)LOOPER_MSG_STAT_PERCENT);
            if (!StringUtils.isEmpty((String)numPercent)) {
                String[] stateNums = numPercent.split(SPLIT_CHAR);
                for (int i = 0; i < stateNums.length; ++i) {
                    if (stateNums[i] == null) continue;
                    this.mStates[i] = Integer.valueOf(stateNums[i]).intValue();
                }
            }
        }

        static void clearMsgNumPercent() {
            SettingFlags.setStringValue((String)LOOPER_MSG_STAT_PERCENT, (String)"");
        }

        private void statsNum(int index) {
            if (index < this.mStates.length) {
                int n = index;
                this.mStates[n] = this.mStates[n] + 1L;
            }
            if (!this.mSaving) {
                if (this.mSaveStatesRunnable == null) {
                    this.mSaveStatesRunnable = new Runnable(){

                        @Override
                        public void run() {
                            SettingFlags.setStringValue((String)LooperMsgStatHelper.LOOPER_MSG_STAT_PERCENT, (String)this.getLooperMsgNumPercent());
                            mSaving = false;
                        }
                    };
                }
                this.mSaving = true;
                MainLooperMonitor.postRunnable(this.mSaveStatesRunnable, 300000L);
            }
            if (!this.mUploading) {
                if (this.mUploadStatesRunnable == null) {
                    this.mUploadStatesRunnable = new Runnable(){

                        @Override
                        public void run() {
                            this.uploadNumPercentData();
                            mUploading = false;
                        }
                    };
                }
                this.mUploading = true;
                MainLooperMonitor.postRunnable(this.mUploadStatesRunnable, 1200000L);
            }
        }

        private String getLooperMsgNumPercent() {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < this.mStates.length; ++i) {
                result.append(String.valueOf(this.mStates[i]));
                if (i == this.mStates.length - 1) continue;
                result.append(SPLIT_CHAR);
            }
            return result.toString();
        }

        public void onStop() {
            if (this.mSaveStatesRunnable != null) {
                MainLooperMonitor.removeRunnable(this.mSaveStatesRunnable);
            }
            if (this.mUploadStatesRunnable != null) {
                MainLooperMonitor.removeRunnable(this.mUploadStatesRunnable);
            }
            SettingFlags.setStringValue((String)LOOPER_MSG_STAT_PERCENT, (String)this.getLooperMsgNumPercent());
            this.mSaving = false;
        }

        public void uploadNumPercentData() {
            if (this.mSaveStatesRunnable != null) {
                MainLooperMonitor.removeRunnable(this.mSaveStatesRunnable);
            }
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagomsgmonitor");
            statContent.put("loopername", "main");
            statContent.put("states0", String.valueOf(this.mStates[0]));
            statContent.put("states1", String.valueOf(this.mStates[1]));
            statContent.put("states2", String.valueOf(this.mStates[2]));
            statContent.put("states3", String.valueOf(this.mStates[3]));
            statContent.put("states4", String.valueOf(this.mStates[4]));
            statContent.put("states5", String.valueOf(this.mStates[5]));
            statContent.put("states6", String.valueOf(this.mStates[6]));
            statContent.put("states7", String.valueOf(this.mStates[7]));
            statContent.put("states8", String.valueOf(this.mStates[8]));
            statContent.put("states9", String.valueOf(this.mStates[9]));
            if (RuntimeContext.sIsDebuggable) {
                statContent.put("ext", "debug");
            }
            try {
                HiidoStatis.reportContent((StatisContent)statContent);
            }
            catch (Throwable ex) {
                MLog.error((Object)"LooperMsgStatHelper HiidoSDK:", (Throwable)ex);
            }
            this.mSaving = false;
            SettingFlags.setStringValue((String)LOOPER_MSG_STAT_PERCENT, (String)"");
            for (int i = 0; i < this.mStates.length; ++i) {
                this.mStates[i] = 0L;
            }
        }

        public void onMsgFinished(long consumeRealTime) {
            long rtime = consumeRealTime;
            if (rtime > 60000L || rtime < 0L) {
                return;
            }
            if (MainLooperMonitor.isCollectMsgDataSwitchOn()) {
                if (rtime < 50L) {
                    this.statsNum(0);
                } else if (rtime < 100L) {
                    this.statsNum(1);
                } else if (rtime < 200L) {
                    this.statsNum(2);
                } else if (rtime < 300L) {
                    this.statsNum(3);
                } else if (rtime < 400L) {
                    this.statsNum(4);
                } else if (rtime < 500L) {
                    this.statsNum(5);
                } else if (rtime < 1000L) {
                    this.statsNum(6);
                } else if (rtime < 1500L) {
                    this.statsNum(7);
                } else if (rtime < 2000L) {
                    this.statsNum(8);
                } else {
                    this.statsNum(9);
                }
            }
        }

        public void onMsgFinished(MsgInfo info) {
            if (info == null) {
                return;
            }
            if (Debug.isDebuggerConnected()) {
                return;
            }
            long rtime = info.getConsumeRealTime();
            if (rtime > 60000L || rtime < 0L) {
                return;
            }
            if (rtime > (long)WARNING_TIME && RuntimeContext.sIsDebuggable) {
                MLog.info((Object)"StrictMode", (String)("StrictMode Main Looper Monitor :attention, msg use too mush time, please check:" + info.toString()), (Object[])new Object[0]);
            }
            if (MainLooperMonitor.isCollectMsgDataSwitchOn()) {
                if (rtime < 50L) {
                    this.statsNum(0);
                } else if (rtime < 100L) {
                    this.statsNum(1);
                } else if (rtime < 200L) {
                    this.statsNum(2);
                } else if (rtime < 300L) {
                    this.statsNum(3);
                } else if (rtime < 400L) {
                    this.statsNum(4);
                } else if (rtime < 500L) {
                    this.statsNum(5);
                } else if (rtime < 1000L) {
                    this.statsNum(6);
                } else if (rtime < 1500L) {
                    this.statsNum(7);
                } else if (rtime < 2000L) {
                    this.statsNum(8);
                } else {
                    this.statsNum(9);
                }
            }
            if (MainLooperMonitor.isCollectMsgListDataSwitchOn() && rtime > (long)COLLECT_MSG_DEFAULT_TIME && info.getConsumeCPUTime() > 50L && !Debug.isDebuggerConnected()) {
                this.statsMsg(info);
            }
        }

        private void statsMsg(MsgInfo info) {
            if (info == null) {
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (this.mTimeInThisHour > 0L && currentTime - this.mTimeInThisHour > 3600000L) {
                this.mTimeInThisHour = currentTime;
                this.mHasStatMsgNumThisHour = 0;
            } else if (this.mHasStatMsgNumThisHour == 0) {
                this.mTimeInThisHour = currentTime;
            }
            if (this.mHasStatMsgNumThisHour >= 30) {
                return;
            }
            String callback = info.getCallback();
            String callBackAddress = null;
            if (!StringUtils.isEmpty((String)callback)) {
                int indexStart = callback.indexOf("@");
                if (indexStart >= 0) {
                    callback = callback.substring(0, indexStart);
                    callBackAddress = callback.substring(indexStart);
                }
                if (this.inExcludeList(info.getTarget(), callback)) {
                    return;
                }
            }
            ++this.mHasStatMsgNumThisHour;
            StatisContent statContent = new StatisContent();
            statContent.put("act", "hagomsglist");
            statContent.put("loopername", "main");
            statContent.put("msgid", info.getMsgID());
            statContent.put("mtarget", info.getTarget());
            statContent.put("mlt", (int)info.getConsumeRealTime());
            statContent.put("mct", (int)info.getConsumeCPUTime());
            statContent.put("guid", GuidFactory.getInstance().getGuid());
            if (callback != null && callback.length() > 200) {
                callback = callback.substring(0, 199);
            }
            statContent.put("mcb", callback);
            if (callBackAddress != null) {
                statContent.put("mcba", callBackAddress);
            }
            statContent.put("hyfg", RuntimeContext.sIsForeground ? "1" : "0");
            statContent.put("hysu", RuntimeContext.sIsAppStartFinished ? "1" : "0");
            statContent.put("hyrt", String.valueOf(SystemClock.uptimeMillis() - RuntimeContext.sMainActivityStartTime));
            statContent.put("hyrtr", String.valueOf(RuntimeContext.getForeGroundRunTime()));
            statContent.put("hyw", RuntimeContext.sCurWin);
            try {
                HiidoStatis.reportContent((StatisContent)statContent);
            }
            catch (Throwable ex) {
                MLog.error((Object)"LooperMsgStatHelper HiidoSDK:", (Throwable)ex);
            }
        }

        private boolean inExcludeList(String target, String callBack) {
            String tempCallBack;
            if (sExcludeList == null) {
                sExcludeList = new HashMap();
                sExcludeList.put("android.os.Handler", "java.util.concurrent.FutureTask");
                sExcludeList.put("android.os.Handler", "android.os.MessageQueue.nativePollOnce");
            }
            if ((tempCallBack = sExcludeList.get(target)) != null && callBack != null && callBack.contains(tempCallBack)) {
                return true;
            }
            return callBack != null && callBack.contains("com.yy.hiyo.startup.");
        }

        static {
            WARNING_TIME = COLLECT_MSG_DEFAULT_TIME = RuntimeContext.sIsDebuggable ? 200 : 300;
        }
    }

    private static class LooperAnrStatHelper
    implements IANRListener {
        private LooperAnrStatHelper() {
        }

        public void anrStack(String stack) {
            if (RuntimeContext.sIsDebuggable && !Debug.isDebuggerConnected()) {
                MLog.error((Object)"ANR:", (String)stack, (Object[])new Object[0]);
            }
        }
    }
}

