/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.global;

import android.app.Application;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.GlobalPerItemBean;
import com.yy.appbase.unifyconfig.config.taskopt.TaskOptConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.framework.core.Should;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.AbstractMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.IMonitorCallBack;

public class FileMonitor
extends AbstractMonitor
implements YYFileUtils.OnMonitorFileOperate {
    private static final String TAG = "PerfApm_FileMonitor";
    private static final String FORMAT = "%s isMainThread = %s path %s";
    private static final String FORMAT_WITH_SIZE = "FileMonitor %s isMainThread = %s path %s size:%d";
    private static final boolean PRINT_CALL_STACK;
    private static final boolean ENABLE_LOG;
    private static final boolean ENABLE_LOG_OPT;
    private IQueueTaskExecutor mTaskExecutor = YYTaskExecutor.createAQueueExcuter((boolean)false, (boolean)false);

    public FileMonitor(IMonitorCallBack callBack) {
        super(callBack);
    }

    private boolean checkMainThreadAndDebug(boolean isMainThread) {
        if (isMainThread) {
            // empty if block
        }
        return false;
    }

    private boolean enableMonitor() {
        return SettingFlags.getBoolean((String)"global_file_monitor", (boolean)false) || SystemUtils.isShowEnvSetting();
    }

    @Override
    public void start() {
        YYFileUtils.setOnMonitorFileOperate(this.enableMonitor() && this.mCallBack != null ? this : null);
    }

    @Override
    public void stop() {
        YYFileUtils.setOnMonitorFileOperate(null);
    }

    public void onAssetFileAction(String filePath, String act) {
        String desc = filePath + "<-- onAssetFileAction " + act + " -->";
        boolean isMainThread = this.reportReasonDesc(12, desc);
        FileMonitor.logFileAction("onAssetFileAction", isMainThread, desc);
    }

    public void onFileExist(String filePath) {
        String desc = filePath + "<-- onFileExist -->";
        boolean isMainThread = this.reportReasonDesc(11, desc);
        FileMonitor.logFileAction("onFileExist", isMainThread, desc);
    }

    public void onNewFile(String filePath) {
        boolean isMainThread = this.reportReasonDesc(6, filePath);
        FileMonitor.logFileAction("onNewFile", isMainThread, filePath);
    }

    public void onCopyFile(String originFilePath, String desFilePath) {
        String desc = originFilePath + "<-- onCopyFile -->" + desFilePath;
        boolean isMainThread = this.reportReasonDesc(4, desc);
        FileMonitor.logFileAction("onCopyFile", isMainThread, desc);
        if (this.checkMainThreadAndDebug(isMainThread)) {
            Should.fail((String)"\u6587\u4ef6\u590d\u5236\u4e0d\u5141\u8bb8\u5728\u4e3b\u7ebf\u7a0b!!!!", (Throwable)new Throwable());
        }
    }

    public void onDeleteFile(String filePath) {
        boolean isMainThread = this.reportReasonDesc(5, filePath);
        FileMonitor.logFileAction("onDeleteFile", isMainThread, filePath);
        if (this.checkMainThreadAndDebug(isMainThread)) {
            // empty if block
        }
    }

    public void onReadContentFromFile(String filePath, int size) {
        boolean isMainThread = this.reportReasonDesc(2, filePath);
        this.logFileAction("onReadContentFromFile", isMainThread, filePath, size);
        if (this.checkMainThreadAndDebug(isMainThread)) {
            Should.fail((String)"\u6587\u4ef6\u8bfb\u53d6\u4e0d\u5141\u8bb8\u5728\u4e3b\u7ebf\u7a0b!!!!", (Throwable)new Throwable());
        }
    }

    public void onWriteContentToFile(String filePath, int size) {
        boolean isMainThread = this.reportReasonDesc(1, filePath);
        this.logFileAction("onWriteContentToFile", isMainThread, filePath, size);
        if (this.checkMainThreadAndDebug(isMainThread)) {
            Should.fail((String)"\u6587\u4ef6\u5199\u5165\u4e0d\u5141\u8bb8\u5728\u4e3b\u7ebf\u7a0b!!!!", (Throwable)new Throwable());
        }
    }

    public void onRenameFile(String filePath, String originName, String resultName) {
        String desc = filePath + " | " + originName + " | " + resultName;
        boolean isMainThread = this.reportReasonDesc(7, desc);
        FileMonitor.logFileAction("onRenameFile", isMainThread, desc);
    }

    public void onMd5ForFile(String filePath) {
        boolean isMainThread = this.reportReasonDesc(8, filePath);
        FileMonitor.logFileAction("onMd5ForFile", isMainThread, filePath);
        if (this.checkMainThreadAndDebug(isMainThread)) {
            Should.fail((String)"\u6587\u4ef6md5\u4e0d\u5141\u8bb8\u5728\u4e3b\u7ebf\u7a0b!!!!", (Throwable)new Throwable());
        }
    }

    public void onUnZip(String filePath, String descDir) {
        String desc = filePath + " | " + descDir;
        boolean isMainThread = this.reportReasonDesc(3, desc);
        FileMonitor.logFileAction("onUnZip", isMainThread, desc);
        if (this.checkMainThreadAndDebug(isMainThread)) {
            Should.fail((String)"\u6587\u4ef6\u89e3\u538b\u4e0d\u5141\u8bb8\u5728\u4e3b\u7ebf\u7a0b!!!!", (Throwable)new Throwable());
        }
    }

    public void onCreateDir(String path) {
        boolean isMainThread = this.reportReasonDesc(9, path);
        FileMonitor.logFileAction("onCreateDir", isMainThread, path);
    }

    public void onOpenFile(String path) {
        boolean isMainThread = this.reportReasonDesc(10, path);
        FileMonitor.logFileAction("onOpenFile", isMainThread, path);
    }

    public boolean isFileOptOpen() {
        return TaskOptConfig.isFileOptSwitchOn();
    }

    private boolean reportReasonDesc(final int commomPerfFileTypeDef, final String desc) {
        if (desc == null || desc.contains("webview/projects")) {
            return false;
        }
        final boolean isMainThread = YYTaskExecutor.isMainThread();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                GlobalPerItemBean globalPItem = FileMonitor.this.mCallBack.createBaseItem(1, commomPerfFileTypeDef, 0, desc, isMainThread);
                FileMonitor.this.mCallBack.addPerItem(globalPItem);
            }
        };
        this.execute(runnable);
        if (!RuntimeContext.sIsDebuggable || isMainThread) {
            // empty if block
        }
        return isMainThread;
    }

    private void execute(Runnable runnable) {
        this.mTaskExecutor.execute(runnable, 0L);
    }

    private static void logFileAction(String actionDesc, boolean isMainThread, String fileDesc) {
        if (ENABLE_LOG) {
            if (fileDesc == null || fileDesc.contains("webview/projects")) {
                return;
            }
            if (!PRINT_CALL_STACK) {
                if (isMainThread) {
                    MLog.error((Object)TAG, (String)FORMAT, (Object[])new Object[]{actionDesc, true, fileDesc});
                } else {
                    MLog.info((Object)TAG, (String)FORMAT, (Object[])new Object[]{actionDesc, false, fileDesc});
                }
            } else {
                MLog.error((Object)TAG, (Throwable)new RuntimeException(actionDesc + " isMainThread:" + isMainThread + " file:" + fileDesc));
            }
        }
    }

    private void logFileAction(String actionDesc, boolean isMainThread, String fileDesc, int size) {
        if (ENABLE_LOG) {
            if (!PRINT_CALL_STACK) {
                if (isMainThread) {
                    MLog.error((Object)TAG, (String)FORMAT_WITH_SIZE, (Object[])new Object[]{actionDesc, true, fileDesc, size});
                } else {
                    MLog.info((Object)TAG, (String)FORMAT_WITH_SIZE, (Object[])new Object[]{actionDesc, false, fileDesc, size});
                }
            } else {
                MLog.error((Object)TAG, (Throwable)new RuntimeException(actionDesc + " isMainThread:" + isMainThread + " file:" + fileDesc + " size:" + size));
            }
        }
    }

    public static void onApplicationCreate(Application application) {
        if (SystemUtils.isShowEnvSetting() || TaskOptConfig.isFileOptSwitchOn()) {
            YYFileUtils.setFileOperateOpt((YYFileUtils.IFileOperateOpt)new YYFileUtils.IFileOperateOpt(){

                public boolean judgeFileExistShouldUseCache(String filePath) {
                    if (ENABLE_LOG_OPT) {
                        FileMonitor.logFileAction("judgeFileExistShouldUseCache", YYTaskExecutor.isMainThread(), filePath);
                    }
                    if (SystemUtils.isShowEnvSetting()) {
                        return true;
                    }
                    if (TaskOptConfig.isFileOptSwitchOn()) {
                        return AccountUtil.getUid() > 0L && RuntimeContext.sIsMainProcess && !RuntimeContext.sIsAppStartFinishAfterThreeSecond;
                    }
                    return false;
                }

                public boolean judgeDirectoryShouldUseCache(String filePath) {
                    if (ENABLE_LOG_OPT) {
                        FileMonitor.logFileAction("judgeDirectoryShouldUseCache", YYTaskExecutor.isMainThread(), filePath);
                    }
                    if (SystemUtils.isShowEnvSetting()) {
                        return true;
                    }
                    if (TaskOptConfig.isFileOptSwitchOn()) {
                        return AccountUtil.getUid() > 0L && RuntimeContext.sIsMainProcess && !RuntimeContext.sIsAppStartFinishAfterThreeSecond;
                    }
                    return false;
                }

                public boolean isFileOptOpen() {
                    return TaskOptConfig.isFileOptSwitchOn();
                }
            });
        }
    }

    static {
        if (SystemUtils.isShowEnvSetting()) {
            // empty if block
        }
        PRINT_CALL_STACK = false;
        ENABLE_LOG = SystemUtils.isShowEnvSetting();
        if (SystemUtils.isShowEnvSetting()) {
            // empty if block
        }
        ENABLE_LOG_OPT = false;
    }
}

