/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.crash;

import android.content.Context;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.guid.GuidFactory;
import com.yy.base.memoryrecycle.views.Monitor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.yylite.commonbase.crash.CrashSdk;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class ExceptionMonitor {
    public static void initViewMonitor() {
        Monitor.setIMonitorCallBack((Monitor.IExceptionCallBack)new Monitor.IExceptionCallBack(){

            public void onYYImageViewDrawRecycleBitmapException(Exception e) {
                HiidoStatis.reportAppMonitorReturnCode((String)"imageviewrbe/", (long)0L, (String)"1");
            }

            public void onYYTextViewDrawException(StackOverflowError e) {
                HiidoStatis.reportAppMonitorReturnCode((String)"yytextviewexc/draw/stackover", (long)0L, (String)"1");
            }
        });
    }

    public static void onStartUpFinished() {
        final String lastCrashGame = SettingFlags.getStringValue((String)"gameincrash");
        final String lastCrashChannel = SettingFlags.getStringValue((String)"roomincrash");
        if (StringUtils.isNotEmpty((String)lastCrashGame) || StringUtils.isNotEmpty((String)lastCrashChannel)) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                        StatisContent statContent;
                        if (StringUtils.isNotEmpty((String)lastCrashGame)) {
                            HiidoStatis.reportAppMonitorReturnCode((String)("hygamecrash/" + lastCrashGame), (long)0L, (String)"0");
                            statContent = new StatisContent();
                            statContent.put("act", "hagoperf");
                            statContent.put("sfield", GuidFactory.getInstance().getGuid());
                            statContent.put("sfieldtwo", lastCrashGame);
                            statContent.put("sfieldthree", RuntimeContext.getLastVer());
                            statContent.put("perftype", "gamecrash");
                            HiidoStatis.reportContent((StatisContent)statContent);
                            SettingFlags.removeKey((String)"gameincrash");
                        }
                        if (StringUtils.isNotEmpty((String)lastCrashChannel)) {
                            HiidoStatis.reportAppMonitorReturnCode((String)"channelcrash", (long)0L, (String)"0");
                            statContent = new StatisContent();
                            statContent.put("act", "hagoperf");
                            statContent.put("sfieldtwo", lastCrashChannel);
                            statContent.put("perftype", "channelcrash");
                            HiidoStatis.reportContent((StatisContent)statContent);
                            SettingFlags.removeKey((String)"roomincrash");
                        }
                    }
                }
            }, (long)(RuntimeContext.isPhoneSuperLow() ? 5000L : 3000L));
        }
    }

    public static void onStartUpFinishedAfterThreeSecond() {
        if (NAB.B.equals((Object)NewABDefine.IMAGE_AUTOPAUSE_OPT.getTestWithoutReport())) {
            CrashSdk.INSTANCE.addExtend("autopause_opt", "B");
        } else if (NAB.A.equals((Object)NewABDefine.IMAGE_AUTOPAUSE_OPT.getTestWithoutReport())) {
            CrashSdk.INSTANCE.addExtend("autopause_opt", "A");
        }
        if (NAB.B.equals((Object)NewABDefine.GAME_VIDEO_SO_PRELOAD_OPT.getTestWithoutReport())) {
            CrashSdk.INSTANCE.addExtend("gv_so_preload_opt", "B");
        } else if (NAB.A.equals((Object)NewABDefine.GAME_VIDEO_SO_PRELOAD_OPT.getTestWithoutReport())) {
            CrashSdk.INSTANCE.addExtend("gv_so_preload_opt", "A");
        }
        if (NAB.B.equals((Object)NewABDefine.PROPERTY_STAT_OPT.getTestWithoutReport())) {
            CrashSdk.INSTANCE.addExtend("property_stat_opt", "B");
        } else if (NAB.A.equals((Object)NewABDefine.PROPERTY_STAT_OPT.getTestWithoutReport())) {
            CrashSdk.INSTANCE.addExtend("property_stat_opt", "A");
        }
    }
}

