/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect;

import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.core.view.ViewCompat;
import com.opensource.svgaplayer.hago.SVGADrawable;
import com.opensource.svgaplayer.hago.SVGAImageView;
import com.yy.appbase.ui.widget.ICanAutoPause;
import com.yy.base.R;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.svga.SvgaLoader;
import java.util.ArrayList;

public class SvgaAutoPause {
    private static DefaultWindow.IGlobalWindowMonitor sWindowPathMonitor;
    private static IRecoverInterceptor sRecoverInterceptor;

    public static void startOrPause() {
        if (!SettingFlags.getBoolean((String)"svgaautopause", (boolean)true)) {
            if (sWindowPathMonitor != null) {
                DefaultWindow.removeGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)sWindowPathMonitor);
                sWindowPathMonitor = null;
            }
            return;
        }
        if (sWindowPathMonitor != null) {
            return;
        }
        sWindowPathMonitor = new DefaultWindow.IGlobalWindowMonitor(){

            public void onWindowCreate(DefaultWindow window) {
            }

            public void onShown(DefaultWindow window) {
                SvgaAutoPause.restartAllSvga((ViewGroup)window);
            }

            public void onHidden(DefaultWindow window) {
                SvgaAutoPause.pauseAllSvga((ViewGroup)window);
            }

            public void onLayout(boolean changed, int left, int top, int right, int bottom) {
            }
        };
        DefaultWindow.addGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)sWindowPathMonitor);
        SvgaLoader.setSvgaRecycleHangler((SvgaLoader.ISvgaRecycleHangler)new SvgaLoader.ISvgaRecycleHangler(){

            public void restartAllSvga(final ViewGroup viewGroup) {
                if (YYTaskExecutor.isMainThread() && viewGroup != null) {
                    SvgaAutoPause.restartAllSvga(viewGroup);
                } else if (viewGroup != null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SvgaAutoPause.restartAllSvga(viewGroup);
                        }
                    });
                }
            }

            public void pauseAllSvga(final ViewGroup viewGroup) {
                if (YYTaskExecutor.isMainThread() && viewGroup != null) {
                    SvgaAutoPause.pauseAllSvga(viewGroup);
                } else if (viewGroup != null) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            SvgaAutoPause.pauseAllSvga(viewGroup);
                        }
                    });
                }
            }
        });
    }

    private static void obtainAllSvgaImageViews(ViewGroup window, ArrayList<SVGAImageView> svgaImageViews, ArrayList<View> mAnimationViews, ArrayList<ICanAutoPause> autoPauseTargets, boolean toRestart) {
        View view;
        ViewGroup viewGroup = window;
        if (sRecoverInterceptor != null && toRestart && (view = sRecoverInterceptor.getRecoverView(viewGroup)) != viewGroup) {
            if (view instanceof ViewGroup) {
                viewGroup = (ViewGroup)view;
                SvgaAutoPause.obtainAllSvgaImageViews(viewGroup, svgaImageViews, mAnimationViews, autoPauseTargets, toRestart);
            } else if (view instanceof ImageView) {
                if (view instanceof SVGAImageView) {
                    svgaImageViews.add((SVGAImageView)view);
                } else {
                    if (view.getAnimation() != null && view.getAnimation().getRepeatCount() == -1) {
                        mAnimationViews.add(view);
                    }
                    if (view instanceof ICanAutoPause) {
                        autoPauseTargets.add((ICanAutoPause)view);
                    }
                }
            }
            return;
        }
        int childSize = viewGroup.getChildCount();
        View child = null;
        for (int i = 0; i < childSize; ++i) {
            child = viewGroup.getChildAt(i);
            if (child == null) continue;
            if (child instanceof ViewGroup) {
                SvgaAutoPause.obtainAllSvgaImageViews((ViewGroup)child, svgaImageViews, mAnimationViews, autoPauseTargets, toRestart);
            } else if (child instanceof SVGAImageView) {
                svgaImageViews.add((SVGAImageView)child);
            }
            if (child.getAnimation() != null && child.getAnimation().getRepeatCount() == -1) {
                mAnimationViews.add(child);
            }
            if (!(child instanceof ICanAutoPause)) continue;
            autoPauseTargets.add((ICanAutoPause)child);
        }
    }

    public static void pauseAllSvga(ViewGroup window) {
        ArrayList<SVGAImageView> svgaImageViews = new ArrayList<SVGAImageView>();
        ArrayList<View> mAnimationViews = new ArrayList<View>();
        ArrayList<ICanAutoPause> autoPauseTargets = new ArrayList<ICanAutoPause>();
        SvgaAutoPause.obtainAllSvgaImageViews(window, svgaImageViews, mAnimationViews, autoPauseTargets, false);
        if (svgaImageViews.size() > 0) {
            for (SVGAImageView imageView : svgaImageViews) {
                SvgaAutoPause.pauseSvga(imageView);
            }
        }
        if (mAnimationViews.size() > 0) {
            for (int i = 0; i < mAnimationViews.size(); ++i) {
                SvgaAutoPause.pauseAnimation(mAnimationViews.get(i));
            }
        }
        if (autoPauseTargets.size() > 0) {
            for (int i = 0; i < autoPauseTargets.size(); ++i) {
                ICanAutoPause target = autoPauseTargets.get(i);
                target.onAutoPause();
            }
        }
    }

    public static void restartAllSvga(ViewGroup window) {
        ArrayList<SVGAImageView> svgaImageViews = new ArrayList<SVGAImageView>();
        ArrayList<View> mAnimationViews = new ArrayList<View>();
        ArrayList<ICanAutoPause> autoPauseTargets = new ArrayList<ICanAutoPause>();
        SvgaAutoPause.obtainAllSvgaImageViews(window, svgaImageViews, mAnimationViews, autoPauseTargets, true);
        if (svgaImageViews.size() > 0) {
            for (SVGAImageView imageView : svgaImageViews) {
                SvgaAutoPause.resumeSvga(imageView);
            }
        }
        if (mAnimationViews.size() > 0) {
            for (int i = 0; i < mAnimationViews.size(); ++i) {
                View v = mAnimationViews.get(i);
                SvgaAutoPause.resumeAnimation(v);
            }
        }
        if (autoPauseTargets.size() > 0) {
            for (int i = 0; i < autoPauseTargets.size(); ++i) {
                ICanAutoPause target = autoPauseTargets.get(i);
                target.onAutoResume();
            }
        }
    }

    private static void pauseSvga(SVGAImageView svgaImageView) {
        Drawable drawable2;
        if (svgaImageView == null) {
            return;
        }
        if (svgaImageView.isAnimating() && svgaImageView.getLoopCount() <= 0 && (drawable2 = svgaImageView.getDrawable()) instanceof SVGADrawable && !((SVGADrawable)drawable2).getCleared()) {
            svgaImageView.pauseAnimation();
            if (RuntimeContext.isInGray()) {
                MLog.info((Object)"ImageAuto_SvgaAutoPause", (String)"pauseSvga:%s", (Object[])new Object[]{svgaImageView.toString()});
            }
            svgaImageView.setTag(R.id.yy_svga_auto_pause_id, (Object)true);
        }
    }

    private static void pauseAnimation(View view) {
        if (view == null) {
            return;
        }
        Animation animation = view.getAnimation();
        if (animation == null || animation.getRepeatCount() != -1) {
            return;
        }
        animation.cancel();
        view.setTag(R.id.yy_animation_auto_pause_id, (Object)true);
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)"ImageAuto_SvgaAutoPause", (String)"pauseAnimation: %s", (Object[])new Object[]{view.toString()});
        }
    }

    private static void resumeSvga(SVGAImageView svgaImageView) {
        Drawable drawable2;
        if (svgaImageView == null) {
            return;
        }
        Object restartTag = svgaImageView.getTag(R.id.yy_svga_auto_pause_id);
        if (restartTag instanceof Boolean && ((Boolean)restartTag).booleanValue() && svgaImageView.getVisibility() == 0 && !svgaImageView.isAnimating() && svgaImageView.getLoopCount() <= 0 && ViewCompat.isAttachedToWindow((View)svgaImageView) && (drawable2 = svgaImageView.getDrawable()) instanceof SVGADrawable && !((SVGADrawable)drawable2).getCleared()) {
            if (drawable2.isVisible() && ViewCompat.isAttachedToWindow((View)svgaImageView)) {
                svgaImageView.startAnimation();
            }
            svgaImageView.setTag(R.id.yy_svga_auto_pause_id, (Object)false);
            if (RuntimeContext.isInGray()) {
                MLog.info((Object)"ImageAuto_SvgaAutoPause", (String)"resumeSvga:%s", (Object[])new Object[]{svgaImageView.toString()});
            }
        }
    }

    private static void resumeAnimation(View view) {
        if (view == null) {
            return;
        }
        Object tag = view.getTag(R.id.yy_animation_auto_pause_id);
        if (tag instanceof Boolean && ((Boolean)tag).booleanValue()) {
            Animation animation = view.getAnimation();
            if (animation == null || !ViewCompat.isAttachedToWindow((View)view)) {
                return;
            }
            if (view.getVisibility() == 0 && animation.getRepeatCount() == -1 && SvgaAutoPause.isAnimationCancel(animation)) {
                animation.reset();
                animation.start();
                view.setTag(R.id.yy_animation_auto_pause_id, (Object)false);
                if (RuntimeContext.isInGray()) {
                    MLog.info((Object)"ImageAuto_SvgaAutoPause", (String)"resumeAnimation: %s", (Object[])new Object[]{view.toString()});
                }
            }
        }
    }

    private static boolean isAnimationCancel(@NonNull Animation animation) {
        return animation.getStartTime() == Long.MIN_VALUE;
    }

    public static void setRecoverInterceptor(IRecoverInterceptor recoverInterceptor) {
        sRecoverInterceptor = recoverInterceptor;
    }

    public static interface IRecoverInterceptor {
        public View getRecoverView(ViewGroup var1);
    }
}

