/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect;

import android.app.Application;
import androidx.annotation.Nullable;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.IConfigListener;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.dynamicswitch.DynamicSwitchFactory;
import com.yy.base.env.MyApplication;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.LowEndMachineOptUtil;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.applicationroute.MainApplication;
import com.yy.hiyo.channel.base.ChannelDefine;
import com.yy.hiyo.module.performancemonitor.perfcollect.ImageLoad.ImagePerfOpt;
import com.yy.hiyo.module.performancemonitor.perfcollect.MemOpt.MemOpt;
import com.yy.hiyo.module.performancemonitor.perfcollect.SharedPreferences.SharedPreferencesMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.SvgaAutoPause;
import com.yy.hiyo.module.performancemonitor.perfcollect.crash.ExceptionMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.FileMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.GlobalPerfMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.memorythread.ThreadOpt;
import com.yy.hiyo.module.performancemonitor.perfcollect.network.HeartMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.network.NetWorkWrapper;
import com.yy.hiyo.module.performancemonitor.perfcollect.network.prevent.RequestPreventDuplicater;
import com.yy.hiyo.module.performancemonitor.perfcollect.yytask.TaskExecutorMonitor;
import com.yy.mobile.http.BaseNetwork;

public class PerfCollecter
extends DefaultController {
    private GlobalPerfMonitor mGlobalPerfMonitor;
    private NetWorkWrapper mNetWorkWrapper;
    private boolean mStarted;
    protected static volatile boolean sInitWhenApplication = false;

    public PerfCollecter(Environment env) {
        super(env);
        this.mGlobalPerfMonitor = new GlobalPerfMonitor(env);
        SharedPreferencesMonitor.initSharedPreferencesMonitor();
        RequestPreventDuplicater.init();
        if (SystemUtils.isShowEnvSetting()) {
            this.start();
        }
    }

    public void start() {
        if (this.mStarted) {
            return;
        }
        this.mStarted = true;
        this.mNetWorkWrapper = new NetWorkWrapper(this.mEnvironment);
        SvgaAutoPause.startOrPause();
        if (!RuntimeContext.sIsAppStartFinished) {
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS, (INotify)this);
        } else {
            this.onStartUpFinished();
        }
        this.mGlobalPerfMonitor.start();
        this.updateDownloadCallback();
        YYImageUtils.resetUseWebpFlag();
        UnifyConfig.INSTANCE.registerListener(BssCode.PERFORMANCE_CONFIG, (IConfigListener)new IConfigListener<AConfigData>(){

            public void onUpdateConfig(@Nullable AConfigData data) {
                PerfCollecter.this.onPerConfigUpdated();
            }
        });
        ExceptionMonitor.initViewMonitor();
        ImagePerfOpt.initImageLoader();
        MemOpt.start();
        this.initHeartMonitor();
    }

    private void updateDownloadCallback() {
        if (!SettingFlags.getBoolean((String)"cdndownloadusehttp", (boolean)true)) {
            BaseNetwork.setDownloadNetworkCallBack(null);
        }
    }

    public void notify(Notification notification) {
        if (notification != null && notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS) {
            this.onStartUpFinished();
        } else if (notification != null && (notification.id == NotificationDef.N_ON_TRIM_MEMORY || notification.id == NotificationDef.N_ON_LOW_MEMORY) && this.mNetWorkWrapper != null) {
            this.mNetWorkWrapper.onLowMemery();
        }
    }

    private void onStartUpFinished() {
        this.mGlobalPerfMonitor.onStartUpFinished();
        this.mNetWorkWrapper.init();
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        PerfCollecter.initLowEndMachineOptUtil();
        this.updateChannelLog();
        SharedPreferencesMonitor.onStarupFinish();
        ExceptionMonitor.onStartUpFinished();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PerfCollecter.this.onStartUpFinishedAfterThreeSecond();
            }
        }, (long)3000L);
    }

    private void onStartUpFinishedAfterThreeSecond() {
        MemOpt.onStartUpFinishedAfterThreeSecond();
        ExceptionMonitor.onStartUpFinishedAfterThreeSecond();
        ThreadOpt.onStartUpFinishedAfterThreeSecond();
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_ON_TRIM_MEMORY, this::notify);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_ON_LOW_MEMORY, this::notify);
    }

    private void updateChannelLog() {
        if (ChannelDefine.sUnEnableLog) {
            ChannelDefine.sUnEnableLog = !SettingFlags.getBoolean((String)"channellogswitch", (boolean)false);
        }
    }

    private static void initLowEndMachineOptUtil() {
        if (RuntimeContext.getPhoneType() == 1 && NAB.B.equals((Object)NewABDefine.PROPERTY_STAT_OPT.getTest())) {
            LowEndMachineOptUtil.INSTANCE.setHttpErrorCollectSwitch(false);
            LowEndMachineOptUtil.INSTANCE.setHttpMetricSwitch(false);
            LowEndMachineOptUtil.INSTANCE.setImageLoadMonitorStatSwitch(false);
            LowEndMachineOptUtil.INSTANCE.setWsMetricSwitch(false);
            LowEndMachineOptUtil.INSTANCE.setGraceNetSwitch(false);
        }
    }

    public static void onApplicationCreate(Application application) {
        if (sInitWhenApplication) {
            return;
        }
        sInitWhenApplication = true;
        ThreadOpt.onApplicationCreate(application);
        SharedPreferencesMonitor.onApplicationCreate(application);
        FileMonitor.onApplicationCreate(application);
    }

    private void onPerConfigUpdated() {
        MyApplication.onPerConfigUpdated();
        this.mGlobalPerfMonitor.onPerConfigUpdated();
        MainApplication.updateInGrayFlag();
        SharedPreferencesMonitor.onPerConfigUpdated();
        this.updateDownloadCallback();
        SvgaAutoPause.startOrPause();
        YYImageUtils.resetUseWebpFlag();
        this.updateChannelLog();
        PerfCollecter.initYYTaskExecutorMonitor();
        RequestPreventDuplicater.onConfigUpdate();
        if (this.mNetWorkWrapper != null) {
            this.mNetWorkWrapper.onConfigUpdate();
        }
    }

    public static void tryDownloadUseHttp() {
        BaseNetwork.IDownloadNetworkCallBack iDownloadNetworkCallBack = url -> url;
        if (DynamicSwitchFactory.getIDynamicSwitch().downloadUseHttp()) {
            iDownloadNetworkCallBack = url -> {
                if (URLUtils.isHttpsScheme((String)url)) {
                    MLog.debug((Object)"BaseNetwork", (String)"replace https to http %s", (Object[])new Object[]{url});
                    return URLUtils.replaceHttpsToHttp((String)url);
                }
                return url;
            };
        }
        BaseNetwork.setDownloadNetworkCallBack((BaseNetwork.IDownloadNetworkCallBack)iDownloadNetworkCallBack);
    }

    public static void initYYTaskExecutorMonitor() {
        TaskExecutorMonitor.initYYTaskExecutorMonitor();
    }

    private void initHeartMonitor() {
        HeartMonitor.initHeartMonitor();
    }
}

