/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.networkdiagnose.model.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthCdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.CellSignalStrengthLte;
import android.telephony.CellSignalStrengthWcdma;
import android.telephony.TelephonyManager;
import com.yy.hiyo.module.networkdiagnose.model.resource.wifimobile.NetBean;
import com.yy.mobile.http.HttpLog;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import java.util.List;

@SuppressLint(value={"MissingPermission"})
public class Net {
    private static final int MIN_RSSI = -100;
    private static final int MAX_RSSI = -55;

    public static String networkType(Context context) {
        NetworkInfo networkInfo;
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        if (manager != null && (networkInfo = manager.getNetworkInfo(1)) != null && networkInfo.isConnectedOrConnecting()) {
            return "WIFI";
        }
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null) {
            return "Other";
        }
        int networkType = telephonyManager.getNetworkType();
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return "2G";
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return "3G";
            }
            case 13: {
                return "4G";
            }
        }
        return "Other";
    }

    public static String networkTypeMobile(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        if (telephonyManager == null || !Net.hasSimCard(context)) {
            return "Other";
        }
        int networkType = telephonyManager.getNetworkType();
        switch (networkType) {
            case 1: {
                return "2G_GPRS";
            }
            case 2: {
                return "2G_EDGE";
            }
            case 4: {
                return "2G_CDMA";
            }
            case 7: {
                return "2G_1xRTT";
            }
            case 11: {
                return "2G_IDEN";
            }
            case 3: {
                return "3G_UMTS";
            }
            case 5: {
                return "3G_EVDO_0";
            }
            case 6: {
                return "3G_EVDO_A";
            }
            case 8: {
                return "3G_HSDPA";
            }
            case 9: {
                return "3G_HSUPA";
            }
            case 10: {
                return "3G_HSPA";
            }
            case 12: {
                return "3G_EVDO_B";
            }
            case 14: {
                return "3G_EHRPD";
            }
            case 15: {
                return "3G_SHPAP";
            }
            case 13: {
                return "4G_LTE";
            }
        }
        return "Other";
    }

    public static boolean hasSimCard(Context context) {
        boolean result = true;
        try {
            TelephonyManager telMgr = (TelephonyManager)context.getSystemService("phone");
            int simState = telMgr.getSimState();
            switch (simState) {
                case 1: {
                    result = false;
                    break;
                }
                case 0: {
                    result = false;
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    @SuppressLint(value={"MissingPermission"})
    public static int getWifiRssi(Context context) {
        try {
            WifiManager mWifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            if (mWifiManager != null) {
                WifiInfo mWifiInfo = mWifiManager.getConnectionInfo();
                return mWifiInfo.getRssi();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public static int calculateSignalLevel(int rssi) {
        if (rssi <= -100) {
            return 0;
        }
        if (rssi >= -55) {
            return 4;
        }
        float inputRange = 45.0f;
        float outputRange = 4.0f;
        return (int)((float)(rssi - -100) * outputRange / inputRange);
    }

    public static String checkSignalRssi(int level) {
        String levelStr = "\u65e0\u4fe1\u53f7";
        if (level > 4) {
            level = 4;
        }
        switch (level) {
            case 0: {
                levelStr = "\u65e0\u4fe1\u53f7";
                break;
            }
            case 1: {
                levelStr = "\u4fe1\u53f7\u5dee";
                break;
            }
            case 2: {
                levelStr = "\u4fe1\u53f7\u4e2d";
                break;
            }
            case 3: {
                levelStr = "\u4fe1\u53f7\u826f";
                break;
            }
            case 4: {
                levelStr = "\u4fe1\u53f7\u4f18";
                break;
            }
        }
        return levelStr;
    }

    public static String getClientIp() {
        String localIp = "";
        try {
            Enumeration<NetworkInterface> localEnumeration = NetworkInterface.getNetworkInterfaces();
            if (localEnumeration != null) {
                while (localEnumeration.hasMoreElements()) {
                    Enumeration<InetAddress> localEnumerationNew = localEnumeration.nextElement().getInetAddresses();
                    while (localEnumerationNew.hasMoreElements()) {
                        InetAddress inetAddress = localEnumerationNew.nextElement();
                        if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address) || inetAddress.isLinkLocalAddress()) continue;
                        return inetAddress.getHostAddress();
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localIp;
    }

    public static void getOutPutDns(NetBean netBean) {
    }

    public static boolean checkIsRoaming(Context context) {
        NetworkInfo networkInfo;
        ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        if (manager != null && (networkInfo = manager.getActiveNetworkInfo()) != null) {
            return networkInfo.isRoaming();
        }
        return false;
    }

    public static void getMobileDbm(Context context, NetBean netBean) {
        int dbm = 0;
        int level = 0;
        int asu = 0;
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (tm == null) {
                return;
            }
            List cellInfoList = tm.getAllCellInfo();
            if (null != cellInfoList) {
                for (CellInfo cellInfo : cellInfoList) {
                    if (cellInfo instanceof CellInfoGsm) {
                        CellSignalStrengthGsm cellSignalStrengthGsm = ((CellInfoGsm)cellInfo).getCellSignalStrength();
                        dbm = cellSignalStrengthGsm.getDbm();
                        level = cellSignalStrengthGsm.getLevel();
                        asu = cellSignalStrengthGsm.getAsuLevel();
                        continue;
                    }
                    if (cellInfo instanceof CellInfoCdma) {
                        CellSignalStrengthCdma cellSignalStrengthCdma = ((CellInfoCdma)cellInfo).getCellSignalStrength();
                        dbm = cellSignalStrengthCdma.getDbm();
                        level = cellSignalStrengthCdma.getLevel();
                        asu = cellSignalStrengthCdma.getAsuLevel();
                        continue;
                    }
                    if (cellInfo instanceof CellInfoLte) {
                        CellSignalStrengthLte cellSignalStrengthLte = ((CellInfoLte)cellInfo).getCellSignalStrength();
                        dbm = cellSignalStrengthLte.getDbm();
                        level = cellSignalStrengthLte.getLevel();
                        asu = cellSignalStrengthLte.getAsuLevel();
                        continue;
                    }
                    if (!(cellInfo instanceof CellInfoWcdma)) continue;
                    CellSignalStrengthWcdma cellSignalStrengthWcdma = ((CellInfoWcdma)cellInfo).getCellSignalStrength();
                    dbm = cellSignalStrengthWcdma.getDbm();
                    level = cellSignalStrengthWcdma.getLevel();
                    asu = cellSignalStrengthWcdma.getAsuLevel();
                }
            }
        }
        catch (Exception e) {
            HttpLog.e((String)("signal info:" + e.toString()), (Object[])new Object[0]);
        }
        netBean.setMobAsu(asu);
        netBean.setMobDbm(dbm);
        netBean.setMobLevel(level);
    }
}

