/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.networkdiagnose.model.resource.dns;

import com.yy.hiyo.module.networkdiagnose.model.resource.dns.DNS;
import com.yy.hiyo.module.networkdiagnose.model.resource.dns.localdns.Record;
import com.yy.hiyo.module.networkdiagnose.model.resource.dns.localdns.Resolver;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class NsLookup {
    private final String domain;
    private final String serverIp;

    private NsLookup(String domain, String serverIp) {
        this.domain = domain;
        this.serverIp = serverIp;
    }

    public static void start(String domain) {
        NsLookup.start(domain, null);
    }

    public static Result start(String domain, String serverIp) {
        String[] s;
        if (serverIp == null && (s = DNS.local()) != null) {
            serverIp = s[0];
        }
        NsLookup t = new NsLookup(domain, serverIp);
        return t.run();
    }

    private Result run() {
        if (this.serverIp == null) {
            Result r = new Result(-1, 0, null);
            return r;
        }
        Resolver r = null;
        try {
            r = new Resolver(InetAddress.getByName(this.serverIp));
        }
        catch (UnknownHostException e) {
            return new Result(-1, 0, null);
        }
        try {
            long start = System.currentTimeMillis();
            Record[] records = r.resolve(this.domain);
            long duration = System.currentTimeMillis() - start;
            return new Result(0, (int)duration, records);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new Result(-3, 0, null);
        }
    }

    public static class Result {
        public final int code;
        public final int duration;
        public final Record[] records;

        private Result(int code, int duration, Record[] records) {
            this.code = code;
            this.duration = duration;
            this.records = records;
        }
    }
}

