/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.networkdiagnose.model;

import android.content.Context;
import com.yy.appbase.http.dns.HTTPDnsUtils;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.grace.dns.HTTPHostResolver;
import com.yy.hiyo.module.networkdiagnose.model.CheckNetworkResultAct;
import com.yy.hiyo.module.networkdiagnose.model.CheckNetworkType;
import com.yy.hiyo.module.networkdiagnose.model.OnCheckProgressListener;
import com.yy.hiyo.module.networkdiagnose.model.resource.localproxy.LocalProxy;
import com.yy.hiyo.module.networkdiagnose.model.resource.localproxy.LocalProxyBean;
import com.yy.hiyo.module.networkdiagnose.model.resource.ping.PingBean;
import com.yy.hiyo.module.networkdiagnose.model.resource.ping.PingHelper;
import com.yy.hiyo.module.networkdiagnose.model.resource.wifiauth.WifiAuthBean;
import com.yy.hiyo.module.networkdiagnose.model.resource.wifiauth.WifiAuthHelper;
import com.yy.hiyo.module.networkdiagnose.model.resource.wifimobile.NetBean;
import com.yy.hiyo.module.networkdiagnose.model.resource.wifimobile.NetHelper;
import java.util.ArrayList;
import java.util.List;

public class NetworkCheckManager {
    private Context mContext;
    private List<CheckNetworkType> checkNetworkTypes = new ArrayList<CheckNetworkType>();
    private OnCheckProgressListener mOnCheckProgressListener;

    public NetworkCheckManager(Context context, OnCheckProgressListener onCheckProgressListener) {
        this.mContext = context;
        this.mOnCheckProgressListener = onCheckProgressListener;
        this.init();
    }

    private void init() {
        this.checkNetworkTypes.add(CheckNetworkType.WIFI_MOBILE_SWITCH);
        this.checkNetworkTypes.add(CheckNetworkType.WIFI_AUTH);
        this.checkNetworkTypes.add(CheckNetworkType.LOCAL_PROXY);
        this.checkNetworkTypes.add(CheckNetworkType.NSLOOKUP);
        this.checkNetworkTypes.add(CheckNetworkType.PING);
    }

    public CheckNetworkResultAct startCheckNetwork(String host) {
        if (this.checkNetworkTypes.size() == 0) {
            throw new RuntimeException("checkNetworkTypes size is 0!!!");
        }
        int progress = 0;
        int gap = 100 / (this.checkNetworkTypes.size() + 1);
        StringBuilder stringBuilder = new StringBuilder();
        block12: for (CheckNetworkType checkNetworkType : this.checkNetworkTypes) {
            int progressTmp = progress += gap;
            YYTaskExecutor.postToMainThread(() -> this.mOnCheckProgressListener.onCheckProgress(progressTmp));
            switch (checkNetworkType) {
                case WIFI_MOBILE_SWITCH: {
                    try {
                        NetBean netBean = NetHelper.getNetParam(this.mContext);
                        stringBuilder.append(netBean.toString());
                        if (netBean.isNetworkAvailable()) continue block12;
                        MLog.info((Object)"NetworkDiagnose", (String)stringBuilder.toString(), (Object[])new Object[0]);
                        return CheckNetworkResultAct.WIFI_OR_MOBILE_SWITCH_CLOSE;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
                case WIFI_AUTH: {
                    WifiAuthBean wifiAuthBean = WifiAuthHelper.getWifiAuthParam();
                    stringBuilder.append(wifiAuthBean.toString());
                    if (!wifiAuthBean.isNeedAuth) break;
                    MLog.info((Object)"NetworkDiagnose", (String)stringBuilder.toString(), (Object[])new Object[0]);
                    return CheckNetworkResultAct.WIFI_NEED_AUTH;
                }
                case NSLOOKUP: {
                    HTTPHostResolver httpHostResolver = HTTPDnsUtils.INSTANCE.getDns();
                    if (httpHostResolver == null) break;
                    List list = httpHostResolver.lookup(host);
                    if (list.size() != 0) continue block12;
                    MLog.info((Object)"NetworkDiagnose", (String)stringBuilder.toString(), (Object[])new Object[0]);
                    return CheckNetworkResultAct.DNS_RESOLVE_FAIL;
                }
                case LOCAL_PROXY: {
                    LocalProxyBean localProxyBean = LocalProxy.getLocalProxyParam();
                    stringBuilder.append(localProxyBean.toString());
                    if (!StringUtils.isNotEmpty((String)localProxyBean.proxyAddress) && localProxyBean.proxyPort == -1) break;
                    MLog.info((Object)"NetworkDiagnose", (String)stringBuilder.toString(), (Object[])new Object[0]);
                    return CheckNetworkResultAct.SET_LOCAL_PROXY_ERROR;
                }
                case PING: {
                    try {
                        PingBean pingBean = PingHelper.getPingParam(host);
                        stringBuilder.append(pingBean.toString());
                        if (pingBean.getLossRate() == 100.0f) {
                            MLog.info((Object)"NetworkDiagnose", (String)stringBuilder.toString(), (Object[])new Object[0]);
                            return CheckNetworkResultAct.PING_LOSE;
                        }
                        if (pingBean.getError() != -1) continue block12;
                        MLog.info((Object)"NetworkDiagnose", (String)stringBuilder.toString(), (Object[])new Object[0]);
                        return CheckNetworkResultAct.PING_TIMEOUT;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        break;
                    }
                }
                case PORT_SCAN: {
                    break;
                }
            }
        }
        return CheckNetworkResultAct.NONE;
    }
}

