/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.handlefileIntent.common;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.hiyo.main.R;
import java.util.ArrayList;
import java.util.List;

public class IndexBar
extends YYView {
    private float mLetterSpacingExtra;
    private OnTouchingLetterChangeListener mOnTouchingLetterChangeListener;
    private List<String> mNavigators;
    private int mFocusIndex;
    private Paint mPaint;
    private Paint mFocusPaint;
    private float mBaseLineHeight;

    public IndexBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initSetting(context, attrs);
    }

    public IndexBar(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initSetting(context, attrs);
    }

    public IndexBar(Context context) {
        super(context);
    }

    public void setOnTouchingLetterChangedListener(OnTouchingLetterChangeListener onTouchingLetterChangeListener) {
        this.mOnTouchingLetterChangeListener = onTouchingLetterChangeListener;
    }

    public void setNavigators(@NonNull List<String> navigators) {
        this.mNavigators = navigators;
    }

    private void initSetting(Context context, AttributeSet attrs) {
        this.mOnTouchingLetterChangeListener = this.getDummyListener();
        this.mNavigators = new ArrayList<String>(0);
        this.mFocusIndex = -1;
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.IndexBar);
        float textSize = typedArray.getDimension(R.styleable.IndexBar_letterSize, 8.0f);
        int letterColor = typedArray.getColor(R.styleable.IndexBar_letterColor, ContextCompat.getColor((Context)this.getContext(), (int)17170443));
        this.mLetterSpacingExtra = typedArray.getFloat(R.styleable.IndexBar_letterSpacingExtra, 1.4f);
        int focusLetterColor = typedArray.getColor(R.styleable.IndexBar_focusLetterColor, ContextCompat.getColor((Context)this.getContext(), (int)17170443));
        typedArray.recycle();
        this.mPaint = new Paint();
        this.mPaint.setTypeface(Typeface.DEFAULT_BOLD);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(letterColor);
        this.mPaint.setTextSize(textSize);
        this.mFocusPaint = new Paint();
        this.mFocusPaint.setTypeface(Typeface.DEFAULT_BOLD);
        this.mFocusPaint.setAntiAlias(true);
        this.mFocusPaint.setFakeBoldText(true);
        this.mFocusPaint.setTextSize(textSize);
        this.mFocusPaint.setColor(focusLetterColor);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.measureWidth(widthMeasureSpec), this.measureHeight(heightMeasureSpec));
    }

    private int measureWidth(int widthMeasureSpec) {
        int result;
        int specMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int specSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            result = this.getSuggestedMinWidth();
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    private int getSuggestedMinWidth() {
        String maxLengthTag = "";
        for (String tag : this.mNavigators) {
            if (maxLengthTag.length() >= tag.length()) continue;
            maxLengthTag = tag;
        }
        return (int)((double)this.mPaint.measureText(maxLengthTag) + 0.5);
    }

    private int measureHeight(int heightMeasureSpec) {
        int result;
        int specMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int specSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
        if (specMode == 0x40000000) {
            result = specSize;
        } else {
            Paint.FontMetrics fm = this.mPaint.getFontMetrics();
            float singleHeight = fm.bottom - fm.top;
            this.mBaseLineHeight = fm.bottom * this.mLetterSpacingExtra;
            result = (int)((float)this.mNavigators.size() * singleHeight * this.mLetterSpacingExtra);
            if (specMode == Integer.MIN_VALUE) {
                result = Math.min(result, specSize);
            }
        }
        return result;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int height = this.getHeight();
        int width = this.getWidth();
        if (height == 0) {
            return;
        }
        int singleHeight = height / this.mNavigators.size();
        for (int i = 0; i < this.mNavigators.size(); ++i) {
            float xPos = (float)(width / 2) - this.mPaint.measureText(this.mNavigators.get(i)) / 2.0f;
            float yPos = singleHeight * (i + 1);
            if (i == this.mFocusIndex) {
                canvas.drawText(this.mNavigators.get(i), xPos, yPos - this.mBaseLineHeight, this.mFocusPaint);
                continue;
            }
            canvas.drawText(this.mNavigators.get(i), xPos, yPos - this.mBaseLineHeight, this.mPaint);
        }
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        float y = event.getY();
        int formerFocusIndex = this.mFocusIndex;
        OnTouchingLetterChangeListener listener = this.mOnTouchingLetterChangeListener;
        int c = this.calculateOnClickItemNum(y);
        switch (event.getAction()) {
            case 1: 
            case 3: {
                this.mFocusIndex = -1;
                this.invalidate();
                listener.onTouchingEnd(this.mNavigators.get(c));
                break;
            }
            case 0: {
                listener.onTouchingStart(this.mNavigators.get(c));
                break;
            }
            default: {
                if (formerFocusIndex == c || c < 0 || c >= this.mNavigators.size()) break;
                listener.onTouchingLetterChanged(this.mNavigators.get(c));
                this.mFocusIndex = c;
                this.invalidate();
            }
        }
        return true;
    }

    private int calculateOnClickItemNum(float yPos) {
        int result = (int)(yPos / (float)this.getHeight() * (float)this.mNavigators.size());
        if (result >= this.mNavigators.size()) {
            result = this.mNavigators.size() - 1;
        } else if (result < 0) {
            result = 0;
        }
        return result;
    }

    private OnTouchingLetterChangeListener getDummyListener() {
        return new OnTouchingLetterChangeListener(){

            @Override
            public void onTouchingLetterChanged(String s) {
            }

            @Override
            public void onTouchingStart(String s) {
            }

            @Override
            public void onTouchingEnd(String s) {
            }
        };
    }

    public static interface OnTouchingLetterChangeListener {
        public void onTouchingLetterChanged(String var1);

        public void onTouchingStart(String var1);

        public void onTouchingEnd(String var1);
    }
}

