/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.home.base.startup;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.view.KeyEvent;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.DiskCacheChecker;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.constant.WindowNameDef;
import com.yy.appbase.deeplink.data.DeepLinkChannelParam;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.recommend.bean.TopTab;
import com.yy.appbase.service.home.IHomeService;
import com.yy.appbase.service.home.PageType;
import com.yy.appbase.service.home.PartyParam;
import com.yy.appbase.service.home.PlayTabParam;
import com.yy.appbase.service.home.PlayTabType;
import com.yy.appbase.wake.AppWakeStat;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.StatusBarManager;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.app.IMain;
import com.yy.hiyo.app.MainController;
import com.yy.hiyo.app.ServiceManager;
import com.yy.hiyo.applicationroute.stat.AppProcessStat;
import com.yy.hiyo.game.kvomodule.GameInfoModule;
import com.yy.hiyo.main.R;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class MainActivityProxy {
    private static final String TAG = "MainActivityProxy";
    private final FragmentActivity mActivity;
    private IMain mApplicationController;
    private boolean mBackGround = false;
    private boolean mIsBackToHome = false;
    @Nullable
    private Boolean mIsNew4V4HandleBackPress = null;
    private long mExitTime = 0L;

    public MainActivityProxy(FragmentActivity activity) {
        this.mActivity = activity;
        if (this.mApplicationController == null) {
            this.mApplicationController = new MainController(this.mActivity);
        }
    }

    public void onCreate(Intent intent) {
        MLog.info((Object)TAG, (String)"onCreate!", (Object[])new Object[0]);
        this.mApplicationController.onCreate(this.mActivity, intent);
        ThirdTrackHelper.INSTANCE.startTracking((Context)this.mActivity.getApplication());
        this.setStatusBar();
        AppWakeStat.INSTANCE.onCreate(intent);
    }

    public void onNewIntent(Intent intent) {
        MLog.info((Object)TAG, (String)"onNewIntent!", (Object[])new Object[0]);
        this.mApplicationController.onNewIntent(intent);
        AppWakeStat.INSTANCE.onNewIntent(intent);
    }

    public void setBackToHomeStatus(boolean isBackToHome) {
        this.mIsBackToHome = isBackToHome;
    }

    public void onStart() {
        MLog.info((Object)TAG, (String)"onStart!", (Object[])new Object[0]);
        if (this.mIsBackToHome) {
            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.MSG_PRCESS_HOT_OPEN);
        }
        this.setBackToHomeStatus(false);
    }

    public void onResume() {
        MLog.info((Object)TAG, (String)"onResume!", (Object[])new Object[0]);
        if (this.mBackGround) {
            FileStorageUtils.getInstance().onForeGroundChange(true);
        }
        this.mBackGround = false;
        RuntimeContext.sIsForeground = true;
        DiskCacheChecker.onForeGroundChange((boolean)true);
        if (RuntimeContext.sIsAppStartFinished) {
            NotificationCenter.getGlobalInstance().notify(new Notification(NotificationDef.N_FOREGROUND_CHANGE, (Object)RuntimeContext.sIsForeground));
            RuntimeContext.onForeGroundChanged((boolean)true);
        }
        NotificationCenter.getGlobalInstance().notify(new Notification(NotificationIdDef.PERMISSION_ON_RESUME, (Object)RuntimeContext.sIsForeground));
        HiidoStatis.onResume((long)AccountUtil.getUid(), (Activity)this.mActivity);
        AppProcessStat.statAppProcessAlive();
        AppWakeStat.INSTANCE.onResume();
    }

    public void onPause() {
        MLog.info((Object)TAG, (String)"onPause!", (Object[])new Object[0]);
        this.mBackGround = true;
        RuntimeContext.sIsForeground = false;
        DiskCacheChecker.onForeGroundChange((boolean)false);
        FileStorageUtils.getInstance().onForeGroundChange(false);
        NotificationCenter.getGlobalInstance().notify(new Notification(NotificationDef.N_FOREGROUND_CHANGE, (Object)RuntimeContext.sIsForeground));
        HiidoStatis.onPause((Activity)this.mActivity, (int)1);
        HiidoEvent event = HiidoEvent.obtain().eventId("20035569").put("function_id", "outapp");
        HiidoStatis.reportEvent((HiidoEvent)event);
        RuntimeContext.onForeGroundChanged((boolean)false);
    }

    public void onStop() {
        MLog.info((Object)TAG, (String)"onStop!", (Object[])new Object[0]);
        this.mApplicationController.onStop();
        NotificationCenter.getGlobalInstance().notify(new Notification(NotificationDef.N_MAIN_ACTIVITY_STOP));
        AppWakeStat.INSTANCE.onStop();
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        NotificationCenter.getGlobalInstance().notify(new Notification(NotificationDef.N_FOCUS_CHANGE, (Object)hasFocus));
        DialogLinkManager.onMainActivityWindowFocusChanged((boolean)hasFocus);
    }

    public int dispatchKeyEvent(KeyEvent event) {
        Object obj;
        if (!RuntimeContext.sIsAppStartFinished) {
            return 0;
        }
        if (event.getKeyCode() == 4 && event.getAction() == 1 && (obj = MsgDispatcher.getInstance().sendMessageSync(BaseMsgDef.SYNC_MSG_BACK_KEY_EVENT, (Object)event)) instanceof Integer) {
            return (Integer)obj;
        }
        return 0;
    }

    public boolean onBackPressed() {
        MLog.info((Object)TAG, (String)"onBackPressed!", (Object[])new Object[0]);
        if (this.mApplicationController.onBackPress()) {
            return true;
        }
        if (System.currentTimeMillis() - this.mExitTime > 2000L) {
            boolean isDrainageToTab = this.handlerBackPressed();
            if (!isDrainageToTab) {
                this.mExitTime = System.currentTimeMillis();
            }
            return true;
        }
        this.mApplicationController.onDoubleClickBack();
        return false;
    }

    private boolean handlerBackPressed() {
        ToastUtils.showToast((Context)this.mActivity, (String)ResourceUtils.getString((int)R.string.app_exit), (int)0);
        return false;
    }

    private boolean handleHomePageV4() {
        if (this.mIsNew4V4HandleBackPress == null) {
            this.mIsNew4V4HandleBackPress = SettingFlags.getBoolean((String)"new_for_v4_handle_back_press", (boolean)true);
            SettingFlags.setBoolean((String)"new_for_v4_handle_back_press", (boolean)false);
        }
        if (!this.mIsNew4V4HandleBackPress.booleanValue()) {
            return false;
        }
        if (KvoModuleManager.getModule(GameInfoModule.class) != null && ((GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class)).getAllPlayInfos() != null && ((GameInfoModule)KvoModuleManager.getModule(GameInfoModule.class)).getAllPlayInfos().size() <= 0) {
            PlayTabType currentPlayTabType;
            IHomeService iHomeService;
            PageType currentPageType;
            boolean isNotHomePage = this.isNotAtHome();
            ServiceManager serviceManager = ServiceManager.getInstance();
            if (!isNotHomePage && serviceManager.hasRegisterService(IHomeService.class) && (currentPageType = (iHomeService = ServiceManager.getInstance().getService(IHomeService.class)).getCurrentPageType()) == PageType.PLAY && iHomeService.getPlayData() != null && (currentPlayTabType = iHomeService.getPlayData().getTab()) != PlayTabType.GAME) {
                iHomeService.toPlay(PlayTabType.GAME, null);
                return true;
            }
        }
        return false;
    }

    private boolean drainageTo() {
        boolean isHomePage = !this.isNotAtHome();
        ServiceManager serviceManager = ServiceManager.getInstance();
        if (isHomePage && serviceManager.hasRegisterService(IHomeService.class)) {
            boolean inChanelTab;
            IHomeService homeService = serviceManager.getService(IHomeService.class);
            PageType currentPageType = homeService.getCurrentPageType();
            boolean bl = inChanelTab = homeService.isInLiveTab() || homeService.isInPartyTab();
            if (!(currentPageType != PageType.PLAY && currentPageType != PageType.DISCOVERY || inChanelTab)) {
                DeepLinkChannelParam param = new DeepLinkChannelParam();
                param.setTargetChannelTopBar(TopTab.TYPE_SHOW);
                param.setNeedRefreshData(true);
                homeService.toPlay(PlayTabType.PARTY, (PlayTabParam)new PartyParam(7, param, 0));
                return true;
            }
        }
        ToastUtils.showToast((Context)this.mActivity, (String)ResourceUtils.getString((int)R.string.app_exit), (int)0);
        return false;
    }

    private boolean isNotAtHome() {
        ServiceManager serviceManager = ServiceManager.getInstance();
        boolean isNotHomePage = !serviceManager.inited() || serviceManager.getBaseEnv() == null || serviceManager.getBaseEnv().getWindowManager() == null || serviceManager.getBaseEnv().getWindowManager().getCurrentWindow() == null || !WindowNameDef.isHomePage((String)serviceManager.getBaseEnv().getWindowManager().getCurrentWindow().getName());
        return isNotHomePage;
    }

    public void onDestroy() {
        MLog.info((Object)TAG, (String)"onDestroy!", (Object[])new Object[0]);
        this.mApplicationController.onAppDestroy();
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        MLog.info((Object)TAG, (String)"requestCode:%d!", (Object[])new Object[]{requestCode});
        this.mApplicationController.onActivityResult(requestCode, resultCode, data);
    }

    private void setStatusBar() {
        if (StatusBarManager.INSTANCE.isTranslucent(null)) {
            StatusBarManager.INSTANCE.setTranslucent((Activity)this.mActivity, null, true, 0, null);
        } else if (StatusBarManager.INSTANCE.isSupportStatusBar()) {
            int statusBarMode = SettingFlags.getIntValue((String)"status_bar_mode", (int)0);
            if (statusBarMode == 0) {
                boolean isMIUIMode = StatusBarManager.INSTANCE.setInitTransparentState((Activity)this.mActivity, true, false);
                if (isMIUIMode) {
                    SettingFlags.setIntValue((String)"status_bar_mode", (int)1);
                } else {
                    SettingFlags.setIntValue((String)"status_bar_mode", (int)2);
                }
            } else if (statusBarMode == 1) {
                StatusBarManager.INSTANCE.setInitTransparentState((Activity)this.mActivity, false, true);
            } else if (statusBarMode == 2) {
                StatusBarManager.INSTANCE.setInitTransparentState((Activity)this.mActivity, false, false);
            }
        }
    }
}

