/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.applicationroute;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class SignatureCheck {
    public static final String SHA1 = "SHA256";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getSignaturesFromApk(File file) throws IOException {
        ArrayList<String> signatures = new ArrayList<String>();
        JarFile jarFile = new JarFile(file);
        try {
            JarEntry je = jarFile.getJarEntry("classes.dex");
            byte[] readBuffer = new byte[8192];
            Certificate[] certs = SignatureCheck.loadCertificates(jarFile, je, readBuffer);
            if (certs != null) {
                for (Certificate c : certs) {
                    String sig = SignatureCheck.toCharsString(c.getEncoded());
                    signatures.add(sig);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return signatures;
    }

    private static Certificate[] loadCertificates(JarFile jarFile, JarEntry je, byte[] readBuffer) {
        try {
            InputStream is = jarFile.getInputStream(je);
            while (is.read(readBuffer, 0, readBuffer.length) != -1) {
            }
            is.close();
            return je != null ? je.getCertificates() : null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static String toCharsString(byte[] sigBytes) {
        byte[] sig = sigBytes;
        int n = sig.length;
        int n2 = n * 2;
        char[] text = new char[n2];
        for (int j = 0; j < n; ++j) {
            byte v = sig[j];
            int d = v >> 4 & 0xF;
            text[j * 2] = (char)(d >= 10 ? 97 + d - 10 : 48 + d);
            d = v & 0xF;
            text[j * 2 + 1] = (char)(d >= 10 ? 97 + d - 10 : 48 + d);
        }
        return new String(text);
    }

    public static String getSingInfo(Context context, String packageName, String type2) {
        Signature[] signs;
        String tmp = null;
        for (Signature sig : signs = SignatureCheck.getSignatures(context, packageName)) {
            if (!SHA1.equals(type2)) continue;
            tmp = SignatureCheck.getSignatureString(sig, SHA1);
            break;
        }
        return tmp;
    }

    public static Signature[] getSignatures(Context context, String packageName) {
        PackageInfo packageInfo = null;
        try {
            packageInfo = context.getPackageManager().getPackageInfo(packageName, 64);
            return packageInfo.signatures;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getSignatureString(Signature sig, String type2) {
        byte[] hexBytes = sig.toByteArray();
        String fingerprint = "error!";
        try {
            MessageDigest digest = MessageDigest.getInstance(type2);
            if (digest != null) {
                byte[] digestBytes = digest.digest(hexBytes);
                StringBuilder sb = new StringBuilder();
                for (byte digestByte : digestBytes) {
                    sb.append(Integer.toHexString(digestByte & 0xFF | 0x100).substring(1, 3));
                }
                fingerprint = sb.toString();
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return fingerprint;
    }
}

