/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.wrapper;

import android.content.Context;
import android.os.Build;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.push.NotificationSwitchSetting;
import com.yy.appbase.push.PushShowLimitManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.NotificationsUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.hiyo.app.wrapper.BaseWrapper;
import com.yy.hiyo.push.base.PushSDKHelper;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

class PushWrapper
extends BaseWrapper {
    PushWrapper() {
    }

    @Override
    public void onStartUpFinish() {
        PushShowLimitManager.init();
    }

    @Override
    public void onLoginSuccess() {
        final long uid = AccountUtil.getUid();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PushSDKHelper.getPushService().getPushHelper().bindAccount(Long.valueOf(uid));
                PushSDKHelper.getPushService().getPushHelper().uploadTag();
            }
        });
    }

    @Override
    public void onStartUpFinishAfterThreeSecond() {
        long uid = AccountUtil.getUid();
        if (uid > 0L) {
            PushSDKHelper.getPushService().getPushHelper().bindAccount(Long.valueOf(uid));
        }
        this.reportPushOpenEvent();
        YYTaskExecutor.getDefaultIdleExecutor().execute(new Runnable(){

            @Override
            public void run() {
                SettingFlags.setStringValue((String)"date", (String)DateUtils.getNow());
            }
        });
    }

    private void reportPushOpenEvent() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean isSwitch = NotificationsUtils.isNotificationEnabled((Context)PushWrapper.this.baseEnv.getContext());
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025571").put("function_id", "app_start").put("switch_state", isSwitch ? "1" : "2").put("notify_state", NotificationSwitchSetting.getSwitchStat()).put("backgroud_restricted", PushWrapper.this.getRestricted()));
            }
        });
    }

    private String getRestricted() {
        String restricted = "0";
        if (Build.VERSION.SDK_INT >= 28) {
            SystemServiceUtils.getActivityManager((Context)RuntimeContext.sApplicationContext).isBackgroundRestricted();
        }
        restricted = "1";
        return restricted;
    }
}

