/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.wrapper;

import android.app.Activity;
import android.content.Context;
import android.location.LocationManager;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import biz.UserInfo;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.LoginUpdateInfoBean;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.util.AgeUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.startup.ActivityStackManager;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemServiceUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.app.wrapper.BaseWrapper;
import com.yy.hiyo.login.base.LoginBaseMsgDef;
import com.yy.hiyo.login.base.OnReportCallback;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.location.ILocationChangedListener;
import com.yy.location.LocationHelper;
import com.yy.location.LocationInfo;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import common.Header;
import ikxd.nearby.ULbs;
import ikxd.nearby.ULbsReportLocationReq;
import ikxd.nearby.ULbsUri;
import java.util.HashMap;

class LocationReportWrapper
extends BaseWrapper {
    private static final String TAG = "LocationReportWrapper";
    private long uid = 0L;
    private volatile int mReportLocationTimes;
    private OnKSProfileListCallback mIGetUserExtraInfoCallback;
    private ILocationChangedListener mLocationChangedListener = new ILocationChangedListener(){

        public void onLocationFailed(int errorCode, String errorMsg) {
        }

        public void onLocationChanged(LocationInfo info, boolean isCache) {
            String city = "";
            if (info != null) {
                city = info.getCity();
            }
            if (info != null) {
                LocationReportWrapper.this.updateLoginInfo(city, String.valueOf(info.getLongitude()), String.valueOf(info.getLatitude()));
            } else {
                LocationReportWrapper.this.updateLoginInfo(city, "", "");
            }
            LocationReportWrapper.this.doReportLocationToLbs(info);
        }
    };

    LocationReportWrapper() {
    }

    @Override
    void onStartUpFinish() {
        if (AccountUtil.getUid() > 0L) {
            this.reportLocation();
        }
    }

    @Override
    public void onLoginProcessCompleted() {
        this.reportLocation();
    }

    @Override
    public void onLoginSuccess() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                LocationReportWrapper.this.reportLocation();
            }
        }, (long)2000L);
    }

    @Override
    public void onLoginout(long oldUid) {
        LocationHelper.removeLocationListener((ILocationChangedListener)this.mLocationChangedListener);
        this.mReportLocationTimes = 0;
    }

    private void reportLocation() {
        LocationInfo info = LocationHelper.getLocationInfo((boolean)true);
        String location = "";
        LocationHelper.addLocationListener((ILocationChangedListener)this.mLocationChangedListener);
        if (info == null) {
            this.updateLoginInfo(location, "", "");
        } else {
            location = info.getCity();
            this.updateLoginInfo(location, String.valueOf(info.getLongitude()), String.valueOf(info.getLatitude()));
        }
        this.doReportLocationToLbs(info);
    }

    private void updateLoginInfo(String city, String longitude, String latitude) {
        MLog.info((Object)TAG, (String)"updateLoginInfo city: %s, longitude: %s, latitude: %s", (Object[])new Object[]{city, longitude, latitude});
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("city", city);
        map.put("longitude", longitude);
        map.put("latitude", latitude);
        map.put("callBack", new OnReportCallback(){

            public void onSuccess(LoginUpdateInfoBean info) {
                try {
                    if (info != null && info.mUserInfo != null && info.mLoginInfo != null) {
                        IUserInfoService service = (IUserInfoService)LocationReportWrapper.this.getServiceManager().getService(IUserInfoService.class);
                        UserInfoKS userInfo = service.getUserInfo(AccountUtil.getUid());
                        userInfo.setValue("lastLoginLocation", (Object)info.mLoginInfo.mLastLoginLocation);
                        userInfo.setValue("locationTude", (Object)info.mUserInfo.location_tude);
                        service.saveUserInfo(userInfo);
                        String birthday = info.mUserInfo.birthday;
                        if (AgeUtils.isAgeInValid((String)birthday) || AgeUtils.isOldAmericaUser((String)birthday)) {
                            MLog.info((Object)LocationReportWrapper.TAG, (String)"user isAgeInValid ", (Object[])new Object[0]);
                            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.SHOW_AGE_INVALID);
                            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.OPEN_PROFILE_WINDOW_RESET_AGE, (Object)LocationReportWrapper.this.transfer(info));
                        }
                        if (info.mLoginInfo.mFirstLoginTime > 0L) {
                            AccountUtil.updateRegisterTimes((long)(info.mLoginInfo.mFirstLoginTime * 1000L));
                        }
                    }
                    LocationReportWrapper.this.mReportLocationTimes++;
                    if (LocationReportWrapper.this.mReportLocationTimes <= 1) {
                        ((IUserInfoService)LocationReportWrapper.this.getServiceManager().getService(IUserInfoService.class)).requestUserInfoFromServer(AccountUtil.getUid(), LocationReportWrapper.this.mIGetUserExtraInfoCallback);
                    }
                }
                catch (Exception e) {
                    MLog.error((Object)LocationReportWrapper.TAG, (String)("updateLoginInfo error: " + e.toString()), (Object[])new Object[0]);
                }
            }

            public void onError(int errorCode, String errorDescription) {
            }
        });
        Message message = new Message();
        message.obj = map;
        message.what = LoginBaseMsgDef.MSG_REPORT_LOCATION;
        MsgDispatcher.getInstance().sendMessage(message);
    }

    private static boolean isOpenLocService() {
        LocationManager locationManager = SystemServiceUtils.getLocationManager((Context)RuntimeContext.sApplicationContext);
        if (locationManager == null) {
            return false;
        }
        try {
            return locationManager.isProviderEnabled("gps") || locationManager.isProviderEnabled("network");
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
            return false;
        }
    }

    private void addLocationStat(final LocationInfo locationInfo) {
        boolean hasLocationPermission = false;
        Activity activity = ActivityStackManager.getInstance().getMainActivity();
        if (activity == null) {
            MLog.error((Object)TAG, (String)"doReportLocationToLbs activity is null", (Object[])new Object[0]);
        } else {
            hasLocationPermission = PermissionHelper.hasLocationPermissionNotRequest((Activity)activity);
        }
        final boolean finalFasLocationPermission = hasLocationPermission;
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean isOpenLocation = LocationReportWrapper.isOpenLocService();
                boolean hasLocationInfo = locationInfo != null && locationInfo.getLatitude() != 0.0 && locationInfo.getLongitude() != 0.0;
                MLog.info((Object)LocationReportWrapper.TAG, (String)("doReportLocationToLbs isOpenLocation: " + isOpenLocation + ", hasLocationPermission: " + finalFasLocationPermission + ", hasLocationInfo: " + hasLocationInfo), (Object[])new Object[0]);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025229").put("page", RuntimeContext.sCurWin).put("function_id", "location_upload").put("hago_locaiton_access", finalFasLocationPermission ? "1" : "2").put("phone_location_switch", isOpenLocation ? "1" : "2").put("locaiton_value", hasLocationInfo ? "1" : "2"));
            }
        });
    }

    private void doReportLocationToLbs(LocationInfo locationInfo) {
        long uid = AccountUtil.getUid();
        MLog.info((Object)TAG, (String)("doReportLocationToLbs locationInfo: " + (locationInfo == null ? "null" : locationInfo.toString()) + ", uid: " + uid), (Object[])new Object[0]);
        this.addLocationStat(locationInfo);
        if (locationInfo == null || uid <= 0L) {
            return;
        }
        IUserInfoService iUserInfoService = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
        if (iUserInfoService == null) {
            MLog.error((Object)TAG, (String)"doReportLocationToLbs userinfo service is null", (Object[])new Object[0]);
            return;
        }
        ULbsReportLocationReq req2 = new ULbsReportLocationReq.Builder().longitude(Float.valueOf((float)locationInfo.getLongitude())).latitude(Float.valueOf((float)locationInfo.getLatitude())).country(locationInfo.getCountry()).province(locationInfo.getProvince()).city(locationInfo.getCity()).sex(Long.valueOf(iUserInfoService.getUserInfo((long)uid).sex)).build();
        Header header = new Header.Builder().sname("ikxd_nearby_d").code(Long.valueOf(0L)).lang(SystemUtils.getLangAndCountry()).back_ground(Boolean.valueOf(!RuntimeContext.sIsForeground)).build();
        ULbs uLbs = new ULbs.Builder().header(header).uri(ULbsUri.kUriULbsReportLocationReq).report_location_req(req2).build();
        ProtoManager.getInstance().send((AndroidMessage)uLbs, (IProtoCallback)new IProtoCallback<ULbs>(){

            public void onResponse(@NonNull ULbs message, long code, String msgTip) {
                super.onResponse((AndroidMessage)message, code, msgTip);
                MLog.info((Object)LocationReportWrapper.TAG, (String)("doReportLocationToLbs code: " + code), (Object[])new Object[0]);
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                MLog.warn((Object)LocationReportWrapper.TAG, (String)"doReportLocationToLbs retryWhenTimeout", (Object[])new Object[0]);
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                MLog.error((Object)LocationReportWrapper.TAG, (String)"doReportLocationToLbs retryWhenError reason: %s, code: %s", (Object[])new Object[]{reason, code});
                return false;
            }
        });
    }

    @Nullable
    private UserInfo.Builder transfer(LoginUpdateInfoBean bean) {
        LoginUpdateInfoBean.LoginUpdateUserInfoBean userInfoBean = bean.mUserInfo;
        if (bean.mUserInfo == null || bean.mUserInfo.uid == null || bean.mUserInfo.ver == null) {
            return null;
        }
        UserInfo.Builder builder = new UserInfo.Builder();
        if (bean.mLoginInfo.mLastLoginLocation != null) {
            builder.last_login_location(bean.mLoginInfo.mLastLoginLocation);
        }
        if (userInfoBean.vid != null) {
            builder.vid(userInfoBean.vid);
        }
        if (userInfoBean.vlv != null) {
            builder.vlv(userInfoBean.vlv);
        }
        if (userInfoBean.lltime != null) {
            builder.last_login_time(userInfoBean.lltime);
        }
        if (userInfoBean.nick != null) {
            builder.nick(userInfoBean.nick);
        }
        if (userInfoBean.sign != null) {
            builder.sign(userInfoBean.sign);
        }
        if (userInfoBean.sex != null) {
            builder.sex(userInfoBean.sex);
        }
        if (userInfoBean.avatar != null) {
            builder.avatar(userInfoBean.avatar);
        }
        if (userInfoBean.ver != null) {
            builder.ver(userInfoBean.ver);
        }
        if (userInfoBean.hide_location != null) {
            builder.hide_location(userInfoBean.hide_location);
        }
        if (userInfoBean.hide_recomm != null) {
            builder.hide_recomm(userInfoBean.hide_recomm);
        }
        if (userInfoBean.hn != null) {
            builder.hn(userInfoBean.hn);
        }
        if (userInfoBean.hometown != null) {
            builder.hometown(userInfoBean.hometown);
        }
        if (userInfoBean.birthday != null) {
            builder.birthday(userInfoBean.birthday);
        }
        if (userInfoBean.job != null) {
            builder.job(userInfoBean.job);
        }
        if (userInfoBean.ovid != null) {
            builder.ovid(userInfoBean.ovid);
        }
        if (userInfoBean.atype != null) {
            builder.atype(userInfoBean.atype);
        }
        if (userInfoBean.update_type != null) {
            builder.update_type(userInfoBean.update_type);
        }
        if (userInfoBean.om != null) {
            builder.on_micro(userInfoBean.om);
        }
        if (userInfoBean.location_tude != null) {
            builder.location_tude(userInfoBean.location_tude);
        }
        if (userInfoBean.country != null) {
            builder.country(userInfoBean.country);
        }
        if (userInfoBean.region != null) {
            builder.region(userInfoBean.region);
        }
        if (userInfoBean.labels != null) {
            builder.label_ids(userInfoBean.labels);
        }
        if (userInfoBean.certifications != null) {
            builder.certifications(userInfoBean.certifications);
        }
        return builder;
    }

    public void handleMessage(Message msg) {
        if (BaseMsgDef.MSG_GET_USER_EXTRA_INFO == msg.what && msg.obj instanceof OnKSProfileListCallback) {
            MLog.info((Object)TAG, (String)"MSG_GET_USER_EXTRA_INFO, mReportLocationTimes=%s", (Object[])new Object[]{this.mReportLocationTimes});
            this.mIGetUserExtraInfoCallback = (OnKSProfileListCallback)msg.obj;
            if (this.mReportLocationTimes >= 1) {
                ((IUserInfoService)this.getServiceManager().getService(IUserInfoService.class)).requestUserInfoFromServer(AccountUtil.getUid(), this.mIGetUserExtraInfoCallback);
            }
        }
    }
}

