/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.wrapper;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.guid.GuidFactory;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.app.wrapper.BaseWrapper;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.yylite.commonbase.crash.CrashSdk;
import com.yy.yylite.commonbase.crash.ICrashCallBack;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

class CrashWrapper
extends BaseWrapper {
    GameLifeWrapper mGameLifeWrapper;

    CrashWrapper() {
    }

    @Override
    public void onApplicationCreate() {
        CrashSdk.INSTANCE.addExtend("abi", "abi32");
    }

    @Override
    public void onBaseEnvInit(Environment baseEnv) {
        super.onBaseEnvInit(baseEnv);
        this.monitorCrash();
    }

    @Override
    public void onForegroundChange(boolean fore) {
        CrashSdk.INSTANCE.addExtend("foreground", RuntimeContext.sIsForeground ? "1" : "0");
    }

    @Override
    public void onStartUpFinishAfterOneSecond() {
        CrashSdk.INSTANCE.addExtend("foreground", RuntimeContext.sIsForeground ? "1" : "0");
        CrashSdk.INSTANCE.addExtend("country", AccountUtil.realCountry());
        if (this.getServiceManager().hasRegisterService(IGameCenterService.class)) {
            this.getServiceManager().observeService(IGameCenterService.class, (Callback)new Callback<IGameCenterService>(){

                public void onResponse(IGameCenterService data) {
                    CrashWrapper.this.watchGame();
                }
            });
        } else {
            this.watchGame();
        }
    }

    private void watchGame() {
        IGameCenterService gameCenterService = (IGameCenterService)this.getServiceManager().getService(IGameCenterService.class);
        if (gameCenterService != null) {
            GameInfo gameInfo;
            if (gameCenterService.isPlaying() && (gameInfo = gameCenterService.getCurPlayingGame()) != null) {
                CrashSdk.INSTANCE.addExtend("gameId", gameInfo.getGid());
                ProtoManager.getInstance().setGameId(gameInfo.getGid());
            }
            GameLifeWrapper gameLifeWrapper = this.getmGameLifeWrapper();
            gameCenterService.registerGameLifecycle((IGameLifecycle)gameLifeWrapper);
        }
    }

    private void monitorCrash() {
        CrashSdk.INSTANCE.setCrashCallBack(new ICrashCallBack(){

            public void crashCallback(final String crashId, final boolean isNativeCrash, final String dumpFile) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        StatisContent statContent = new StatisContent();
                        statContent.put("act", "hagoperf");
                        statContent.put("sfield", GuidFactory.getInstance().getGuid());
                        statContent.put("sfieldtwo", crashId);
                        statContent.put("ifield", isNativeCrash ? 1 : 0);
                        statContent.put("sfieldthree", dumpFile);
                        statContent.put("perftype", "crash");
                        HiidoStatis.reportContent((StatisContent)statContent);
                    }
                });
                MLog.logAllThreadInfo((String)"Crash Happen");
                MsgDispatcher.getInstance().sendMessageSync(MsgDef.PRINT_APP_WINDOW_SWITCH_PROCESS);
            }

            public void report(String errorDesc) {
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("perftype", "error_stat");
                statContent.put("sfield", errorDesc);
                HiidoStatis.reportContent((StatisContent)statContent);
            }
        });
    }

    public GameLifeWrapper getmGameLifeWrapper() {
        if (this.mGameLifeWrapper == null) {
            this.mGameLifeWrapper = new GameLifeWrapper(){

                public void onLoadGameFinish(GamePlayContext context, int finishType, DefaultWindow window) {
                    if (context == null || context.getGameInfo() == null) {
                        return;
                    }
                    CrashSdk.INSTANCE.addExtend("GameId", context.getGameInfo().getGid());
                    ProtoManager.getInstance().setGameId(context.getGameInfo().getGid());
                }

                public void onGameExited(GamePlayContext context, int gameExitType) {
                    CrashSdk.INSTANCE.addExtend("GameId", "");
                    ProtoManager.getInstance().setGameId("");
                }
            };
        }
        return this.mGameLifeWrapper;
    }
}

