/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.web.preload.downloader;

import android.content.Context;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.dowload.DownloadBussinessGroup;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.app.web.preload.MyFileUtil;
import com.yy.hiyo.app.web.preload.config.ConfigManager;
import com.yy.hiyo.app.web.preload.config.ProjectConfigItem;
import com.yy.hiyo.app.web.preload.config.download.WebIncrementItem;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.hiyo.game.service.protocol.GameLifeWrapper;
import com.yy.hiyo.game.service.protocol.IGameLifecycle;
import com.yy.hiyo.game.service.protocol.IMatchGameLifecycle;
import com.yy.hiyo.game.service.protocol.ITeamMatchLifecycle;
import com.yy.hiyo.mvp.base.ExtensionsKt;
import downloader.Downloader;
import downloader.IDownloadCallback;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class WebResDownloader
extends DefaultController {
    private static final String TAG = "Web_Preload_ResDownloader";
    private static final int MAX_PRELOAD_NUM = 3;
    private IQueueTaskExecutor mTaskExecutor;
    private ArrayList<ProjectConfigItem> mProjectToPreload;
    private MyDownloader mCurDownloader;
    private IDownloadCallback mDownloadCallBack;
    private DownloadStateManager mDownloadStateManager;
    private boolean mHasPreloadFilesChecked;
    private int mHasPreloadNumed = 0;
    private boolean mWriteFileError = false;
    private int mErrorTimes = 0;
    private boolean mRegisterNotify;
    private IWebResDownloadCallBack resDownloadCallBack;

    public WebResDownloader(Environment env, IWebResDownloadCallBack callBack) {
        super(env);
        this.resDownloadCallBack = callBack;
        this.mDownloadStateManager = new DownloadStateManager(this.getServiceManager());
    }

    public void preload(final List<ProjectConfigItem> projects) {
        if (projects == null || projects.size() <= 0) {
            return;
        }
        MLog.error((Object)TAG, (String)"preload size:%d", (Object[])new Object[]{projects.size()});
        this.getTaskExecutor().execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                IDownloadCallback forDownloadCallBack = null;
                ProjectConfigItem curForceDownloadingItem = null;
                if (WebResDownloader.this.mCurDownloader != null && ((WebResDownloader)WebResDownloader.this).mCurDownloader.forceDownloading) {
                    curForceDownloadingItem = WebResDownloader.this.mCurDownloader != null ? ((WebResDownloader)WebResDownloader.this).mCurDownloader.data : null;
                    forDownloadCallBack = ((WebResDownloader)WebResDownloader.this).mCurDownloader.forDownloadCallBack;
                }
                WebResDownloader.this.stopCurDownloader();
                ArrayList arrayList = new ArrayList(projects.size());
                ArrayList<ProjectConfigItem> itemsToDelete = new ArrayList<ProjectConfigItem>(2);
                for (ProjectConfigItem item : arrayList) {
                    if (item == null || StringUtils.isEmpty((String)item.zipMd5) || StringUtils.isEmpty((String)item.name) || StringUtils.isEmpty((String)item.zipUrl) || !item.zipUrl.startsWith("http")) {
                        itemsToDelete.add(item);
                        MLog.error((Object)WebResDownloader.TAG, (String)"unvalid project :%s \u8bf7\u68c0\u67e5\u914d\u7f6e", (Object[])new Object[]{item != null ? item.name : "\u540d\u79f0\u4e3a\u7a7a"});
                        continue;
                    }
                    if (item == null || curForceDownloadingItem == null || !StringUtils.equal((String)item.name, (String)curForceDownloadingItem.name) || !StringUtils.equal((String)item.zipMd5, (String)curForceDownloadingItem.zipMd5)) continue;
                    itemsToDelete.add(item);
                }
                arrayList.removeAll(itemsToDelete);
                arrayList.addAll(projects);
                if (!WebResDownloader.this.mHasPreloadFilesChecked) {
                    WebResDownloader.this.checkAllPreloadFile(arrayList);
                    WebResDownloader.this.mHasPreloadFilesChecked = true;
                }
                WebResDownloader.this.removeAllPreloaded(arrayList);
                if (arrayList.size() <= 0) {
                    MLog.info((Object)WebResDownloader.TAG, (String)"%d projects has preloaded! Now no project to preload!", (Object[])new Object[]{projects.size()});
                } else {
                    Collections.sort(arrayList);
                    WebResDownloader.this.mProjectToPreload = arrayList;
                    MLog.info((Object)WebResDownloader.TAG, (String)"%d projects has preloaded! Now %d projects to preload!", (Object[])new Object[]{projects.size() - WebResDownloader.this.mProjectToPreload.size(), WebResDownloader.this.mProjectToPreload.size()});
                    if (curForceDownloadingItem != null) {
                        WebResDownloader.this.mProjectToPreload.remove(curForceDownloadingItem);
                        WebResDownloader.this.mProjectToPreload.add(0, curForceDownloadingItem);
                    }
                    WebResDownloader.this.executeNext(curForceDownloadingItem, forDownloadCallBack);
                }
            }
        }, 0L);
    }

    public void preloadItemNow(final ProjectConfigItem project, final IDownloadCallback callback) {
        if (project == null || StringUtils.isEmpty((String)project.zipMd5) || StringUtils.isEmpty((String)project.name) || StringUtils.isEmpty((String)project.zipUrl) || !project.zipUrl.startsWith("http")) {
            if (callback != null) {
                callback.onError(null, -1, "project params error!");
            }
            return;
        }
        MLog.error((Object)TAG, (String)"preloadItemNow:%s", (Object[])new Object[]{project.name});
        this.getTaskExecutor().execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                ProjectConfigItem curForceDownloadingItem;
                if (MyFileUtil.isPreloaded(project)) {
                    callback.onComplete(null);
                    return;
                }
                if (WebResDownloader.this.mCurDownloader != null && ((WebResDownloader)WebResDownloader.this).mCurDownloader.forceDownloading && (curForceDownloadingItem = ((WebResDownloader)WebResDownloader.this).mCurDownloader.data) != null && StringUtils.equal((String)project.name, (String)curForceDownloadingItem.name) && StringUtils.equal((String)project.zipMd5, (String)curForceDownloadingItem.zipMd5)) {
                    ((WebResDownloader)WebResDownloader.this).mCurDownloader.forDownloadCallBack = callback;
                    return;
                }
                ProjectConfigItem curDownloadingItem = WebResDownloader.this.mCurDownloader != null ? ((WebResDownloader)WebResDownloader.this).mCurDownloader.data : null;
                WebResDownloader.this.stopCurDownloader();
                if (curDownloadingItem != null && WebResDownloader.this.mProjectToPreload != null) {
                    WebResDownloader.this.mProjectToPreload.remove(curDownloadingItem);
                }
                if (WebResDownloader.this.mProjectToPreload == null) {
                    WebResDownloader.this.mProjectToPreload = new ArrayList();
                } else {
                    for (ProjectConfigItem item : WebResDownloader.this.mProjectToPreload) {
                        if (item == null || !StringUtils.equal((String)item.name, (String)project.name) || !StringUtils.equal((String)item.zipMd5, (String)project.zipMd5)) continue;
                        WebResDownloader.this.mProjectToPreload.remove(item);
                        break;
                    }
                }
                WebResDownloader.this.mProjectToPreload.add(0, project);
                WebResDownloader.this.executeNext(project, callback);
            }
        }, 0L);
    }

    public void stopPreloadItem(final ProjectConfigItem project) {
        this.getTaskExecutor().execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                if (project != null && WebResDownloader.this.mCurDownloader != null && ((WebResDownloader)WebResDownloader.this).mCurDownloader.data == project) {
                    WebResDownloader.this.stopCurDownloader();
                    WebResDownloader.this.executeNext();
                }
            }
        }, 0L);
    }

    public void stop() {
        this.clearAllCache();
    }

    public void notify(Notification notification) {
        if (notification != null && notification.id == NotificationDef.N_NETWORK_STATE_CHANGE) {
            if (this.mCurDownloader == null) {
                return;
            }
            if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                this.mDownloadStateManager.checkStatu();
            }
        }
    }

    private void executeNext(ProjectConfigItem curDownloadingItem, IDownloadCallback forDownloadCallBack) {
        MLog.info((Object)TAG, (String)"try executeNext", (Object[])new Object[0]);
        if (this.mCurDownloader != null) {
            return;
        }
        if (curDownloadingItem == null && FileStorageUtils.isAvailableInternalStorgeNotEnough()) {
            return;
        }
        int maxPreloadNum = SettingFlags.getIntValue((String)"webpreloadNum", (int)3);
        if (this.mHasPreloadNumed >= maxPreloadNum && curDownloadingItem == null) {
            MLog.info((Object)TAG, (String)"try executeNext return by only preload one flag!", (Object[])new Object[0]);
            return;
        }
        if (this.mWriteFileError && curDownloadingItem == null) {
            MLog.info((Object)TAG, (String)"try executeNext return by happen download write file error!", (Object[])new Object[0]);
            return;
        }
        if (this.mProjectToPreload == null || this.mProjectToPreload.size() <= 0) {
            return;
        }
        Iterator<ProjectConfigItem> iterator = this.mProjectToPreload.iterator();
        if (iterator.hasNext()) {
            ProjectConfigItem item = iterator.next();
            this.mCurDownloader = MyDownloader.create(item == curDownloadingItem ? 150 : 50, item, this.getDownloadCallBack(), this.resDownloadCallBack);
            if (this.mCurDownloader == null) {
                return;
            }
            this.mProjectToPreload.remove(item);
            if (item == curDownloadingItem) {
                this.mCurDownloader.forceDownloading = true;
                this.mCurDownloader.forDownloadCallBack = forDownloadCallBack;
            }
        }
        MLog.info((Object)TAG, (String)"executeNext %s", (Object[])new Object[]{this.mCurDownloader.data.name});
        if (!this.mRegisterNotify) {
            this.mRegisterNotify = true;
            ExtensionsKt.onUi(() -> {
                NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
                return null;
            });
        }
        this.mDownloadStateManager.checkStatu();
    }

    private void executeNext() {
        this.executeNext(null, null);
    }

    private void stopCurDownloader() {
        if (this.mCurDownloader != null) {
            this.mCurDownloader.forceDownloading = false;
            this.mCurDownloader.forDownloadCallBack = null;
            this.mCurDownloader.stop();
            MLog.info((Object)TAG, (String)"stop %s", (Object[])new Object[]{this.mCurDownloader.data.name});
        }
        this.mCurDownloader = null;
    }

    private void checkAllPreloadFile(ArrayList<ProjectConfigItem> arrayList) {
        MyFileUtil.checkAllPreloadFile(arrayList);
    }

    private void removeAllPreloaded(ArrayList<ProjectConfigItem> arrayList) {
        MyFileUtil.removeAllPreloaded(arrayList);
    }

    private IDownloadCallback getDownloadCallBack() {
        if (this.mDownloadCallBack == null) {
            this.mDownloadCallBack = new IDownloadCallback(){

                public void onComplete(final Downloader downloader) {
                    WebResDownloader.this.getTaskExecutor().execute((Runnable)new YYTaskExecutor.RunnableEx(){

                        public void run() {
                            if (WebResDownloader.this.mCurDownloader == null || ((WebResDownloader)WebResDownloader.this).mCurDownloader.downloader != downloader) {
                                return;
                            }
                            File file = WebResDownloader.this.mCurDownloader.getDownloadFile();
                            long size = file.length();
                            File unzipDir = WebResDownloader.this.mCurDownloader.getUnzipDir();
                            WebResDownloader.this.mCurDownloader;
                            boolean success = MyFileUtil.unzip(file, unzipDir, !MyDownloader.getIncrementalDownloadSwitchOn());
                            final IDownloadCallback forceCallback = WebResDownloader.this.mCurDownloader != null ? ((WebResDownloader)WebResDownloader.this).mCurDownloader.forDownloadCallBack : null;
                            ProjectConfigItem item = ((WebResDownloader)WebResDownloader.this).mCurDownloader.data;
                            String itemDownloadFile = file.getName();
                            if (success) {
                                if (forceCallback != null) {
                                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            forceCallback.onComplete(downloader);
                                        }
                                    });
                                }
                                if (MyDownloader.getIncrementalDownloadSwitchOn()) {
                                    MyFileUtil.removeOldZipFile(item, itemDownloadFile);
                                }
                                MLog.info((Object)WebResDownloader.TAG, (String)"onSelected %s fileSize:%d md5:%s url:%s ", (Object[])new Object[]{((WebResDownloader)WebResDownloader.this).mCurDownloader.data.name, (int)size, ((WebResDownloader)WebResDownloader.this).mCurDownloader.data.zipMd5, ((WebResDownloader)WebResDownloader.this).mCurDownloader.data.zipUrl});
                            } else {
                                if (forceCallback != null) {
                                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            forceCallback.onError(downloader, -2, "unzip error!");
                                        }
                                    });
                                }
                                MLog.info((Object)WebResDownloader.TAG, (String)"onError %s fileSize:%d md5:%s url:%s ", (Object[])new Object[]{((WebResDownloader)WebResDownloader.this).mCurDownloader.data.name, (int)size, ((WebResDownloader)WebResDownloader.this).mCurDownloader.data.zipMd5, ((WebResDownloader)WebResDownloader.this).mCurDownloader.data.zipUrl});
                            }
                            if (!StringUtils.equal((String)((WebResDownloader)WebResDownloader.this).mCurDownloader.data.name, (String)"corejslib")) {
                                WebResDownloader.this.mHasPreloadNumed++;
                            }
                            WebResDownloader.this.mErrorTimes = 0;
                            WebResDownloader.this.mCurDownloader = null;
                            WebResDownloader.this.executeNext();
                        }
                    }, 0L);
                }

                public void onError(final Downloader downloader, final int errorType, final String errorInfo) {
                    WebResDownloader.this.getTaskExecutor().execute((Runnable)new YYTaskExecutor.RunnableEx(){

                        public void run() {
                            IDownloadCallback forceCallback;
                            if (WebResDownloader.this.mCurDownloader == null || ((WebResDownloader)WebResDownloader.this).mCurDownloader.downloader != downloader) {
                                return;
                            }
                            IDownloadCallback iDownloadCallback = forceCallback = WebResDownloader.this.mCurDownloader != null ? ((WebResDownloader)WebResDownloader.this).mCurDownloader.forDownloadCallBack : null;
                            if (forceCallback != null) {
                                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        forceCallback.onError(downloader, errorType, errorInfo);
                                    }
                                });
                            }
                            MLog.info((Object)WebResDownloader.TAG, (String)"onError %s md5:%s url:%s ", (Object[])new Object[]{((WebResDownloader)WebResDownloader.this).mCurDownloader.data.name, ((WebResDownloader)WebResDownloader.this).mCurDownloader.data.zipMd5, ((WebResDownloader)WebResDownloader.this).mCurDownloader.data.zipUrl});
                            MLog.info((Object)WebResDownloader.TAG, (String)"onError reason:%s ", (Object[])new Object[]{errorInfo});
                            WebResDownloader.this.mCurDownloader = null;
                            if (errorInfo != null && errorInfo.contains("write failed: ENOSPC")) {
                                WebResDownloader.this.mWriteFileError = true;
                            } else {
                                WebResDownloader.this.mErrorTimes = WebResDownloader.this.mErrorTimes + 1;
                                if (WebResDownloader.this.mErrorTimes <= 5) {
                                    WebResDownloader.this.executeNext();
                                }
                            }
                        }
                    }, 3000L);
                }

                public void onProgressChange(final Downloader downloader, final long totalSize, final long curSize) {
                    IDownloadCallback forceCallback;
                    IDownloadCallback iDownloadCallback = forceCallback = WebResDownloader.this.mCurDownloader != null ? ((WebResDownloader)WebResDownloader.this).mCurDownloader.forDownloadCallBack : null;
                    if (forceCallback != null) {
                        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                forceCallback.onProgressChange(downloader, totalSize, curSize);
                            }
                        });
                    }
                }

                public void onStart(final Downloader downloader) {
                    WebResDownloader.this.getTaskExecutor().execute((Runnable)new YYTaskExecutor.RunnableEx(){

                        public void run() {
                            IDownloadCallback forceCallback;
                            if (WebResDownloader.this.mCurDownloader == null || ((WebResDownloader)WebResDownloader.this).mCurDownloader.downloader != downloader) {
                                return;
                            }
                            IDownloadCallback iDownloadCallback = forceCallback = WebResDownloader.this.mCurDownloader != null ? ((WebResDownloader)WebResDownloader.this).mCurDownloader.forDownloadCallBack : null;
                            if (forceCallback != null) {
                                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        forceCallback.onStart(downloader);
                                    }
                                });
                            }
                            MLog.info((Object)WebResDownloader.TAG, (String)"onStart %s md5:%s url:%s ", (Object[])new Object[]{((WebResDownloader)WebResDownloader.this).mCurDownloader.data.name, ((WebResDownloader)WebResDownloader.this).mCurDownloader.data.zipMd5, ((WebResDownloader)WebResDownloader.this).mCurDownloader.data.zipUrl});
                        }
                    }, 0L);
                }

                public void onCreate(final Downloader downloader) {
                    WebResDownloader.this.getTaskExecutor().execute((Runnable)new YYTaskExecutor.RunnableEx(){

                        public void run() {
                            IDownloadCallback forceCallback;
                            if (WebResDownloader.this.mCurDownloader == null || ((WebResDownloader)WebResDownloader.this).mCurDownloader.downloader != downloader) {
                                return;
                            }
                            IDownloadCallback iDownloadCallback = forceCallback = WebResDownloader.this.mCurDownloader != null ? ((WebResDownloader)WebResDownloader.this).mCurDownloader.forDownloadCallBack : null;
                            if (forceCallback != null) {
                                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        forceCallback.onCreate(downloader);
                                    }
                                });
                            }
                        }
                    }, 0L);
                }
            };
        }
        return this.mDownloadCallBack;
    }

    private void clearAllCache() {
        this.getTaskExecutor().execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                MLog.info((Object)WebResDownloader.TAG, (String)"clearAllCache", (Object[])new Object[0]);
                MyFileUtil.clearAllCache();
            }
        }, 0L);
    }

    private IQueueTaskExecutor getTaskExecutor() {
        if (this.mTaskExecutor == null) {
            this.mTaskExecutor = YYTaskExecutor.createAQueueExcuter();
        }
        return this.mTaskExecutor;
    }

    private static File getProjectsDir() {
        return MyFileUtil.getProjectsDir();
    }

    public static interface IWebResDownloadCallBack {
        public WebIncrementItem getDownloadIncrement(ProjectConfigItem var1);
    }

    private class DownloadStateManager {
        DownloadStateManager(IServiceManager serviceManager) {
            this.init(serviceManager);
        }

        private synchronized void init(IServiceManager serviceManager) {
            if (serviceManager == null) {
                return;
            }
            ((IGameCenterService)serviceManager.getService(IGameCenterService.class)).registerGameLifecycle((IGameLifecycle)new GameLifeWrapper(){

                public void onPreloadGame(GamePlayContext context) {
                    DownloadStateManager.this.checkStatu();
                }

                public void onPlayGameStart(GamePlayContext context) {
                    DownloadStateManager.this.checkStatu();
                }

                public void onGameExited(GamePlayContext context, int gameExitType) {
                    DownloadStateManager.this.checkStatu();
                }
            });
            ((IGameCenterService)serviceManager.getService(IGameCenterService.class)).registerGameMatchEvent(new IMatchGameLifecycle(){

                public void prepareGameMatch(GameInfo ginfo, @Nonnull GameMatchContext matchConfig) {
                    DownloadStateManager.this.checkStatu();
                }

                public void onGameMatchStart(GameInfo info, @Nonnull GameMatchContext matchConfig) {
                    DownloadStateManager.this.checkStatu();
                }

                public void onMatchFinish(GameInfo gameInfo, @Nonnull GameMatchContext matchContext, int matchType) {
                    DownloadStateManager.this.checkStatu();
                }
            });
            ((IGameCenterService)serviceManager.getService(IGameCenterService.class)).registerTeamMatchLifecycle(new ITeamMatchLifecycle(){

                public void onPrepareTeamMatch(GameTeamMatchContext context) {
                    DownloadStateManager.this.checkStatu();
                }

                public void onTeamReady(String teamId) {
                }

                public void onTeamMatchFinish(GameTeamMatchContext context) {
                    DownloadStateManager.this.checkStatu();
                }

                public void onDestroy() {
                    DownloadStateManager.this.checkStatu();
                }
            });
            DefaultWindow.addGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)new DefaultWindow.IGlobalWindowMonitor(){

                public void onWindowCreate(DefaultWindow window) {
                }

                public void onShown(DefaultWindow window) {
                    DownloadStateManager.this.checkStatu();
                }

                public void onHidden(DefaultWindow window) {
                }

                public void onLayout(boolean changed, int left, int top, int right, int bottom) {
                }
            });
        }

        private boolean needPause(AbstractWindow window) {
            MyDownloader downloader = WebResDownloader.this.mCurDownloader;
            if (downloader != null && downloader.forceDownloading) {
                return false;
            }
            if (window == null) {
                return true;
            }
            String windowName = window.getName();
            return StringUtils.equal((String)"Web", (String)windowName) || StringUtils.equal((String)"Feedback", (String)windowName) || StringUtils.equal((String)"LoginTypeSelect", (String)windowName) || StringUtils.equal((String)"BasicProfile", (String)windowName);
        }

        private void checkStatu() {
            YYTaskExecutor.RunnableEx command = new YYTaskExecutor.RunnableEx(){

                public void run() {
                    IGameCenterService service = (IGameCenterService)WebResDownloader.this.getServiceManager().getService(IGameCenterService.class);
                    final boolean needPause = DownloadStateManager.this.needPause(WebResDownloader.this.mWindowMgr.getCurrentWindow()) || service.isPlaying() || service.isMatching() || service.isTeamMatching();
                    WebResDownloader.this.getTaskExecutor().execute((Runnable)new YYTaskExecutor.RunnableEx(){

                        public void run() {
                            if (WebResDownloader.this.mCurDownloader != null) {
                                MLog.info((Object)WebResDownloader.TAG, (String)"checkStatu", (Object[])new Object[0]);
                                if (needPause) {
                                    WebResDownloader.this.mCurDownloader.stop();
                                } else if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                                    WebResDownloader.this.mCurDownloader.start();
                                }
                            }
                        }
                    }, 0L);
                }
            };
            if (YYTaskExecutor.isMainThread()) {
                command.run();
            } else {
                YYTaskExecutor.postToMainThread((Runnable)command);
            }
        }
    }

    private static class MyDownloader {
        public Downloader downloader;
        public ProjectConfigItem data;
        public File downloadFile;
        private volatile boolean started;
        public boolean forceDownloading = false;
        public IDownloadCallback forDownloadCallBack = null;

        public static boolean getIncrementalDownloadSwitchOn() {
            return ConfigManager.getIncrementalDownloadSwitchOn();
        }

        MyDownloader() {
        }

        public File getDownloadFile() {
            if (this.downloadFile != null) {
                return this.downloadFile;
            }
            this.downloadFile = MyFileUtil.getDownloadFile(this.data);
            return this.downloadFile;
        }

        public File getUnzipDir() {
            return new File(WebResDownloader.getProjectsDir().getAbsolutePath(), this.data.zipMd5);
        }

        public static MyDownloader create(int priority, ProjectConfigItem data, IDownloadCallback callback, IWebResDownloadCallBack resDownloadCallBack) {
            WebIncrementItem incrementItem = resDownloadCallBack.getDownloadIncrement(data);
            MyDownloader myDownloader = new MyDownloader();
            myDownloader.data = data;
            String oldPatchFilePath = "";
            if (incrementItem != null) {
                File oldFile = MyFileUtil.getPatchDownloadFile(data.name, incrementItem.getOldZipMd5());
                if (oldFile.exists() && !oldFile.isDirectory()) {
                    oldPatchFilePath = oldFile.getAbsolutePath();
                    MLog.info((Object)WebResDownloader.TAG, (String)"create task,incrementItem:%s,oldPatchFilePath:%s", (Object[])new Object[]{incrementItem, oldPatchFilePath});
                } else {
                    MLog.error((Object)WebResDownloader.TAG, (String)"create task,incrementItem:%s,oldPatchFilePath:%s not existed!", (Object[])new Object[]{incrementItem, oldFile.getAbsolutePath()});
                }
            }
            Downloader.Builder builder = null;
            if (incrementItem != null && StringUtils.isNotEmpty((String)oldPatchFilePath) && StringUtils.isNotEmpty((String)incrementItem.getPatchUrl())) {
                builder = new Downloader.Builder(incrementItem.getPatchUrl(), MyFileUtil.getPatchDownloadFile(data.name, incrementItem.getPatchMd5()));
                builder.setFileEtagCheckContent("md5", incrementItem.getPatchMd5());
                builder.putExtendBoolean("incremental_download", true);
                builder.putExtendBoolean("incremental_deletepatch_when_error", true);
                builder.putExtendString("incremental_oldfile", oldPatchFilePath);
                builder.putExtendString("incremental_oldfilemd5", incrementItem.getOldZipMd5());
                builder.putExtendString("incremental_composedfilemd5", data.zipMd5);
                builder.putExtendString("incremental_composedfile", myDownloader.getDownloadFile().getAbsolutePath());
                builder.setTaskGroup(DownloadBussinessGroup.WEB_PRELOAD_PATCH_FILE);
            } else {
                builder = new Downloader.Builder(data.zipUrl, myDownloader.getDownloadFile());
                builder.setFileEtagCheckContent("md5", data.zipMd5);
                builder.setTaskGroup(DownloadBussinessGroup.WEB_PRELOAD_FILE);
            }
            builder.setPriority(priority);
            builder.setCallBack(callback);
            builder.setSupportContinueTransfer(true);
            builder.setTaskSubGroup(data.name);
            myDownloader.downloader = builder.build();
            return myDownloader;
        }

        public synchronized void start() {
            if (this.started) {
                return;
            }
            MLog.info((Object)WebResDownloader.TAG, (String)"start %s md5:%s url:%s ", (Object[])new Object[]{this.data.name, this.data.zipMd5, this.data.zipUrl});
            this.downloader.start();
            this.started = true;
        }

        public synchronized void stop() {
            if (!this.started) {
                return;
            }
            MLog.info((Object)WebResDownloader.TAG, (String)"stop %s md5:%s url:%s ", (Object[])new Object[]{this.data.name, this.data.zipMd5, this.data.zipUrl});
            this.downloader.delete();
            this.started = false;
        }
    }
}

