/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.web.preload.config;

import com.google.gson.reflect.TypeToken;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.http.INetRespOriginJsonParseCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.app.web.preload.config.PreloadConfig;
import com.yy.hiyo.app.web.preload.config.ProjectConfigItem;
import com.yy.hiyo.app.web.preload.config.download.WebIncrementConfig;
import com.yy.hiyo.app.web.preload.config.download.WebIncrementItem;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import okhttp3.Call;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigManager {
    private static final String TAG = "Web_Preload_ConfigManager";
    private static final String CONFIG_FILE_NAME = "config.txt";
    private ICallBack mCallBack;
    private Runnable mLoadConfig;
    private PreloadConfig mPreloadConfig;
    private List<WebIncrementItem> incrementDownloadItems;
    private String incrementConfigMd5;
    private volatile String mConfigStr;
    private String configLastUpdatedMd5 = "";
    private boolean hasLoaded = false;
    private static int sIncrementalDownloadSwitchOn = -1;

    public ConfigManager(ICallBack callBack) {
        this.mCallBack = callBack;
    }

    public void loadPreloadConfig(long delay) {
        if (this.mLoadConfig == null) {
            this.mLoadConfig = new YYTaskExecutor.RunnableEx(){

                public void run() {
                    HashMap<String, String> map = new HashMap<String, String>();
                    try {
                        map.put("platform", "android");
                        map.put("appVersion", CommonHttpHeader.getHagoAppVer());
                        map.put("uid", String.valueOf(AccountUtil.getUid()));
                        map.put("region", AccountUtil.registerCountry());
                        map.put("app", AppKeysDef.getAppName());
                        if (ConfigManager.this.mPreloadConfig == null) {
                            if (ConfigManager.this.mConfigStr == null) {
                                ConfigManager.this.mConfigStr = ConfigManager.this.getConfigFromFile();
                            }
                            if (StringUtils.isNotEmpty((String)ConfigManager.this.mConfigStr)) {
                                Type type2 = new TypeToken<PreloadConfig>(){}.getType();
                                PreloadConfig config = (PreloadConfig)JsonParser.parseJsonObject((String)ConfigManager.this.mConfigStr, (Type)type2);
                                if (config != null && config.projects != null && config.projects.size() > 0) {
                                    ConfigManager.this.mPreloadConfig = config;
                                }
                            }
                        }
                        if (ConfigManager.this.mPreloadConfig != null && StringUtils.isNotEmpty((String)((ConfigManager)ConfigManager.this).mPreloadConfig.md5)) {
                            map.put("md5", ((ConfigManager)ConfigManager.this).mPreloadConfig.md5);
                        }
                    }
                    catch (Throwable e) {
                        MLog.error((Object)ConfigManager.TAG, (Throwable)e);
                    }
                    ConfigManager.this.notifyConfigLoaded();
                    HttpUtil.httpReq((String)UriProvider.WEB_PRELOAD_CONFIG_URL, map, (int)1, (INetRespCallback)new INetRespOriginJsonParseCallback<PreloadConfig>(){

                        public void onError(Call call, Exception e, int id2) {
                            MLog.error((Object)ConfigManager.TAG, (Throwable)e);
                            int timeGap = ConfigManager.this.mPreloadConfig != null && ((ConfigManager)ConfigManager.this).mPreloadConfig.refreshTime > 5 ? ((ConfigManager)ConfigManager.this).mPreloadConfig.refreshTime : 5;
                            ConfigManager.this.loadPreloadConfig(timeGap * 60 * 1000);
                            if (ConfigManager.this.mCallBack != null && ConfigManager.this.mPreloadConfig != null && ((ConfigManager)ConfigManager.this).mPreloadConfig.projects != null && ((ConfigManager)ConfigManager.this).mPreloadConfig.projects.size() > 0 && StringUtils.isEmpty((String)ConfigManager.this.configLastUpdatedMd5)) {
                                ConfigManager.this.onConfigUpdated();
                            }
                        }

                        public void onResponse(String response, BaseResponseBean<PreloadConfig> res, int id2) {
                            if (RuntimeContext.sIsDebuggable) {
                                MLog.info((Object)ConfigManager.TAG, (String)(" config = " + response + "  res.data = " + res.data), (Object[])new Object[0]);
                            } else {
                                MLog.info((Object)ConfigManager.TAG, (String)" config length:%d", (Object[])new Object[]{response != null ? response.length() : 0});
                            }
                            if (res.data == null || ((PreloadConfig)res.data).status == 1) {
                                if (ConfigManager.this.mCallBack != null && ConfigManager.this.mPreloadConfig != null && ((ConfigManager)ConfigManager.this).mPreloadConfig.projects != null && ((ConfigManager)ConfigManager.this).mPreloadConfig.projects.size() > 0 && StringUtils.isEmpty((String)ConfigManager.this.configLastUpdatedMd5)) {
                                    ConfigManager.this.onConfigUpdated();
                                }
                                int timeGap = ConfigManager.this.mPreloadConfig != null && ((ConfigManager)ConfigManager.this).mPreloadConfig.refreshTime > 5 ? ((ConfigManager)ConfigManager.this).mPreloadConfig.refreshTime : 5;
                                ConfigManager.this.loadPreloadConfig(timeGap * 60 * 1000);
                                return;
                            }
                            ConfigManager.this.mConfigStr = response;
                            ConfigManager.this.handleConfigUpdate((PreloadConfig)res.data);
                            YYTaskExecutor.execute(() -> ConfigManager.this.saveConfig(response));
                        }

                        public boolean needToken() {
                            return false;
                        }
                    });
                }
            };
        } else {
            YYTaskExecutor.removeTask((Runnable)this.mLoadConfig);
        }
        YYTaskExecutor.execute((Runnable)this.mLoadConfig, (long)delay);
    }

    public void stopUpdate() {
        if (this.mLoadConfig != null) {
            YYTaskExecutor.removeTask((Runnable)this.mLoadConfig);
        }
    }

    public boolean isConfigEmpty() {
        return this.mPreloadConfig == null || this.mPreloadConfig.projects == null || this.mPreloadConfig.projects.size() == 0;
    }

    public boolean hasLoaded() {
        return this.hasLoaded;
    }

    private synchronized void saveConfig(String splashConfig) {
        File file = FileStorageUtils.getInstance().getDirAndCreate(!RuntimeContext.sIsDebuggable, "webview");
        File configFile = new File(file, CONFIG_FILE_NAME);
        try {
            YYFileUtils.writeBytesToFile((File)configFile, (byte[])splashConfig.getBytes(), (boolean)false);
        }
        catch (IOException e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    private synchronized String getConfigFromFile() {
        File file = FileStorageUtils.getInstance().getDirAndCreate(!RuntimeContext.sIsDebuggable, "webview");
        File configFile = new File(file, CONFIG_FILE_NAME);
        String result = "";
        if (configFile.exists()) {
            try {
                result = new String(YYFileUtils.getBytesFromFile((File)configFile));
            }
            catch (IOException e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return result;
    }

    private synchronized void handleConfigUpdate(PreloadConfig config) {
        MLog.info((Object)TAG, (String)(" handleConfigUpdate" + (config == null ? " null" : "")), (Object[])new Object[0]);
        if (config != null) {
            this.loadPreloadConfig((config.refreshTime > 5 ? config.refreshTime : 5) * 60 * 1000);
        } else if (this.mPreloadConfig != null && this.mLoadConfig != null) {
            YYTaskExecutor.removeTask((Runnable)this.mLoadConfig);
        }
        this.mPreloadConfig = config;
        if (this.mPreloadConfig == null || this.mPreloadConfig.projects == null || !StringUtils.equal((String)this.mPreloadConfig.md5, (String)this.incrementConfigMd5)) {
            this.incrementConfigMd5 = null;
            this.incrementDownloadItems = null;
        }
        this.onConfigUpdated();
    }

    private void onConfigUpdated() {
        MLog.info((Object)TAG, (String)"onConfigUpdated!", (Object[])new Object[0]);
        String string2 = this.configLastUpdatedMd5 = this.mPreloadConfig != null ? this.mPreloadConfig.md5 : "";
        if (!ConfigManager.getIncrementalDownloadSwitchOn()) {
            if (this.mCallBack != null) {
                this.mCallBack.onConfigUpdated(this.mPreloadConfig);
            }
        } else {
            MLog.info((Object)TAG, (String)"onConfigUpdated, request IncrementConfig!", (Object[])new Object[0]);
            WebIncrementConfig.Companion.requestIncrementConfig(this.mPreloadConfig, new WebIncrementConfig.IRequestConfigCallBack(){

                @Override
                public void onSuccess(@Nullable List<WebIncrementItem> items, @NotNull String configMd5) {
                    if (ConfigManager.this.mPreloadConfig == null) {
                        if (ConfigManager.this.mCallBack != null) {
                            ConfigManager.this.mCallBack.onConfigUpdated(ConfigManager.this.mPreloadConfig);
                        }
                        return;
                    }
                    if (StringUtils.equal((String)((ConfigManager)ConfigManager.this).mPreloadConfig.md5, (String)configMd5)) {
                        ConfigManager.this.incrementDownloadItems = items;
                    }
                    if (RuntimeContext.sIsDebuggable) {
                        MLog.info((Object)ConfigManager.TAG, (String)"onConfigUpdated, request IncrementConfig success:%s!", (Object[])new Object[]{ConfigManager.this.incrementDownloadItems != null ? ConfigManager.this.incrementDownloadItems.toString() : ""});
                    } else {
                        MLog.info((Object)ConfigManager.TAG, (String)"onConfigUpdated, request IncrementConfig success:%d!", (Object[])new Object[]{ConfigManager.this.incrementDownloadItems != null ? ConfigManager.this.incrementDownloadItems.size() : 0});
                    }
                    if (ConfigManager.this.mCallBack != null) {
                        ConfigManager.this.mCallBack.onConfigUpdated(ConfigManager.this.mPreloadConfig);
                    }
                }

                @Override
                public void onError(@NotNull String errorInfo, @Nullable String configMd5) {
                    MLog.info((Object)ConfigManager.TAG, (String)"onConfigUpdated, request IncrementConfig error:%s!", (Object[])new Object[]{errorInfo});
                    if (ConfigManager.this.mCallBack != null) {
                        ConfigManager.this.mCallBack.onConfigUpdated(ConfigManager.this.mPreloadConfig);
                    }
                }
            });
        }
    }

    public synchronized boolean isConfigValid() {
        return this.mPreloadConfig != null && this.mPreloadConfig.projects != null && this.mPreloadConfig.projects.size() > 0;
    }

    public synchronized String getProjectMd5(String projectName) {
        if (!this.isConfigValid()) {
            return null;
        }
        for (ProjectConfigItem item : this.mPreloadConfig.projects) {
            if (item == null || !StringUtils.equal((String)projectName, (String)item.name)) continue;
            return item.zipMd5;
        }
        return null;
    }

    public synchronized ProjectConfigItem isUrlInForceLoad(String url) {
        if (!this.isConfigValid()) {
            return null;
        }
        String replaceUrl = URLUtils.replaceUrl((String)url);
        for (ProjectConfigItem item : this.mPreloadConfig.projects) {
            if (item == null || item.type != 1 || !replaceUrl.startsWith(item.webUrl)) continue;
            return item;
        }
        return null;
    }

    public synchronized ProjectConfigItem findProjectByName(String name) {
        if (!this.isConfigValid()) {
            return null;
        }
        for (ProjectConfigItem item : this.mPreloadConfig.projects) {
            if (item == null || !StringUtils.equal((String)name, (String)item.name)) continue;
            return item;
        }
        return null;
    }

    public synchronized ProjectConfigItem findProjectByUrl(String url) {
        if (StringUtils.isEmpty((String)url) || !this.isConfigValid()) {
            return null;
        }
        for (ProjectConfigItem item : this.mPreloadConfig.projects) {
            if (item == null || !StringUtils.isNotEmpty((String)item.webUrl) || !url.startsWith(item.webUrl)) continue;
            return item;
        }
        String replaceUrl = URLUtils.replaceUrl((String)url);
        if (!StringUtils.equal((String)replaceUrl, (String)url)) {
            for (ProjectConfigItem item : this.mPreloadConfig.projects) {
                if (item == null || !replaceUrl.startsWith(item.webUrl)) continue;
                return item;
            }
        }
        return null;
    }

    private void notifyConfigLoaded() {
        if (!this.hasLoaded) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (ConfigManager.this.mCallBack != null && !ConfigManager.this.hasLoaded) {
                        ConfigManager.this.hasLoaded = true;
                        ConfigManager.this.mCallBack.onConfigLoaded();
                    }
                }
            });
        }
    }

    public static boolean getIncrementalDownloadSwitchOn() {
        if (sIncrementalDownloadSwitchOn != -1) {
            return sIncrementalDownloadSwitchOn == 1;
        }
        sIncrementalDownloadSwitchOn = SettingFlags.getBoolean((String)"webincremental", (RuntimeContext.sIsDebuggable ? 1 : 0) != 0) ? 1 : 0;
        return sIncrementalDownloadSwitchOn == 1;
    }

    public WebIncrementItem getDownloadIncrement(ProjectConfigItem item) {
        if (item == null || StringUtils.isEmpty((String)item.name) || StringUtils.isEmpty((String)item.zipMd5)) {
            return null;
        }
        List<WebIncrementItem> incrementDownloadItems = this.incrementDownloadItems;
        if (incrementDownloadItems == null || incrementDownloadItems.size() <= 0) {
            return null;
        }
        for (WebIncrementItem incrementItem : incrementDownloadItems) {
            if (incrementItem == null || !StringUtils.equal((String)incrementItem.getName(), (String)item.name) || !StringUtils.equal((String)incrementItem.getZipMd5(), (String)item.zipMd5) || StringUtils.equal((String)incrementItem.getZipMd5(), (String)incrementItem.getPatchMd5()) || StringUtils.equal((String)incrementItem.getZipMd5(), (String)incrementItem.getOldZipMd5()) || StringUtils.isEmpty((String)incrementItem.getPatchMd5()) || StringUtils.isEmpty((String)incrementItem.getPatchUrl())) continue;
            return incrementItem;
        }
        return null;
    }

    public static interface ICallBack {
        public void onConfigUpdated(PreloadConfig var1);

        public void onConfigLoaded();
    }
}

