/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.web.preload;

import com.google.gson.reflect.TypeToken;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.app.web.preload.WebPreloadUtil;
import com.yy.hiyo.app.web.preload.config.PreloadConfig;
import com.yy.hiyo.app.web.preload.config.ProjectConfigItem;
import com.yy.hiyo.app.web.preload.config.download.WebIncrementRequestItem;
import com.yy.hiyo.app.web.preload.webresource.FileList;
import com.yy.hiyo.app.web.preload.webresource.FileMap;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MyFileUtil {
    public static final String DIR = "webview";
    private static final String PROJECTS_DIR_NAME = "projects";
    private static final String FILE_CHECK_JSON = "manifest.json";
    private static HashMap<String, FileMap> sFileList;
    private static File sDirFile;

    public static File getProjectsDir() {
        if (YYFileUtils.isFileOptOpen() && sDirFile != null) {
            return sDirFile;
        }
        sDirFile = RuntimeContext.sIsDebuggable ? new File(FileStorageUtils.getInstance().getDir(false, DIR), PROJECTS_DIR_NAME) : new File(FileStorageUtils.getInstance().getDir(true, DIR), PROJECTS_DIR_NAME);
        return sDirFile;
    }

    public static synchronized byte clearAllCache() {
        byte result = YYFileUtils.deleteFile((File)MyFileUtil.getProjectsDir());
        sDirFile = null;
        return result;
    }

    public static synchronized boolean unzip(File file, File unzipDir, boolean deleteFileAfterUnzip) {
        if (file == null || unzipDir == null) {
            return false;
        }
        try {
            if (unzipDir.exists()) {
                YYFileUtils.deleteFile((File)unzipDir);
            }
            YYFileUtils.unZip((String)file.getAbsolutePath(), (String)unzipDir.getAbsolutePath(), (String)"");
            if (deleteFileAfterUnzip) {
                YYFileUtils.deleteFile((File)file);
            }
            return true;
        }
        catch (IOException e) {
            try {
                if (unzipDir.exists()) {
                    YYFileUtils.deleteFile((File)unzipDir);
                }
                YYFileUtils.unZip((String)file.getAbsolutePath(), (String)unzipDir.getAbsolutePath(), (String)"");
                if (deleteFileAfterUnzip) {
                    YYFileUtils.deleteFile((File)file);
                }
                return true;
            }
            catch (Exception e2) {
                YYFileUtils.deleteFile((File)unzipDir);
                MLog.error((Object)"Web_Preload_MyFileUtilUnzip", (Throwable)e2);
                return false;
            }
        }
    }

    public static synchronized void removeAllPreloaded(ArrayList<ProjectConfigItem> arrayList) {
        File[] files;
        File dir = MyFileUtil.getProjectsDir();
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null && files.length > 0) {
            for (File file : files) {
                ProjectConfigItem item;
                if (!file.exists() || !file.isDirectory() || (item = MyFileUtil.getPreloadedItem(arrayList, file)) == null) continue;
                if (WebPreloadUtil.isLogEnable()) {
                    MLog.info((Object)"Web_PreloadFileCheck", (String)"project has preloaded %s", (Object[])new Object[]{item.name});
                }
                arrayList.remove(item);
            }
        }
    }

    public static synchronized boolean isPreloaded(ProjectConfigItem item) {
        File dir = MyFileUtil.getProjectsDir();
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    ProjectConfigItem itemFind;
                    if (!file.exists() || !file.isDirectory() || (itemFind = MyFileUtil.getPreloadedItem(item, file)) == null) continue;
                    return true;
                }
            }
        } else {
            return false;
        }
        return false;
    }

    public static synchronized void checkAllPreloadFile(ArrayList<ProjectConfigItem> arrayList) {
        File[] files;
        File dir = MyFileUtil.getProjectsDir();
        if (dir.exists() && dir.isDirectory() && (files = dir.listFiles()) != null && files.length > 0) {
            for (File file : files) {
                if (file == null || MyFileUtil.isPreloadFileValid(arrayList, file)) continue;
                MLog.error((Object)"Web_PreloadFileCheck", (String)"delete invalid file %s", (Object[])new Object[]{file.getAbsolutePath()});
                MyFileUtil.removeFromFileList(file.getName());
                YYFileUtils.deleteFile((File)file);
            }
        }
    }

    private static void removeFromFileList(String name) {
        if (sFileList != null) {
            sFileList.remove(name);
        }
    }

    public static synchronized void removeOldZipFile(ProjectConfigItem item, String newFileName) {
        File dir = MyFileUtil.getProjectsDir();
        if (dir.exists() && dir.isDirectory()) {
            String projectPrefix = "webDownload__" + item.name + "__";
            File[] files = dir.listFiles();
            if (files != null && files.length > 0) {
                String fileName = "";
                for (File file : files) {
                    if (file == null || !(fileName = file.getName()).startsWith(projectPrefix) || StringUtils.equal((String)newFileName, (String)fileName)) continue;
                    YYFileUtils.deleteFile((File)file);
                    MLog.info((Object)"Web_PreloadFileCheck", (String)"delete old file %s, new file:%s", (Object[])new Object[]{file.getAbsolutePath(), newFileName});
                }
            }
        }
    }

    public static synchronized boolean isFileNotInFileList(String projectNameMd5, String resPath) {
        long size;
        FileMap fileMap;
        FileMap fileMap2 = fileMap = sFileList != null ? sFileList.get(projectNameMd5) : null;
        return fileMap != null && (size = fileMap.getFileSize(resPath)) <= 0L;
    }

    public static synchronized boolean judgeFileSize(String projectNameMd5, File projectDir, File resFile, String resPath) {
        FileMap fileMap;
        FileMap fileMap2 = fileMap = sFileList != null ? sFileList.get(projectNameMd5) : null;
        if (fileMap == null) {
            String result = MyFileUtil.getConfigFromFile(projectDir);
            if (StringUtils.isEmpty((String)result)) {
                MLog.info((Object)"Web_Preload_MyFileUtil", (String)"manifest.jsonfile not exist or empty!", (Object[])new Object[0]);
                return false;
            }
            Type type2 = new TypeToken<FileList>(){}.getType();
            FileList fileList = (FileList)JsonParser.parseJsonObject((String)result, (Type)type2);
            if (fileList != null) {
                if (sFileList == null) {
                    sFileList = new HashMap();
                }
                fileMap = FileMap.create(fileList);
                sFileList.put(projectNameMd5, fileMap);
            }
        }
        if (fileMap != null) {
            boolean boolResult;
            long size = fileMap.getFileSize(resPath);
            long fileSize = resFile.length();
            boolean bl = boolResult = fileSize == size;
            if (!boolResult) {
                MLog.error((Object)"Web_Preload_MyFileUtil", (String)"fileSize %d realSize %d", (Object[])new Object[]{(int)fileSize, (int)size});
            }
            return boolResult;
        }
        return false;
    }

    private static synchronized String getConfigFromFile(File projectDir) {
        File configFile = new File(projectDir, FILE_CHECK_JSON);
        String result = "";
        if (configFile.exists()) {
            try {
                result = new String(YYFileUtils.getBytesFromFile((File)configFile));
            }
            catch (IOException e) {
                MLog.error((Object)"Web_Preload_MyFileUtilCheck", (Throwable)e);
            }
        }
        return result;
    }

    private static boolean isPreloadFileValid(ArrayList<ProjectConfigItem> arrayList, File file) {
        File json;
        if (arrayList == null || arrayList.size() <= 0 || file == null || !file.exists()) {
            return true;
        }
        String fileName = file.getName();
        if (fileName == null) {
            return false;
        }
        boolean isDir = file.isDirectory();
        if (isDir && !(json = new File(file, FILE_CHECK_JSON)).exists()) {
            return false;
        }
        String fileProjectPrefix = "";
        if (!isDir && fileName.startsWith("webDownload__")) {
            fileProjectPrefix = fileName.substring("webDownload__".length());
        }
        for (ProjectConfigItem item : arrayList) {
            if (item == null || !(isDir ? StringUtils.equal((String)fileName, (String)item.zipMd5) : fileProjectPrefix.startsWith(item.name))) continue;
            return true;
        }
        return false;
    }

    private static ProjectConfigItem getPreloadedItem(ArrayList<ProjectConfigItem> arrayList, File file) {
        if (arrayList == null || arrayList.size() <= 0 || file == null) {
            return null;
        }
        String fileName = file.getName();
        if (fileName == null) {
            return null;
        }
        for (ProjectConfigItem item : arrayList) {
            if (item == null || !fileName.equals(item.zipMd5)) continue;
            return item;
        }
        return null;
    }

    private static ProjectConfigItem getPreloadedItem(ProjectConfigItem item, File file) {
        if (item == null || file == null) {
            return null;
        }
        String fileName = file.getName();
        if (fileName == null) {
            return null;
        }
        if (fileName.equals(item.zipMd5)) {
            return item;
        }
        return null;
    }

    public static File getDownloadFile(ProjectConfigItem item) {
        return new File(MyFileUtil.getProjectsDir().getAbsolutePath(), "webDownload__" + item.name + "__" + item.zipMd5 + ".zip");
    }

    public static File getPatchDownloadFile(String projectName, String patchMd5) {
        return new File(MyFileUtil.getProjectsDir().getAbsolutePath(), "webDownload__" + projectName + "__" + patchMd5 + ".zip");
    }

    public static synchronized List<WebIncrementRequestItem> getWebIncrementDownloadItems(PreloadConfig config) {
        if (config == null || config.projects == null || config.projects.size() <= 0) {
            return null;
        }
        File dir = MyFileUtil.getProjectsDir();
        if (!dir.exists() || !dir.isDirectory()) {
            return null;
        }
        String projectPrefix = "webDownload__";
        File[] files = dir.listFiles();
        if (files == null || files.length <= 0) {
            return null;
        }
        ArrayList<WebIncrementRequestItem> requestItems = null;
        String fileName = "";
        String md5 = "";
        String project = "";
        for (File file : files) {
            String[] params;
            if (file == null || !(fileName = file.getName()).startsWith(projectPrefix) || !fileName.endsWith(".zip") || (params = fileName.split("__")) == null || params.length != 3) continue;
            project = params[1];
            md5 = params[2].substring(0, params[2].length() - 4);
            for (ProjectConfigItem item : config.projects) {
                if (item == null || !StringUtils.equal((String)project, (String)item.name) || StringUtils.equal((String)md5, (String)item.zipMd5)) continue;
                if (requestItems == null) {
                    requestItems = new ArrayList<WebIncrementRequestItem>();
                }
                requestItems.add(new WebIncrementRequestItem(project, md5, item.zipMd5));
            }
        }
        return requestItems;
    }
}

