/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.web;

import android.view.ViewGroup;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.web.IWebManager;
import com.yy.appbase.service.web.IWebManagerCallBack;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.module.webbussiness.base.WebStorage;
import com.yy.webservice.WebEnvSettings;
import com.yy.webservice.client.IWebBusinessCallBack;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.NotifyJs;
import com.yy.webservice.webpanel.IWebPanelCallback;
import com.yy.webservice.webpanel.IWebPanelManager;
import com.yy.webservice.webwindow.webview.base.WebViewSettings;

public class WebServiceImpl
implements IWebService {
    public static WebServiceImpl getInstance() {
        return SingleHolder.INSTANCE;
    }

    public void loadUrl(String url, String title) {
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.MSG_WEBSERVICEWRAPPER_LOADURL, (Object)new String[]{url, title});
    }

    public void loadUrl(WebEnvSettings webEnvSettings) {
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.MSG_WEBSERVICEWRAPPER_LOADURL, (Object)webEnvSettings);
    }

    public void addGlobalJsEvent(@NonNull JsEvent event) {
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.MSG_WEBSERVICEWRAPPER_ADDGLOBALJSEVENT, (Object)event);
    }

    public void removeGlobalJsEvent(@NonNull JsEvent event) {
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.MSG_WEBSERVICEWRAPPER_REMOVEGLOBALJSEVENT, (Object)event);
    }

    public void loadPureJs(String js) {
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.MSG_WEBSERVICEWRAPPER_LOADPUREJS, (Object)js);
    }

    public void loadNotifyJs(String toWebId, NotifyJs notify, String param) {
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.MSG_WEBSERVICEWRAPPER_LOADNOTIFYJS_WITH_ID, (Object)new Object[]{toWebId, notify, param});
    }

    public void registerWebBusiness(IWebBusinessCallBack callBack) {
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.MSG_WEBSERVICEWRAPPER_REGISTERWEBBUSINESS, (Object)callBack);
    }

    public void unRegisterWebBusiness(IWebBusinessCallBack callBack) {
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.MSG_WEBSERVICEWRAPPER_UNREGISTERWEBBUSINESS, (Object)callBack);
    }

    public IWebManager createWebManager(IWebManagerCallBack callBack, WebView webView) {
        return (IWebManager)MsgDispatcher.getInstance().sendMessageSync(MsgDef.MSG_WEBSERVICEWRAPPER_CREATEWEBMANAGER, (Object)new Object[]{callBack, webView});
    }

    public IWebManager createWebManager(IWebManagerCallBack callBack, WebView webView, WebViewSettings settings) {
        return (IWebManager)MsgDispatcher.getInstance().sendMessageSync(MsgDef.MSG_WEBSERVICEWRAPPER_CREATEWEBMANAGER, (Object)new Object[]{callBack, webView, settings});
    }

    public IWebPanelManager createWebPanel(ViewGroup containerLayout, @Nullable IWebPanelCallback callBack) {
        return (IWebPanelManager)MsgDispatcher.getInstance().sendMessageSync(MsgDef.MSG_WEBSERVICEWRAPPER_CREATEWEBPANEL, (Object)new Object[]{containerLayout, callBack});
    }

    public String getWebStorageValue(String key) {
        return WebStorage.getStorage(key);
    }

    private static final class SingleHolder {
        private static final WebServiceImpl INSTANCE = new WebServiceImpl();

        private SingleHolder() {
        }
    }
}

