/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.web;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Build;
import android.text.TextUtils;
import android.webkit.JsPromptResult;
import android.webkit.JsResult;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.data.JsonStringBuilder;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.web.IWebManager;
import com.yy.appbase.service.web.IWebManagerCallBack;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.IntentFilterConfig;
import com.yy.appbase.unifyconfig.config.WebViewLayerConfig;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.WebViewUtils;
import com.yy.framework.core.NavigationUtils;
import com.yy.hiyo.app.web.IntentFilterManager;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.module.webbussiness.nativeapp.AppInfoJsEvent;
import com.yy.webservice.IJsTitleBarAction;
import com.yy.webservice.WebConfigure;
import com.yy.webservice.WebEnvSettings;
import com.yy.webservice.WebViewStyle;
import com.yy.webservice.client.IWebBusinessCallBack;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsEventDispatch;
import com.yy.webservice.event.JsEventUtils;
import com.yy.webservice.event.parqam.IJsParam;
import com.yy.webservice.event.parqam.JsReturn;
import com.yy.webservice.preload.ILoadInterceptor;
import com.yy.webservice.preload.ILoadInterceptorCallBack;
import com.yy.webservice.webwindow.webview.ICallBack;
import com.yy.webservice.webwindow.webview.IWebIntentFilter;
import com.yy.webservice.webwindow.webview.IWebViewEventListener;
import com.yy.webservice.webwindow.webview.Utils;
import com.yy.webservice.webwindow.webview.WebBusinessHandlerCallback;
import com.yy.webservice.webwindow.webview.WebViewController;
import com.yy.webservice.webwindow.webview.base.WebViewSettings;
import com.yy.webservice.webwindow.webview.base.YYWebView;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class WebManager
implements IWebManager {
    private static final String TAG = "Web_WebManager";
    private IWebManagerCallBack mCallBack;
    private IWebViewEventListener mWebViewEventListener;
    private WebViewController mWebController;
    private ICallBack mWebViewCallBack;
    private IWebBusinessHandler mWebBusinessHandler;
    private final List<WebBusinessHandlerCallback> mWebBusinessHandlerCallbacks = new CopyOnWriteArrayList<WebBusinessHandlerCallback>();
    private IWebBusinessCallBack mBussinessCallBack;
    private JsEventDispatch mJsEventDispatch;
    private String mDefaultUa = "";
    private long mBeginLoadTime;
    private long mFinishLoadTime;
    private String mOriginUrl;
    private ILoadInterceptor mInterceptor;
    private WebView mWebView;
    private AppInfoJsEvent mAppInfoJsEvent;
    private String mWebId;
    private final List<String> mNotifyList = new CopyOnWriteArrayList<String>();
    private int mFrom;

    public WebManager(IWebManagerCallBack callBack, WebView webView, String defaultUa, @Nullable WebViewSettings settings, IWebBusinessCallBack wbc) {
        this.mCallBack = callBack;
        this.mBussinessCallBack = wbc;
        this.mDefaultUa = defaultUa;
        this.mFrom = callBack.from();
        this.init(webView, settings);
    }

    public void setLoadInterceptor(ILoadInterceptor interceptor) {
        this.mInterceptor = interceptor;
    }

    private void init(WebView webView, @Nullable WebViewSettings webViewSettings) {
        if (webView == null) {
            return;
        }
        WebViewSettings settings = new WebViewSettings();
        if (webViewSettings != null) {
            settings.useYYJsInterface = webViewSettings.useYYJsInterface;
            settings.renderMode = webViewSettings.renderMode;
        }
        settings.forceEnableSwLayer = this.shouldEnableSwLayer(RuntimeContext.sApplicationContext);
        this.mWebView = webView;
        this.mWebController = new WebViewController(settings, webView, this.generateWebConfigure(), this.getWebViewCallBack());
        this.mWebBusinessHandler = this.getBussinessHandler();
        this.mJsEventDispatch = new JsEventDispatch();
        this.mWebController.setWebViewEventListener(this.createWebViewEventListener());
        if (this.mBussinessCallBack != null) {
            this.mBussinessCallBack.onWebBusinessCreated(this.mWebBusinessHandler);
        }
    }

    public void onCreate() {
        if (this.mWebBusinessHandler != null) {
            this.mWebBusinessHandler.loadNotifyJs(JsEventDefine.NOTIFY.onWebViewLifecycle.notifyName(), "onCreate");
        }
    }

    public void onResume() {
        if (this.mWebBusinessHandler != null) {
            this.mWebBusinessHandler.loadNotifyJs(JsEventDefine.NOTIFY.onWebViewLifecycle.notifyName(), "onResume");
        }
    }

    public void onPause() {
        if (this.mWebBusinessHandler != null) {
            this.mWebBusinessHandler.loadNotifyJs(JsEventDefine.NOTIFY.onWebViewLifecycle.notifyName(), "onPause");
        }
    }

    public void destroy() {
        if (this.mWebBusinessHandler != null) {
            this.mWebBusinessHandler.loadNotifyJs(JsEventDefine.NOTIFY.onWebViewLifecycle.notifyName(), "onDestroy");
        }
        if (this.mWebController != null) {
            this.mWebController.setWebViewEventListener(null);
            this.mWebController.destroy();
        }
        for (WebBusinessHandlerCallback callback : this.mWebBusinessHandlerCallbacks) {
            callback.onWebViewDestroy();
        }
        if (this.mBussinessCallBack != null) {
            this.mBussinessCallBack.onWebBusinessDestroyed(this.mWebBusinessHandler);
        }
        this.mWebViewEventListener = null;
        this.mWebBusinessHandlerCallbacks.clear();
        this.mBussinessCallBack = null;
        this.mWebBusinessHandler = null;
        this.mCallBack = null;
        this.mWebController = null;
        this.mWebViewCallBack = null;
        this.mFrom = -1;
    }

    public void loadUrl(final String url) {
        this.mBeginLoadTime = System.currentTimeMillis();
        final Runnable command = new Runnable(){

            @Override
            public void run() {
                if (WebManager.this.mWebBusinessHandlerCallbacks != null && WebManager.this.mWebBusinessHandlerCallbacks.size() > 0) {
                    for (WebBusinessHandlerCallback callback : WebManager.this.mWebBusinessHandlerCallbacks) {
                        callback.beforeLoadUrl(url);
                    }
                }
                if (WebManager.this.mWebController != null) {
                    WebManager.this.mWebController.loadOriginUrl(url, false);
                }
                WebManager.this.mOriginUrl = url;
            }
        };
        if (this.mInterceptor != null) {
            this.mInterceptor.onLoadInterceptor(url, this.mWebBusinessHandler != null ? this.mWebBusinessHandler.getWebEnvSettings() : null, new ILoadInterceptorCallBack(){

                public void continueLoad() {
                    if (YYTaskExecutor.isMainThread()) {
                        command.run();
                    } else {
                        YYTaskExecutor.postToMainThread((Runnable)command);
                    }
                }

                public void cancel() {
                    MLog.info((Object)"WebManager", (String)"load url canceled by Interceptor!", (Object[])new Object[0]);
                }

                public int from() {
                    return WebManager.this.mFrom;
                }
            });
        } else {
            command.run();
        }
    }

    public void setWebViewListener(IWebViewEventListener listener) {
        this.mWebViewEventListener = listener;
    }

    public void setAppearanceCallback(WebViewController.AbsAppearanceCallback callback) {
        if (this.mWebController != null) {
            this.mWebController.setAppearanceCallback(callback);
        }
    }

    public IWebBusinessHandler getBussinessHandler() {
        if (this.mWebBusinessHandler == null) {
            this.mWebBusinessHandler = this.createBussinessHandler();
        }
        return this.mWebBusinessHandler;
    }

    private ICallBack getWebViewCallBack() {
        if (this.mWebViewCallBack != null) {
            return this.mWebViewCallBack;
        }
        this.mWebViewCallBack = new ICallBack(){

            public String getDefaultUA() {
                return WebManager.this.mDefaultUa;
            }

            public Activity getActivity() {
                return WebManager.this.getActivity();
            }

            @Nullable
            public IWebIntentFilter getIntentFilter(String url) {
                return IntentFilterManager.INSTANCE.getIntentFilter(url);
            }

            public boolean enabledWebContentsDebugging() {
                return RuntimeContext.sIsDebuggable;
            }

            public void onDownloadStart(String url, String userAgent, String contentDisposition, String mimetype, long contentLength) {
                if (this.getActivity() != null) {
                    NavigationUtils.startDownload((Activity)this.getActivity(), (String)url);
                }
            }

            public void onRefreshComplete(String originUrl, String url) {
                if (WebManager.this.mCallBack != null) {
                    WebManager.this.mCallBack.onRefreshComplete(originUrl, url);
                }
            }

            public void showNetError(String originUrl, int errorCode, String description, String url) {
                if (WebManager.this.mCallBack != null) {
                    WebManager.this.mCallBack.showNetError(originUrl, errorCode, description, url);
                }
            }

            public void showLoading() {
                if (WebManager.this.mCallBack != null) {
                    WebManager.this.mCallBack.showLoading();
                }
            }

            public void hideStatusView() {
                if (WebManager.this.mCallBack != null) {
                    WebManager.this.mCallBack.hideStatusView();
                }
            }

            public boolean nativeGetGameIsInstall(String gameId) {
                if (WebManager.this.mCallBack != null) {
                    return WebManager.this.mCallBack.nativeGetGameIsInstall(gameId);
                }
                return false;
            }

            public IJsParam callAppMethod(String module, String methodName, String context, String paramJson, String callback) {
                if (WebManager.this.mJsEventDispatch != null) {
                    return WebManager.this.mJsEventDispatch.dispatchEvent(WebManager.this.getBussinessHandler(), module, methodName, context, paramJson, callback);
                }
                return JsReturn.DEFAULT_ERROR;
            }

            public String appInfo() {
                if (WebManager.this.mAppInfoJsEvent == null) {
                    WebManager.this.mAppInfoJsEvent = new AppInfoJsEvent();
                }
                return WebManager.this.mAppInfoJsEvent.appInfo();
            }

            public String allSupportMethod() {
                if (WebManager.this.mJsEventDispatch != null) {
                    return WebManager.this.mJsEventDispatch.allSupportMethod();
                }
                return null;
            }

            public String userToken() {
                String token = "";
                AccountInfo accountInfo = AccountModel.getInstance().getAccountInfo();
                if (accountInfo != null) {
                    token = accountInfo.token;
                }
                return token;
            }

            public String myselfUserInfo() {
                UserInfoKS userInfo = ((IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class)).getUserInfo(AccountUtil.getUid());
                JsonStringBuilder json = JsonStringBuilder.newBuilder().put("uid", (Object)userInfo.uid).put("nickname", (Object)userInfo.nick);
                return json.buildJson();
            }

            public String getCurrentWebviewStyle() {
                JSONObject json = new JSONObject();
                try {
                    json.put("style", WebViewStyle.WEB_MANGER.getStyle());
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                return json.toString();
            }
        };
        return this.mWebViewCallBack;
    }

    private IWebBusinessHandler createBussinessHandler() {
        IWebBusinessHandler handler = new IWebBusinessHandler(){
            private WebEnvSettings mWebSettings;

            public int getWebIndex() {
                return 0;
            }

            public void addJsEvent(@NonNull JsEvent event) {
                if (WebManager.this.mJsEventDispatch != null) {
                    WebManager.this.mJsEventDispatch.addJsEvent(event);
                }
            }

            public void removeJsEvent(@NonNull JsEvent event) {
                if (WebManager.this.mJsEventDispatch != null) {
                    WebManager.this.mJsEventDispatch.removeJsEvent(event);
                }
            }

            public void loadPureJs(String js) {
                if (StringUtils.isEmpty((String)js)) {
                    return;
                }
                String jsStr = js.replace(" ", "");
                if (jsStr.startsWith("javascript:")) {
                    if (WebManager.this.mWebController != null) {
                        WebManager.this.mWebController.safetyLoadJs(js);
                    }
                } else if (WebManager.this.mWebController != null) {
                    WebManager.this.mWebController.safetyLoadJs(JsEventUtils.formatPureLoadJs((String)js));
                }
            }

            public void loadCallbackJs(String callbackName, String context, String param) {
                if (WebManager.this.mWebController != null) {
                    WebManager.this.mWebController.safetyLoadJs(JsEventUtils.formatLoadJs((String)callbackName, (String)context, (String)param));
                }
            }

            public void loadNotifyJs(String notifyName, String param) {
                if (WebManager.this.mWebController != null) {
                    WebManager.this.mWebController.safetyLoadJs(JsEventUtils.formatLoadJs((String)notifyName, (String)"notify", (String)param));
                }
            }

            public void exit() {
                WebManager.this.handleExitByWeb();
            }

            public WebEnvSettings getWebEnvSettings() {
                if (WebManager.this.mWebController != null && this.mWebSettings == null) {
                    this.mWebSettings = new WebEnvSettings();
                    this.mWebSettings.url = WebManager.this.mOriginUrl;
                    this.mWebSettings.statParams.startLoadPageTime = WebManager.this.mBeginLoadTime;
                } else if (this.mWebSettings != null && StringUtils.isEmpty((String)this.mWebSettings.url)) {
                    this.mWebSettings.url = WebManager.this.mOriginUrl;
                    this.mWebSettings.statParams.startLoadPageTime = WebManager.this.mBeginLoadTime;
                }
                return this.mWebSettings;
            }

            public void showProgressDialog(String label, boolean cancelable, int timeOut) {
            }

            public void hideProgress() {
            }

            public void showAlertDialog(String title, String message, String positiveButton, String neutralButton, String negativeButton, boolean cancelable, Utils.IAlertDialogCallBack callBack) {
                if (WebManager.this.mCallBack != null) {
                    Utils.showAlertDialog((Activity)WebManager.this.mCallBack.getActivity(), (String)title, (String)message, (String)positiveButton, (String)neutralButton, (String)negativeButton, (boolean)cancelable, (Utils.IAlertDialogCallBack)callBack);
                }
            }

            public void refreshWebView() {
            }

            public boolean addWebViweClientFilterList(String jsonData) {
                if (WebManager.this.mWebController != null) {
                    return WebManager.this.mWebController.addWebViweClientFilterList(jsonData);
                }
                return false;
            }

            public void appendUserAgentString(String ua) {
                if (WebManager.this.mWebController != null) {
                    WebManager.this.mWebController.appendUserAgentString(ua);
                }
            }

            public void updateUserAgentString(String ua) {
                if (WebManager.this.mWebController != null) {
                    WebManager.this.mWebController.setUserAgentString(ua);
                }
            }

            public void setTouchAreas(List<Rect> touchArea, boolean showDebugAreaView) {
            }

            public List<Rect> getTouchAreas() {
                return null;
            }

            public void loadUrl(String url) {
                if (WebManager.this.mWebController != null && !StringUtils.isEmpty((String)url)) {
                    WebManager.this.mWebController.loadUrl(url, true);
                }
            }

            public IJsTitleBarAction getJsChangeTitleBarAction() {
                return null;
            }

            public void showStatusBar(boolean isShow) {
            }

            public void setTitleImage(int imageResId) {
            }

            public void updateTitleMsgStatus(int id2, String badge) {
            }

            public void onSetPageBackMode(String backMode, String lastLayerUrl) {
            }

            public void addWebViewListener(@Nullable WebBusinessHandlerCallback callback) {
                if (callback == null) {
                    return;
                }
                if (!WebManager.this.mWebBusinessHandlerCallbacks.contains(callback)) {
                    WebManager.this.mWebBusinessHandlerCallbacks.add(callback);
                }
            }

            public void removeWebViewListener(@Nullable WebBusinessHandlerCallback callback) {
                if (callback == null) {
                    return;
                }
                if (WebManager.this.mWebBusinessHandlerCallbacks.contains(callback)) {
                    WebManager.this.mWebBusinessHandlerCallbacks.remove(callback);
                }
            }

            public boolean enablePushRefresh(boolean enable) {
                return false;
            }

            public void interceptBack(int intercept) {
            }

            public void simulateAppBack(int type2) {
            }

            public long getWebViewBeginTime() {
                return WebManager.this.mBeginLoadTime;
            }

            public long getWebViewFinishTime() {
                return WebManager.this.mFinishLoadTime;
            }

            @Nullable
            public Context getContext() {
                if (WebManager.this.mWebController != null) {
                    return WebManager.this.mWebController.getContext();
                }
                return null;
            }

            public void setWebId(String webId) {
                MLog.info((Object)WebManager.TAG, (String)"setWebId webId: %s", (Object[])new Object[]{webId});
                WebManager.this.mWebId = webId;
            }

            public String getWeId() {
                return WebManager.this.mWebId;
            }

            public boolean isUseCacheWeb() {
                if (WebManager.this.mWebView != null && WebManager.this.mWebView instanceof YYWebView) {
                    return ((YYWebView)WebManager.this.mWebView).isReused();
                }
                return false;
            }

            public boolean registerNotify(String notify) {
                MLog.debug((Object)WebManager.TAG, (String)"registerNotify webId: %s, notify: %s", (Object[])new Object[]{WebManager.this.mWebId, notify});
                if (TextUtils.isEmpty((CharSequence)notify)) {
                    MLog.error((Object)WebManager.TAG, (String)"registerNotify webId: %s, notify: %s", (Object[])new Object[]{WebManager.this.mWebId, notify});
                    return false;
                }
                return WebManager.this.mNotifyList.add(notify);
            }

            public boolean unregisterNotify(String notify) {
                MLog.debug((Object)WebManager.TAG, (String)"unregisterNotify webId: %s, notify: %s", (Object[])new Object[]{WebManager.this.mWebId, notify});
                if (TextUtils.isEmpty((CharSequence)notify)) {
                    MLog.error((Object)WebManager.TAG, (String)"unregisterNotify webId: %s, notify: %s", (Object[])new Object[]{WebManager.this.mWebId, notify});
                    return false;
                }
                return WebManager.this.mNotifyList.add(notify);
            }

            public void updateRenderMode(int mode) {
                if (WebManager.this.mWebController != null) {
                    WebManager.this.mWebController.updateRenderMode(mode);
                }
            }
        };
        return handler;
    }

    private IWebViewEventListener createWebViewEventListener() {
        IWebViewEventListener webViewEventListener = new IWebViewEventListener(){

            public void onReceivedTitle(WebView view, String title) {
                if (WebManager.this.mWebViewEventListener != null) {
                    WebManager.this.mWebViewEventListener.onReceivedTitle(view, title);
                }
            }

            public boolean shouldOverrideUrlLoading(WebView view, String url) {
                if (WebManager.this.mWebViewEventListener != null) {
                    return WebManager.this.mWebViewEventListener.shouldOverrideUrlLoading(view, url);
                }
                return true;
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                for (WebBusinessHandlerCallback callback : WebManager.this.mWebBusinessHandlerCallbacks) {
                    callback.onPageStarted(view, url, favicon);
                }
                if (WebManager.this.mWebViewEventListener != null) {
                    WebManager.this.mWebViewEventListener.onPageStarted(view, url, favicon);
                }
            }

            public void onPageFinished(WebView view, String url) {
                WebManager.this.mFinishLoadTime = System.currentTimeMillis();
                for (WebBusinessHandlerCallback callback : WebManager.this.mWebBusinessHandlerCallbacks) {
                    callback.onPageFinished(view, url);
                }
                if (WebManager.this.mWebViewEventListener != null) {
                    WebManager.this.mWebViewEventListener.onPageFinished(view, url);
                }
                if (WebManager.this.mWebBusinessHandler != null) {
                    WebManager.this.mWebBusinessHandler.loadNotifyJs(JsEventDefine.NOTIFY.onWebViewLifecycle.notifyName(), "onFinishLoad");
                }
            }

            public void onLoadResource(WebView view, String url) {
                if (WebManager.this.mWebViewEventListener != null) {
                    WebManager.this.mWebViewEventListener.onLoadResource(view, url);
                }
            }

            public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
                for (WebBusinessHandlerCallback callback : WebManager.this.mWebBusinessHandlerCallbacks) {
                    callback.onReceivedError(view, errorCode, description, failingUrl);
                }
                if (WebManager.this.mWebViewEventListener != null) {
                    WebManager.this.mWebViewEventListener.onReceivedError(view, errorCode, description, failingUrl);
                }
            }

            public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
                WebResourceResponse resourceResponse = null;
                for (WebBusinessHandlerCallback callback : WebManager.this.mWebBusinessHandlerCallbacks) {
                    resourceResponse = callback.shouldInterceptRequest(view, request);
                    if (resourceResponse == null) continue;
                    return resourceResponse;
                }
                return null;
            }

            public void onReceivedHttpError(WebView view, WebResourceRequest request, WebResourceResponse errorResponse) {
                for (WebBusinessHandlerCallback callback : WebManager.this.mWebBusinessHandlerCallbacks) {
                    callback.onReceivedHttpError(view, request, errorResponse);
                }
                if (WebManager.this.mWebViewEventListener != null) {
                    WebManager.this.mWebViewEventListener.onReceivedHttpError(view, request, errorResponse);
                }
            }

            public void onProgressChanged(WebView view, int newProgress) {
                if (WebManager.this.mWebViewEventListener != null) {
                    WebManager.this.mWebViewEventListener.onProgressChanged(view, newProgress);
                }
            }

            public void onReceivedIcon(WebView view, Bitmap icon) {
                if (WebManager.this.mWebViewEventListener != null) {
                    WebManager.this.mWebViewEventListener.onReceivedIcon(view, icon);
                }
            }

            public void onReceivedTouchIconUrl(WebView view, String url, boolean precomposed) {
                if (WebManager.this.mWebViewEventListener != null) {
                    WebManager.this.mWebViewEventListener.onReceivedTouchIconUrl(view, url, precomposed);
                }
            }

            public void onRequestFocus(WebView view) {
                if (WebManager.this.mWebViewEventListener != null) {
                    WebManager.this.mWebViewEventListener.onRequestFocus(view);
                }
            }

            public boolean onJsAlert(WebView view, String url, String message, JsResult result) {
                if (WebManager.this.mWebViewEventListener != null) {
                    return WebManager.this.mWebViewEventListener.onJsAlert(view, url, message, result);
                }
                return false;
            }

            public boolean onJsConfirm(WebView view, String url, String message, JsResult result) {
                if (WebManager.this.mWebViewEventListener != null) {
                    return WebManager.this.mWebViewEventListener.onJsConfirm(view, url, message, result);
                }
                return false;
            }

            public boolean onJsPrompt(WebView view, String url, String message, String defaultValue, JsPromptResult result) {
                if (WebManager.this.mWebViewEventListener != null) {
                    return WebManager.this.mWebViewEventListener.onJsPrompt(view, url, message, defaultValue, result);
                }
                return false;
            }

            public boolean onJsBeforeUnload(WebView view, String url, String message, JsResult result) {
                if (WebManager.this.mWebViewEventListener != null) {
                    return WebManager.this.mWebViewEventListener.onJsBeforeUnload(view, url, message, result);
                }
                return false;
            }

            public boolean onJsTimeout() {
                if (WebManager.this.mWebViewEventListener != null) {
                    return WebManager.this.mWebViewEventListener.onJsTimeout();
                }
                return false;
            }
        };
        return webViewEventListener;
    }

    private Activity getActivity() {
        if (this.mCallBack != null) {
            return this.mCallBack.getActivity();
        }
        return null;
    }

    private void handleExitByWeb() {
        if (this.mCallBack != null) {
            this.mCallBack.handleExitByWeb();
        }
    }

    private void toNewJSSupportedWebView(String url) {
        if (this.mCallBack != null) {
            this.mCallBack.toNewJSSupportedWebView(url);
        }
    }

    private boolean shouldEnableSwLayer(Context context) {
        WebViewLayerConfig webViewLayerConfig;
        WebViewLayerConfig.WebViewLayerConfigData hwConfigData;
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.WEBVIEW_LAYER_CONFIG);
        if (configData instanceof WebViewLayerConfig && (hwConfigData = (webViewLayerConfig = (WebViewLayerConfig)configData).getData()) != null && hwConfigData.getConfigs() != null && !hwConfigData.getConfigs().isEmpty()) {
            int sdk = Build.VERSION.SDK_INT;
            PackageInfo webViewPackage = WebViewUtils.INSTANCE.getCurrentWebViewPackage(context);
            if (webViewPackage != null && !TextUtils.isEmpty((CharSequence)webViewPackage.versionName)) {
                String webViewVersion = webViewPackage.versionName;
                int scene = this.mFrom;
                for (WebViewLayerConfig.WebViewLayerConfigItem item : hwConfigData.getConfigs()) {
                    if (item.getSdkInt() != sdk || item.getScene() != scene || !webViewVersion.equals(item.getWebViewVersion())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private WebConfigure generateWebConfigure() {
        WebConfigure config = new WebConfigure();
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.WEB_INTENT_FILTER);
        if (configData instanceof IntentFilterConfig) {
            config.setIgnoreOverrideBlack(((IntentFilterConfig)configData).getIgnoreOverrideBlack());
        }
        return config;
    }
}

