/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.serverwrapper;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.os.Message;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.banned.BannedDialog;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.app.IAppService;
import com.yy.appbase.ui.dialog.AppealDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.dialog.OkDialog;
import com.yy.appbase.ui.dialog.OkDialogListener;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.okhttp.websocket.WsStatus;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.NavigationUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.app.perf.PerfManager;
import com.yy.hiyo.app.serverwrapper.appeal.AppealFailedTipDialog;
import com.yy.hiyo.app.serverwrapper.appeal.AppealQueryReqData;
import com.yy.hiyo.app.serverwrapper.appeal.AppealResultRespBean;
import com.yy.hiyo.app.serverwrapper.appeal.AppealResultRespData;
import com.yy.hiyo.channel.ChannelNotifyDef;
import com.yy.hiyo.im.IMsgReceiveService;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.main.R;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.proto.GlobalBanInterface;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import com.yy.hiyo.proto.callback.ISocketStateChangeListener;
import com.yy.hiyo.push.base.PushSDKHelper;
import common.ERet;
import common.Header;
import ikxd.cproxy.CProxy;
import ikxd.cproxy.ToastNotify;
import ikxd.cproxy.Uri;
import ikxd.informAgainst.FeedbackNotify;
import ikxd.informAgainst.InformAgainst;
import ikxd.msg.PullType;
import java.util.HashMap;
import java.util.Random;
import okhttp3.Call;

public class WsServiceWrapper
implements INotify,
ISocketStateChangeListener {
    private static final String TAG = "WsServiceWrapper";
    private ICallBack mCallBack;
    private boolean mHasMsgPulled = false;
    private INotify mInformAgainstNotify;
    private INotify mLoginOutNotify;
    private boolean mWsConnectedBefore = false;
    private boolean mNeedPullMsg = false;
    Runnable mPullMsgTask = new Runnable(){

        @Override
        public void run() {
            IMsgReceiveService messageService;
            ImService imService;
            WsServiceWrapper.this.mHasMsgPulled = true;
            WsServiceWrapper.this.mNeedPullMsg = false;
            if (WsServiceWrapper.this.mCallBack.getServiceManager() != null && (imService = (ImService)WsServiceWrapper.this.mCallBack.getServiceManager().getService(ImService.class)) != null && (messageService = imService.getReceiveMsg()) != null) {
                messageService.pullMsg(PullType.Default.getValue());
            }
        }
    };
    private BannedDialog curShow;

    public WsServiceWrapper(ICallBack callBack) {
        this.mCallBack = callBack;
        this.init();
    }

    private void init() {
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_BAN_ACTION, (INotify)this);
        this.handleWebSocketCode();
        AccountModel.getInstance().setWsConnectErrorHandler(new AccountModel.IWsConnectErrorHandler(){

            public boolean onCurWsConnectError(int code) {
                if (code == 4000 || code == 4004) {
                    WsServiceWrapper.this.handleKickOff(code == 4004, "");
                    return true;
                }
                return false;
            }
        });
    }

    private void handleWebSocketCode() {
        ProtoManager.getInstance().registerNotify((IProtoNotify)new IProtoNotify<CProxy>(){

            public String serviceName() {
                return "ikxd_cproxy_d";
            }

            public void onNotify(@NonNull CProxy cproxy) {
                if (cproxy.uri == Uri.kUriToastNotify) {
                    Header cproxyHeader = cproxy.header;
                    if (cproxyHeader != null) {
                        if (cproxyHeader.code == (long)ERet.kRetErrVersion.getValue()) {
                            WsServiceWrapper.this.showUpgradeDialog();
                        } else {
                            ToastNotify toastNotify = cproxy.toast_notify;
                            if (toastNotify == null) {
                                return;
                            }
                            if (toastNotify.logout.booleanValue()) {
                                WsServiceWrapper.this.handleKickOff(toastNotify.multi_app, toastNotify.toast);
                            }
                        }
                    }
                } else if (cproxy.uri == Uri.kUriProbeNotify) {
                    this.sendNeedle(cproxy);
                }
            }

            private void sendNeedle(@NonNull CProxy cproxy) {
                ProtoManager.getInstance().send((AndroidMessage)cproxy, (IProtoCallback)new IProtoCallback<CProxy>(){

                    public void onResponse(@Nullable CProxy message) {
                        MLog.info((Object)WsServiceWrapper.TAG, (String)"\u53d1\u9001\u63a2\u9488\u6210\u529f", (Object[])new Object[0]);
                    }

                    public boolean retryWhenTimeout(boolean canRetry) {
                        return false;
                    }

                    public boolean retryWhenError(boolean canRetry, String reason, int code) {
                        return false;
                    }
                });
            }
        });
        ProtoManager.getInstance().registerNotify((IProtoNotify)new IProtoNotify<InformAgainst>(){

            public String serviceName() {
                return "ikxd_inform_against_d";
            }

            public void onNotify(final @NonNull InformAgainst informAgainst) {
                if (informAgainst == null) {
                    return;
                }
                if (informAgainst.uri == ikxd.informAgainst.Uri.kUriBannedNotify) {
                    AccountModel.getInstance().onBannedNotify();
                    if (RuntimeContext.sIsAppStartFinished) {
                        WsServiceWrapper.this.handleInformAgainst(informAgainst);
                    } else if (WsServiceWrapper.this.mInformAgainstNotify == null) {
                        WsServiceWrapper.this.mInformAgainstNotify = new INotify(){

                            public void notify(Notification notification) {
                                if (notification != null && notification.id == NotificationDef.N_STARTUP_FINISHED) {
                                    WsServiceWrapper.this.handleInformAgainst(informAgainst);
                                }
                                NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_STARTUP_FINISHED, WsServiceWrapper.this.mInformAgainstNotify);
                                WsServiceWrapper.this.mInformAgainstNotify = null;
                            }
                        };
                        NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, WsServiceWrapper.this.mInformAgainstNotify);
                    }
                } else if (informAgainst.uri == ikxd.informAgainst.Uri.kUriFeedbackNotify) {
                    WsServiceWrapper.this.handleUriFeedbackNotify(informAgainst.feedback_notify);
                } else if (informAgainst.uri == ikxd.informAgainst.Uri.kUriVideoWarnNotify) {
                    String cid = informAgainst.video_warn_notify.c_id;
                    WsServiceWrapper.this.handleUriVideoWarnNotify(cid);
                } else if (informAgainst.uri == ikxd.informAgainst.Uri.kUriAudioAIPornNotify) {
                    String cid = informAgainst.audio_ai_porn_notify.c_id;
                    WsServiceWrapper.this.handleUriAudioWarnNotify(cid);
                }
            }
        });
        this.monitorAndStatWsConnect();
    }

    private void monitorAndStatWsConnect() {
        if (SettingFlags.containKey((String)"ws_stat_connect")) {
            boolean lastConnect = SettingFlags.getBoolean((String)"ws_stat_connect", (boolean)true);
            if (SettingFlags.containKey((String)"ws_stat_never_connect")) {
                PerfManager.statWsConnect(lastConnect, SettingFlags.getBoolean((String)"ws_stat_never_connect", (boolean)false));
            } else {
                PerfManager.statWsConnect(lastConnect, false);
            }
        }
        boolean connect = ProtoManager.getInstance().isWSConnected();
        if (RuntimeContext.isStartAtFirstInstalled() && !connect) {
            SettingFlags.setBoolean((String)"ws_stat_never_connect", (boolean)true);
        }
        if (!this.mWsConnectedBefore) {
            this.mWsConnectedBefore = connect;
            if (this.mWsConnectedBefore) {
                SettingFlags.setBoolean((String)"ws_stat_connect", (boolean)true);
                if (SettingFlags.containKey((String)"ws_stat_never_connect")) {
                    SettingFlags.removeKey((String)"ws_stat_never_connect");
                }
            } else if (NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                SettingFlags.setBoolean((String)"ws_stat_connect", (boolean)false);
            } else {
                SettingFlags.setBoolean((String)"ws_stat_connect", (boolean)true);
            }
        }
    }

    private void handleKickOff(final boolean kickoffByOurOtherApp, final String toast) {
        AccountModel.getInstance().onKickOffNotify();
        MLog.error((Object)TAG, (String)"onNotify logout: kickoff!", (Object[])new Object[0]);
        final Runnable command = new Runnable(){

            @Override
            public void run() {
                if (AccountUtil.getUid() > 0L && !kickoffByOurOtherApp) {
                    AccountModel.getInstance().deleteHasLoginedAccount(AccountUtil.getUid());
                }
                if (kickoffByOurOtherApp) {
                    MsgDispatcher.getInstance().sendMessage(MsgDef.LOGIN_OUT, 9, -1, null);
                } else {
                    MsgDispatcher.getInstance().sendMessage(MsgDef.LOGIN_OUT, 2, -1, null);
                    if (StringUtils.isNotEmpty((String)toast)) {
                        SingleToastUtil.showToast((Context)RuntimeContext.sApplicationContext, (String)toast);
                    } else {
                        SingleToastUtil.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.login_kick_off_tips));
                    }
                }
            }
        };
        if (AccountUtil.getUid() > 0L && RuntimeContext.sIsAppStartFinished) {
            command.run();
        } else if (this.mLoginOutNotify == null) {
            this.mLoginOutNotify = new INotify(){

                public void notify(Notification notification) {
                    if (notification != null && notification.id == NotificationDef.N_STARTUP_FINISHED) {
                        command.run();
                    }
                    NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_STARTUP_FINISHED, WsServiceWrapper.this.mLoginOutNotify);
                    WsServiceWrapper.this.mLoginOutNotify = null;
                }
            };
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, this.mLoginOutNotify);
        }
    }

    private void handleInformAgainst(InformAgainst informAgainst) {
        long msg = informAgainst.banned_notify.unseal_time;
        MLog.error((Object)TAG, (String)"kUriBannedNotify: %s", (Object[])new Object[]{msg});
        String bannedTittle = informAgainst.banned_notify.msg;
        String bannedContent = informAgainst.banned_notify.reason_msg;
        String bannedReason = informAgainst.banned_notify.against_desc;
        long day = informAgainst.banned_notify.days.intValue();
        long remainSecond = informAgainst.banned_notify.remain_second;
        GlobalBanInterface.INSTANCE.updateBanInfo(bannedTittle, bannedContent, bannedReason, day, remainSecond, true);
        this.handleUriBannedNotify(bannedTittle, bannedContent, bannedReason, day, remainSecond);
    }

    private void handleUriBannedNotify(final String bannedTittle, final String bannedContent, final String bannedReason, final long day, final long remainSecond) {
        ProtoManager.getInstance().disconnect();
        long mUid = AccountUtil.getUid();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                final DialogLinkManager dialogLinkManager = WsServiceWrapper.this.mCallBack.getDialogmanager();
                if (dialogLinkManager == null) {
                    return;
                }
                final String token = CommonHttpHeader.getAuthToken();
                WsServiceWrapper.this.sendMessage(MsgDef.LOGIN_OUT, 4, -1, null);
                if (WsServiceWrapper.this.curShow != null) {
                    return;
                }
                BannedDialog bannedDialog = new BannedDialog((Context)WsServiceWrapper.this.mCallBack.getActivity(), bannedTittle, bannedContent, bannedReason, day, remainSecond, 1);
                WsServiceWrapper.this.curShow = bannedDialog;
                bannedDialog.show();
                bannedDialog.setOkCancelDialogListener(new OkCancelDialogListener(){

                    public void onCancel() {
                    }

                    public void onOk() {
                        AppealDialog appealDialog = new AppealDialog((Context)WsServiceWrapper.this.mCallBack.getActivity());
                        appealDialog.setToken(token);
                        appealDialog.setType(4);
                        dialogLinkManager.showDialog((BaseDialog)appealDialog);
                    }
                });
                bannedDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                    public void onDismiss(DialogInterface dialogInterface) {
                        WsServiceWrapper.this.curShow = null;
                    }
                });
            }
        });
        this.againstQuery(mUid);
    }

    private void handleUriFeedbackNotify(FeedbackNotify notify) {
        IAppService appService = (IAppService)ServiceManagerProxy.getService(IAppService.class);
        VersionUtil.Ver ver = VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext);
        String appVer = ver.aboutDisplayName(RuntimeContext.sApplicationContext);
        MLog.error((Object)TAG, (String)"auto feedback:%s,branch:%s", (Object[])new Object[]{appVer, appService != null ? appService.getBranchName() : ""});
        if (RuntimeContext.sIsDebuggable) {
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)"receive feedback notify", (int)1);
        }
        this.sendMessage(BaseMsgDef.MSG_FEED_BACK_AUTO_REPORT_LOG, notify);
    }

    private void handleUriAudioWarnNotify(String cid) {
        MLog.info((Object)TAG, (String)"handleUriAudioWarnNotify %s", (Object[])new Object[]{cid});
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ChannelNotifyDef.AUDIO_WARN_NOTIFY, (Object)cid));
    }

    private void handleUriVideoWarnNotify(String cid) {
        MLog.info((Object)TAG, (String)"handleUriVideoWarnNotify %s", (Object[])new Object[]{cid});
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ChannelNotifyDef.VIDEO_WARN_NOTIFY, (Object)cid));
    }

    private void showUpgradeDialog() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                DialogLinkManager dialogLinkManager = WsServiceWrapper.this.mCallBack.getDialogmanager();
                if (dialogLinkManager == null) {
                    return;
                }
                OkDialog dialog = new OkDialog((CharSequence)ResourceUtils.getString((int)R.string.upgrade_tip), true, new OkDialogListener(){

                    public void onOk() {
                        NavigationUtils.navToBrower((Context)WsServiceWrapper.this.mCallBack.getActivity(), (String)"https://play.google.com/store/apps/details?id=com.live.party");
                    }
                }, false);
                dialog.setShowCancel(true);
                dialog.setCancleListener(new DialogInterface.OnCancelListener(){

                    public void onCancel(DialogInterface dialog) {
                        WsServiceWrapper.this.sendMessageSync(BaseMsgDef.APP_EXIT);
                    }
                });
                dialogLinkManager.showDialog((BaseDialog)dialog);
            }
        });
    }

    private void sendMessage(int msgid) {
        MsgDispatcher.getInstance().sendMessage(msgid);
    }

    private void sendMessage(int msgid, int arg1, int arg2, Object object) {
        MsgDispatcher.getInstance().sendMessage(msgid, arg1, arg2, object);
    }

    private void sendMessage(int msgid, Object object) {
        MsgDispatcher.getInstance().sendMessage(msgid, 0, 0, object);
    }

    private void sendMessageSync(int msgid) {
        MsgDispatcher.getInstance().sendMessageSync(msgid);
    }

    public void notify(Notification notification) {
        if (notification == null) {
            return;
        }
        if (notification.id == NotificationDef.N_STARTUP_FINISHED) {
            if (ProtoManager.getInstance().getCurrentStatus() == WsStatus.CONNECT_SUCCESS) {
                this.onSocketStateChanged(102, ProtoManager.getInstance().getCurWSURL(), "");
            }
            ProtoManager.getInstance().addSocketStateChangeListener((ISocketStateChangeListener)this);
        } else if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (WsServiceWrapper.this.mNeedPullMsg) {
                        WsServiceWrapper.this.mNeedPullMsg = false;
                        WsServiceWrapper.this.mPullMsgTask.run();
                    }
                }
            });
        } else if (notification.id == NotificationDef.N_BAN_ACTION) {
            this.handleBanAction((GlobalBanInterface.BanInfo)notification.extObj);
        }
    }

    private void handleBanAction(GlobalBanInterface.BanInfo info) {
        final DialogLinkManager dialogLinkManager = this.mCallBack.getDialogmanager();
        if (dialogLinkManager == null) {
            return;
        }
        if (this.curShow != null) {
            return;
        }
        final String token = CommonHttpHeader.getAuthToken();
        String bannedTittle = info.bannedTittle;
        String bannedContent = info.bannedContent;
        String bannedReason = info.bannedReason;
        long day = info.day;
        long remainSecond = info.remainSecond;
        BannedDialog bannedDialog = new BannedDialog((Context)this.mCallBack.getActivity(), bannedTittle, bannedContent, bannedReason, day, remainSecond, 3);
        bannedDialog.show();
        this.curShow = bannedDialog;
        bannedDialog.setOkCancelDialogListener(new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                AppealDialog appealDialog = new AppealDialog((Context)WsServiceWrapper.this.mCallBack.getActivity());
                appealDialog.setToken(token);
                appealDialog.setType(4);
                dialogLinkManager.showDialog((BaseDialog)appealDialog);
            }
        });
        bannedDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

            public void onDismiss(DialogInterface dialog) {
                WsServiceWrapper.this.curShow = null;
            }
        });
    }

    public void onSocketStateChanged(final int code, final String wsUrl, final String errorInfo) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (102 == code) {
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.WSCLIENT_CONNECT_SUCCESS));
                    PushSDKHelper.onSocketStateChanged();
                    if (WsServiceWrapper.this.mHasMsgPulled) {
                        YYTaskExecutor.postToMainThread((Runnable)WsServiceWrapper.this.mPullMsgTask, (long)new Random().nextInt(5000));
                    } else if (RuntimeContext.sIsAppStartFinishAfterOneSecond) {
                        WsServiceWrapper.this.mPullMsgTask.run();
                    } else {
                        WsServiceWrapper.this.mNeedPullMsg = true;
                    }
                    NetworkUtils.updateWsConnect((boolean)true);
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.WEBSOCKET_CONNECT));
                    if (!WsServiceWrapper.this.mWsConnectedBefore) {
                        WsServiceWrapper.this.mWsConnectedBefore = ProtoManager.getInstance().isWSConnected();
                        if (WsServiceWrapper.this.mWsConnectedBefore) {
                            SettingFlags.setBoolean((String)"ws_stat_connect", (boolean)true);
                            if (SettingFlags.containKey((String)"ws_stat_never_connect")) {
                                SettingFlags.removeKey((String)"ws_stat_never_connect");
                            }
                        }
                    }
                    PerfManager.statWsConnect(true, wsUrl, errorInfo);
                } else {
                    WsStatus status = ProtoManager.getInstance().getWsStatus();
                    if (status == WsStatus.CONNECT_FAIL || status != WsStatus.CONNECTING && !ProtoManager.getInstance().isWSConnected()) {
                        PerfManager.statWsConnect(false, wsUrl, errorInfo);
                        if (RuntimeContext.sIsAppStartFinished) {
                            Bundle data = new Bundle();
                            data.putString("url", wsUrl);
                            Message message = Message.obtain();
                            message.what = BaseMsgDef.MSG_NET_WORK_CHECK_BY_WS_ERROR;
                            message.obj = errorInfo;
                            message.setData(data);
                            MsgDispatcher.getInstance().sendMessage(message);
                        }
                    }
                    NetworkUtils.updateWsConnect((boolean)false);
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.WEBSOCKET_DISCONNECT, (Object)errorInfo));
                }
            }
        });
    }

    private void againstQuery(final long uid) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                AppealQueryReqData reqData = new AppealQueryReqData();
                reqData.setUid(AccountUtil.getUid());
                String token = CommonHttpHeader.getAuthToken();
                HashMap<String, String> headMap = new HashMap<String, String>();
                headMap.put("Appeal-Token", token);
                String url = WsServiceWrapper.this.getHttpUrl(UriProvider.getIkxdSvrHost() + "/inform_against/query_user_appeal?data=", JsonParser.toJson((Object)reqData));
                MLog.info((Object)WsServiceWrapper.TAG, (String)("againstQuery onResponse url:" + url), (Object[])new Object[0]);
                HttpUtil.httpReq((String)url, null, (int)1, (INetRespCallback)new INetRespCallback<AppealResultRespData>(){

                    public void onError(Call call, Exception e, int id2) {
                        MLog.error((Object)WsServiceWrapper.TAG, (String)("againstQuery onError Exception:" + e.toString()), (Object[])new Object[0]);
                    }

                    public void onResponse(String response, BaseResponseBean<AppealResultRespData> res, int id2) {
                        if (res != null) {
                            MLog.info((Object)WsServiceWrapper.TAG, (String)("againstQuery onResponse res:" + res.toString()), (Object[])new Object[0]);
                        } else {
                            MLog.info((Object)WsServiceWrapper.TAG, (String)"againstQuery onResponse res: null", (Object[])new Object[0]);
                        }
                        if (res != null && res.data != null && !FP.empty(((AppealResultRespData)res.data).getAppealResultList())) {
                            if (res.isSuccess()) {
                                AppealResultRespBean bean = ((AppealResultRespData)res.data).getAppealResultList().get(0);
                                long lastResultTime = SettingFlags.getLongValue((String)("flag_appeal_result_id_" + AccountUtil.getUid()), (long)0L);
                                if (bean.getTime() == lastResultTime) {
                                    return;
                                }
                                if (bean.getTime() <= bean.getBan_time()) {
                                    return;
                                }
                                if (uid != bean.getUid()) {
                                    return;
                                }
                                if (bean.getAppeal_result() == 2) {
                                    MLog.info((Object)WsServiceWrapper.TAG, (String)"againstQuery onResponse Appeal_result: 2", (Object[])new Object[0]);
                                    SettingFlags.setLongValue((String)("flag_appeal_result_id_" + AccountUtil.getUid()), (long)bean.getTime());
                                    WsServiceWrapper.this.showSafelyReviewDialog(bean.getTips());
                                } else {
                                    MLog.info((Object)WsServiceWrapper.TAG, (String)("againstQuery onResponse Appeal_result:" + bean.getAppeal_result()), (Object[])new Object[0]);
                                }
                            } else {
                                MLog.error((Object)WsServiceWrapper.TAG, (String)("againstQuery onResponse res:" + res.toString()), (Object[])new Object[0]);
                            }
                        }
                    }
                }, headMap);
            }
        });
    }

    private String getHttpUrl(String url, String paramJson) {
        return url + paramJson;
    }

    private void showSafelyReviewDialog(String content) {
        MLog.info((Object)TAG, (String)"showSafelyReviewDialog", (Object[])new Object[0]);
        AppealFailedTipDialog appealDialog = new AppealFailedTipDialog(content);
        DialogLinkManager dialogLinkManager = this.mCallBack.getDialogmanager();
        if (dialogLinkManager == null) {
            return;
        }
        dialogLinkManager.showDialog((BaseDialog)appealDialog);
    }

    public static interface ICallBack {
        public DialogLinkManager getDialogmanager();

        public IServiceManager getServiceManager();

        public Activity getActivity();
    }
}

