/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.screenrecord;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.os.IBinder;
import androidx.annotation.Nullable;
import com.yy.base.logger.MLog;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.MainActivity;
import com.yy.hiyo.channel.ChannelBaseMsgDef;
import com.yy.hiyo.main.R;
import java.util.Objects;

public class CaptureScreenService
extends Service {
    private int mResultCode;
    private Intent mResultData;
    private MediaProjectionManager projectionManager;
    private MediaProjection mMediaProjection;
    private static final int const_nid = 1100;

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.createNotificationChannel();
        this.mResultCode = intent.getIntExtra("code", -1);
        this.mResultData = (Intent)intent.getParcelableExtra("data");
        this.projectionManager = (MediaProjectionManager)this.getSystemService("media_projection");
        this.mMediaProjection = this.projectionManager.getMediaProjection(this.mResultCode, Objects.requireNonNull(this.mResultData));
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ChannelBaseMsgDef.CAPTURE_SCREEN_PERMISSION_REQUESTForQ, (Object)this.mMediaProjection));
        MLog.info((Object)"PETERTEST", (String)"onStartCommand", (Object[])new Object[0]);
        return super.onStartCommand(intent, flags, startId);
    }

    private void createNotificationChannel() {
        Notification.Builder builder = new Notification.Builder(this.getApplicationContext());
        Intent nfIntent = new Intent((Context)this, MainActivity.class);
        builder.setContentIntent(PendingIntent.getActivity((Context)this, (int)0, (Intent)nfIntent, (int)0)).setLargeIcon(BitmapFactory.decodeResource((Resources)this.getResources(), (int)R.mipmap.ic_launcher_foreground)).setSmallIcon(R.mipmap.ic_launcher_foreground).setContentText((CharSequence)"is running......").setWhen(System.currentTimeMillis());
        if (Build.VERSION.SDK_INT >= 26) {
            builder.setChannelId("notification_id");
        }
        if (Build.VERSION.SDK_INT >= 26) {
            NotificationManager notificationManager = (NotificationManager)this.getSystemService("notification");
            NotificationChannel channel = new NotificationChannel("notification_id", (CharSequence)"notification_name", 2);
            notificationManager.createNotificationChannel(channel);
        }
        android.app.Notification notification = builder.build();
        notification.defaults = 1;
        this.startForeground(1100, notification);
    }

    public void onDestroy() {
        super.onDestroy();
        this.stopForeground(true);
        MLog.info((Object)"PETERTEST", (String)"SERVICE ONDESTROY", (Object[])new Object[0]);
    }
}

