/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.perf;

import android.content.Context;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.constant.CommonPerfUtils;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.base.env.RuntimeContext;
import com.yy.base.guid.GuidFactory;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.NetMonitor;
import com.yy.socialplatformbase.AbsPlatformAdapter;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.platform.IPlatformAvailableCallBack;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class PerfManager
implements INotify {
    private static volatile boolean sStatConnecting = false;
    private static volatile String sLastStatConnectUrl = null;

    public void onAppStarted() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                PerfManager.this.statGoogleService();
                PerfManager.this.checkNet();
            }
        });
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
    }

    private void statGoogleService() {
        if (!SettingFlags.getBoolean((String)"collecttemporarydata", (boolean)false)) {
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                AbsPlatformAdapter platformAdapter = ThirdPartyPlatformHelper.getInstance().getPlatform(6);
                if (platformAdapter != null) {
                    platformAdapter.getPlatformVersion(new IPlatformAvailableCallBack(){

                        public void onCallBack(boolean isGooglePlayServicesAvailable, int version, String verName, String packName) {
                            StatisContent statContent = new StatisContent();
                            statContent.put("act", "hagoperf");
                            statContent.put("ifield", isGooglePlayServicesAvailable ? "1" : "0");
                            statContent.put("ifieldtwo", version);
                            statContent.put("sfield", verName != null ? verName : "");
                            statContent.put("sfieldtwo", GuidFactory.getInstance().getGuid());
                            statContent.put("perftype", "googleservice");
                            HiidoStatis.reportContent((StatisContent)statContent);
                        }
                    });
                }
            }
        }, (long)10000L);
    }

    private void checkNet() {
        if (!SettingFlags.getBoolean((String)"collecttemporarydata", (boolean)false)) {
            return;
        }
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        NetworkUtils.setCheckNetWhenNotConnect((boolean)SettingFlags.getBoolean((String)"checkwhenneterror", (boolean)true), (NetworkUtils.ICheckNetWhenNotConnectCallBack)new NetworkUtils.ICheckNetWhenNotConnectCallBack(){

            public void onNetStatusNotify(boolean connected) {
                PerfManager.this.statNetStatusNotify(connected);
            }

            public void onNetErrorCheckCallBack(boolean connected) {
                PerfManager.this.statNetErrorCheckCallBack(connected);
            }
        });
        boolean foreground = RuntimeContext.sIsForeground;
        if (foreground) {
            NetworkUtils.enterToForeground();
        } else {
            NetworkUtils.enterToBackground();
        }
    }

    private void statNetStatusNotify(final boolean connected) {
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("sfield", "netnotify");
                statContent.put("sfieldtwo", AccountUtil.getUid());
                statContent.put("ifield", connected ? "1" : "0");
                statContent.put("perftype", "netcheck");
                HiidoStatis.reportContent((StatisContent)statContent);
            }
        });
    }

    private void statNetErrorCheckCallBack(final boolean connected) {
        if (AccountUtil.getUid() <= 0L || !RuntimeContext.sIsDebuggable) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("sfield", "neterrorcheck");
                statContent.put("sfieldtwo", AccountUtil.getUid());
                statContent.put("ifield", connected ? 1 : 0);
                statContent.put("perftype", "netcheck");
                HiidoStatis.reportContent((StatisContent)statContent);
            }
        });
    }

    public static void statProxyBackSuccess(boolean success, String url, Exception e) {
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        HiidoStatis.reportAppMonitorReturnCode((String)("hyProxyBack/" + url), (long)0L, (String)(success ? "0" : String.valueOf(NetMonitor.getErrorCodeByExc(e))));
    }

    public static void statHttpOriginError(String url, Exception e) {
        if (StringUtils.isEmpty((String)url)) {
            return;
        }
        int type2 = NetMonitor.getErrorCodeByExc(e);
        if (type2 == 250) {
            return;
        }
        HiidoStatis.reportAppMonitorReturnCode((String)("hyHttpOriginError/" + url), (long)0L, (String)String.valueOf(type2));
    }

    public static void statCrashProtect(Throwable e, String eString) {
        CommonPerfUtils.statCrashProtect((Throwable)e, (String)eString);
    }

    public static void reportSingleCrash(final Throwable e, final String biz, final int stack) {
        if (e == null) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                String errorInofo;
                StringBuilder info = new StringBuilder();
                int index = 0;
                for (StackTraceElement e2 : e.getStackTrace()) {
                    info.append(e2.getClassName()).append("#").append(e2.getMethodName()).append("(").append(e2.getLineNumber()).append(")").append("\t");
                    if (index > stack) break;
                }
                if ((errorInofo = info.toString()).length() > 200) {
                    errorInofo = errorInofo.substring(0, 199);
                }
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("ifield", 1);
                statContent.put("sfield", biz);
                statContent.put("sfieldtwo", errorInofo);
                statContent.put("perftype", "singlecatch");
                HiidoStatis.reportContent((StatisContent)statContent);
            }
        };
        YYTaskExecutor.execute((Runnable)command, (long)1000L);
    }

    public static void statWsConnect(final boolean lastConnect, final boolean neverConnect) {
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("ifield", lastConnect ? "1" : "0");
                statContent.put("ifieldtwo", RuntimeContext.isStartAtFirstInstalled() ? 1 : 0);
                statContent.put("ifieldthree", neverConnect ? 1 : 0);
                statContent.put("ifieldfour", 1);
                statContent.put("perftype", "wsclient");
                HiidoStatis.reportContent((StatisContent)statContent);
            }
        };
        YYTaskExecutor.execute((Runnable)command, (long)10000L);
    }

    public static void statHttpRequest(final String url) {
        if (AccountUtil.getUid() <= 0L || StringUtils.isEmpty((String)url)) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                statContent.put("sfield", url);
                int index = url.indexOf("?");
                if (index > 0) {
                    String urlTwo = url.substring(0, index);
                    statContent.put("sfieldtwo", urlTwo);
                }
                statContent.put("perftype", "httprequest");
                HiidoStatis.reportContent((StatisContent)statContent);
            }
        };
        YYTaskExecutor.execute((Runnable)command, (long)(RuntimeContext.sIsAppStarted ? 0L : 8000L));
    }

    public static void statWsConnect(final boolean success, final String wsUrl, final String errorInfo) {
        if (AccountUtil.getUid() <= 0L || !RuntimeContext.sIsForeground) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (sStatConnecting && (wsUrl == null || StringUtils.equal((String)sLastStatConnectUrl, (String)wsUrl)) || !NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    return;
                }
                sStatConnecting = true;
                String registerHostBackUp = UriProvider.getRegisterHostBackUp();
                boolean useRegisterHostBackUp = false;
                if (wsUrl != null && StringUtils.isNotEmpty((String)registerHostBackUp) && wsUrl.contains(registerHostBackUp)) {
                    HiidoStatis.reportAppMonitorReturnCode((String)("hyWsConnectProxy/" + registerHostBackUp), (long)0L, (String)(success ? "0" : "1"));
                    useRegisterHostBackUp = true;
                } else {
                    HiidoStatis.reportAppMonitorReturnCode((String)("hyWsConnect/" + UriProvider.getRegisterHostOrigin()), (long)0L, (String)(success ? "0" : "1"));
                }
                sLastStatConnectUrl = wsUrl;
                if (!success && StringUtils.isNotEmpty((String)errorInfo)) {
                    boolean pingGoogle = NetworkUtils.pingHost((String)"www.google.com");
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("ifield", pingGoogle ? "1" : "0");
                    statContent.put("sfield", errorInfo);
                    statContent.put("sfieldtwo", wsUrl);
                    statContent.put("ifieldtwo", useRegisterHostBackUp ? 1 : 0);
                    statContent.put("ifieldfour", 2);
                    statContent.put("perftype", "wsclient");
                    HiidoStatis.reportContent((StatisContent)statContent);
                }
                YYTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

                    public void run() {
                        sStatConnecting = false;
                    }
                }, (long)10000L);
            }
        };
        YYTaskExecutor.execute((Runnable)command);
    }

    public static void statOOS(final boolean success, String errorInfo, final long useTime) {
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                HiidoStatis.reportAppMonitorReturnCode((String)"OSS/total", (long)useTime, (String)(success ? "0" : "1"));
            }
        };
        YYTaskExecutor.execute((Runnable)command);
    }

    public void notify(Notification notification) {
        if (notification == null) {
            return;
        }
        if (NotificationDef.N_FOREGROUND_CHANGE == notification.id) {
            boolean foreground = (Boolean)notification.extObj;
            if (foreground) {
                NetworkUtils.enterToForeground();
            } else {
                NetworkUtils.enterToBackground();
            }
        }
    }
}

