/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app;

import android.content.Intent;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.base.env.RuntimeContext;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.app.HagoEnvIniter;
import com.yy.hiyo.app.IMain;
import com.yy.hiyo.app.ServiceManager;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.core.register.ControllerRegistry;
import com.yy.hiyo.main.msg.MsgDef;

public class MainController
implements IMain {
    private FragmentActivity mActivity;
    private static ControllerRegistry sControllerRegistry;

    public MainController(FragmentActivity activity) {
        this.mActivity = activity;
    }

    @Override
    public void onCreate(FragmentActivity activity, Intent intent) {
        HagoEnvIniter.onMainActivity(activity, false);
    }

    @Override
    public void onNewIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        HagoEnvIniter.onActivityNewIntent(this.mActivity, intent);
    }

    @Override
    public void onStop() {
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.ROOT_ONSTOP);
    }

    @Override
    public boolean onBackPress() {
        Object onBackPress = MsgDispatcher.getInstance().sendMessageSync(MsgDef.ROOT_ONBACKPRESS);
        return onBackPress instanceof Boolean && (Boolean)onBackPress != false;
    }

    @Override
    public void onDoubleClickBack() {
        if (RuntimeContext.sIsAppStartFinished && ServiceManager.getInstance().getService(IRoomService.class) != null) {
            ServiceManager.getInstance().getService(IRoomService.class).exitRoom();
        }
    }

    @Override
    public void onAppDestroy() {
        MsgDispatcher.getInstance().sendMessageSync(AppbaseMsgDef.ROOT_ON_APP_DESTROY);
    }

    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.ROOT_ONACTIVITYRESULT, (Object)new Object[]{requestCode, resultCode, data});
    }

    public static void registerNonCoreControllers() {
        HagoEnvIniter.registerNonCoreControllers();
    }
}

