/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.SystemClock;
import android.view.KeyEvent;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.permission.AndPermission;
import com.yy.appbase.useractionstat.UserEnterActionStat;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.startup.ActivityStackManager;
import com.yy.base.timing.TimingTracer;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.applicationroute.MainApplication;
import com.yy.hiyo.auto.StartupMonitor;
import com.yy.hiyo.home.base.perforstat.StartupStatHelper;
import com.yy.hiyo.home.base.startup.MainActivityProxy;
import com.yy.hiyo.home.base.startup.SoCheckUtil;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.login.base.language.LanguageLocaleHelper;
import com.yy.hiyo.main.R;

public class MainActivity
extends AppCompatActivity {
    public static final String TAG = "MainActivity";
    private MainActivityProxy mProxy;
    private INotify mStartUpFinishNofity;
    private boolean mIsHasSo = true;
    private static final String INTENT_EXTRA_FORCE_TO_FRONT = "INTENT_EXTRA_FORCE_TO_FRONT";

    private void throwExcWithInfo(String errorInfo) {
        String desc = "liteapp run ";
        desc = desc + (RuntimeContext.sCrashTestLiteAppRun ? "1" : "0");
        desc = desc + " end " + (RuntimeContext.sCrashTestLiteAppRunEnd ? "1" : "0");
        desc = desc + " myapp run " + (RuntimeContext.sCrashTestMyAppRun ? "1" : "0");
        desc = desc + " end " + (RuntimeContext.sCrashTestMyAppRunEnd ? "1" : "0");
        throw new RuntimeException(desc + " " + errorInfo);
    }

    protected void attachBaseContext(Context newBase) {
        RuntimeContext.setHagoPartySdk((boolean)false);
        super.attachBaseContext(LanguageLocaleHelper.wrapContext((Context)newBase));
    }

    protected void onCreate(Bundle savedInstanceState) {
        if (SystemUtils.isShowEnvSetting() && SettingFlags.hasInited() && SettingFlags.getBoolean((String)"key_is_env_setting_theme", (boolean)false)) {
            this.setTheme(R.style.AppEnvTheme);
        } else {
            this.setTheme(R.style.AppTheme);
        }
        if (ActivityStackManager.getInstance().checkMainExist((Activity)this)) {
            super.onCreate(savedInstanceState);
            this.finish();
            this.handleForOriginActivity();
            return;
        }
        RuntimeContext.sIsActivityStarted = true;
        RuntimeContext.sMainActivityStartTime = SystemClock.uptimeMillis();
        RuntimeContext.action = this.getIntent() == null ? null : this.getIntent().getAction();
        MainApplication.onCreate(this.getApplication(), true);
        if (!this.hasSo(savedInstanceState)) {
            return;
        }
        TimingTracer.addSplit((String)"startup", (String)"MainActivity onCreate");
        super.onCreate(savedInstanceState);
        if (!RuntimeContext.sIsInitForeGrounded) {
            RuntimeContext.sIsForeground = true;
            RuntimeContext.sIsInitForeGrounded = true;
        }
        StartupMonitor.checkStartByMonitor(this.getIntent());
        AccountModel.getInstance().onMainActivityStarted();
        StartupStatHelper.getStartPathLogger().add("MainActivity onCreate", new Object[0]);
        ThirdTrackHelper.INSTANCE.startTracking((Context)this);
        try {
            this.mProxy = new MainActivityProxy((FragmentActivity)this);
        }
        catch (ExceptionInInitializerError e) {
            this.throwExcWithInfo(e != null ? e.getMessage() : "");
        }
        catch (NullPointerException e) {
            this.throwExcWithInfo(e != null ? e.getMessage() : "");
        }
        this.mProxy.onCreate(this.getIntent());
        RuntimeContext.resetCrashedInLastRunFlag();
        UserEnterActionStat.onMainActivity();
        MLog.error((Object)TAG, (String)"onCreate()", (Object[])new Object[0]);
    }

    private void handleForOriginActivity() {
        if (ActivityStackManager.getInstance().isAppForeground()) {
            this.mockSingleTaskLaunchMode();
        } else {
            Intent originIntent = this.getIntent();
            if (originIntent == null || !originIntent.hasExtra(INTENT_EXTRA_FORCE_TO_FRONT)) {
                this.startOriginActivityByReorderToFront(originIntent);
            } else {
                MLog.error((Object)TAG, (String)"handleForOriginActivity %s", (Object[])new Object[]{originIntent.getExtras()});
            }
        }
    }

    private void startOriginActivityByReorderToFront(Intent originIntent) {
        MLog.info((Object)TAG, (String)"startOriginActivityByReorderToFront %s", (Object[])new Object[]{originIntent == null ? "" : originIntent.getExtras()});
        Intent intent = new Intent();
        intent.setComponent(new ComponentName((Context)this, MainActivity.class));
        if (originIntent != null) {
            Bundle extras = originIntent.getExtras();
            if (extras == null) {
                extras = new Bundle();
            }
            extras.putBoolean(INTENT_EXTRA_FORCE_TO_FRONT, true);
            intent.putExtras(extras);
        }
        intent.addFlags(262144);
        Activity firstMainActivity = ActivityStackManager.getInstance().getFirstMainActivity();
        if (firstMainActivity instanceof MainActivity) {
            firstMainActivity.startActivity(intent);
            ((MainActivity)firstMainActivity).onNewIntent(originIntent);
        }
    }

    private void mockSingleTaskLaunchMode() {
        ActivityStackManager.getInstance().finishActivitysTopofMain();
        MainActivity originMainActivity = (MainActivity)ActivityStackManager.getInstance().getMainActivity();
        originMainActivity.onNewIntent(this.getIntent());
        originMainActivity.onRestart();
        originMainActivity.onStart();
        originMainActivity.onResume();
    }

    private boolean hasSo(Bundle savedInstanceState) {
        if (Build.VERSION.SDK_INT > 22 && !RuntimeContext.s64SoInsteadOf32So) {
            return true;
        }
        if (RuntimeContext.isNewInstalled() && RuntimeContext.isStartAtFirstInstalled() || RuntimeContext.isStartAtCoverInstalled() || SoCheckUtil.isAabSoError()) {
            MLog.error((Object)TAG, (String)"findNativeLibraryPath", (Object[])new Object[0]);
            this.mIsHasSo = SoCheckUtil.findNativeLibraryPath((Context)this);
            if (!this.mIsHasSo) {
                super.onCreate(savedInstanceState);
                SoCheckUtil.handleSoErrorToHiidoStat((Context)this, "so miss");
                return false;
            }
        }
        return true;
    }

    public void onResume() {
        super.onResume();
        RuntimeContext.sIsMoveTaskToBack = false;
        if (this.mIsHasSo) {
            StartupMonitor.calculateStartUpTime((Context)this);
            if (this.mProxy != null) {
                this.mProxy.onResume();
            }
            MLog.error((Object)TAG, (String)"onResume()", (Object[])new Object[0]);
        }
    }

    protected void onPause() {
        super.onPause();
        if (this.mProxy != null) {
            this.mProxy.onPause();
            MLog.error((Object)TAG, (String)"onPause()", (Object[])new Object[0]);
        }
    }

    protected void onStop() {
        super.onStop();
        if (this.mProxy != null) {
            this.mProxy.onStop();
            MLog.error((Object)TAG, (String)"onStop()", (Object[])new Object[0]);
        }
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        if (this.mProxy != null) {
            int result = this.mProxy.dispatchKeyEvent(event);
            if (result == 1) {
                return true;
            }
            if (result == 2) {
                return false;
            }
        }
        return super.dispatchKeyEvent(event);
    }

    public void onBackPressed() {
        if (this.mProxy != null && !this.mProxy.onBackPressed()) {
            if (SettingFlags.getBoolean((String)"key_proce_hot_switch", (boolean)true)) {
                this.mProxy.setBackToHomeStatus(true);
                try {
                    this.moveTaskToBack(true);
                    RuntimeContext.sIsMoveTaskToBack = true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    super.onBackPressed();
                }
            } else {
                super.onBackPressed();
            }
        }
        MLog.error((Object)TAG, (String)"onBackPressed()", (Object[])new Object[0]);
    }

    public void onStart() {
        super.onStart();
        if (this.mProxy != null) {
            this.mProxy.onStart();
            MLog.error((Object)TAG, (String)"onStart()", (Object[])new Object[0]);
        }
    }

    public void onRestart() {
        super.onRestart();
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mProxy != null) {
            this.mProxy.onDestroy();
            MLog.error((Object)TAG, (String)"onDestroy()", (Object[])new Object[0]);
        }
    }

    public void finish() {
        super.finish();
        MLog.error((Object)TAG, (String)"finish()", (Object[])new Object[0]);
    }

    protected void onActivityResult(final int requestCode, final int resultCode, final Intent data) {
        if (this.mProxy == null) {
            return;
        }
        if (RuntimeContext.sIsServicesInited) {
            this.mProxy.onActivityResult(requestCode, resultCode, data);
            super.onActivityResult(requestCode, resultCode, data);
        } else {
            this.mStartUpFinishNofity = new INotify(){

                public void notify(Notification notification) {
                    if (notification != null && notification.id == NotificationDef.N_STARTUP_FINISHED) {
                        MainActivity.this.mProxy.onActivityResult(requestCode, resultCode, data);
                        MainActivity.super.onActivityResult(requestCode, resultCode, data);
                    }
                    NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_STARTUP_FINISHED, MainActivity.this.mStartUpFinishNofity);
                    MainActivity.this.mStartUpFinishNofity = null;
                }
            };
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_STARTUP_FINISHED, this.mStartUpFinishNofity);
        }
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        AndPermission.onRequestPermissionsResult((int)requestCode, (String[])permissions, (int[])grantResults);
    }

    public void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        if (this.mProxy != null) {
            MLog.info((Object)TAG, (String)"onNewIntent", (Object[])new Object[0]);
            this.mProxy.onNewIntent(intent);
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_ORIENTATION_CHANGE));
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (this.mProxy != null) {
            MLog.info((Object)TAG, (String)"onWindowFocusChanged hasFocus: %b", (Object[])new Object[]{hasFocus});
            this.mProxy.onWindowFocusChanged(hasFocus);
        }
    }

    public void startActivity(Intent intent) {
        if (RuntimeContext.sIsAutoTesting && RuntimeContext.sIsDebuggable) {
            return;
        }
        try {
            super.startActivity(intent);
        }
        catch (Throwable e) {
            MLog.error((Object)TAG, (Throwable)e);
        }
    }

    public void startActivity(Intent intent, Bundle options) {
        if (RuntimeContext.sIsAutoTesting && RuntimeContext.sIsDebuggable) {
            return;
        }
        super.startActivity(intent, options);
    }

    public SharedPreferences getSharedPreferences(String name, int mode) {
        SharedPreferencesUtils.INSTANCE.ensureCopySystemSPFile((Context)(this.getApplicationContext() == null ? this : this.getApplicationContext()));
        return SharedPreferencesUtils.INSTANCE.getSharedPreferences((Context)this, name, mode, true);
    }
}

