/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo;

import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.os.PowerManager;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.WindowManager;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.push.FloatPushItem;
import com.yy.appbase.push.NotificationManager;
import com.yy.appbase.push.NotificationTrack;
import com.yy.appbase.push.PushNotificationData;
import com.yy.appbase.push.ScreenBroadcastReceiver;
import com.yy.appbase.push.ScreenStateListener;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.main.R;
import ikxd.msg.PushSourceType;
import org.json.JSONException;
import org.json.JSONObject;

public class FloatWindowActivity
extends FragmentActivity {
    private static final String TAG = "FloatWindowActivity";
    private ScreenBroadcastReceiver mScreenReceiver;
    private FloatPushItem mFloatPushItem;
    private boolean mIsScreenOn = false;
    private boolean mIsOffline = false;
    private YYRelativeLayout mFlFloatPush;
    private String mPayload;
    private PushNotificationData mPushData;
    private final Runnable mShowFloatPushRunnable = new Runnable(){

        @Override
        public void run() {
            if (FloatWindowActivity.this.mFloatPushItem != null && FloatWindowActivity.this.mIsScreenOn) {
                NotificationManager.Instance.showFloatPushView((Context)FloatWindowActivity.this, new PushNotificationData(FloatWindowActivity.this.mFloatPushItem.getPushId(), "512", FloatWindowActivity.this.mFloatPushItem.getPushSource(), FloatWindowActivity.this.mPayload).with(FloatWindowActivity.this.mFloatPushItem.getContent(), FloatWindowActivity.this.mFloatPushItem.getTitle(), FloatWindowActivity.this.mFloatPushItem.getImageUrl()).with(true, FloatWindowActivity.this.mIsOffline).withUid(FloatWindowActivity.this.mFloatPushItem.getUid()));
            }
        }
    };
    Runnable mDismissRunnable = new Runnable(){

        @Override
        @RequiresApi(api=26)
        public void run() {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)FloatWindowActivity.this.mDismissRunnable);
            FloatWindowActivity.this.finish();
        }
    };

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(1024, 1024);
        this.getWindow().setFlags(32, 32);
        this.getWindow().setFlags(262144, 262144);
        this.setContentView(R.layout.activity_float_window);
        this.mFlFloatPush = (YYRelativeLayout)this.findViewById(R.id.fl_push_float);
        this.mIsScreenOn = this.isScreenOn();
        if (!this.mIsScreenOn) {
            this.mFlFloatPush.setVisibility(8);
        } else {
            this.mFlFloatPush.setVisibility(0);
        }
        this.initView(this.getIntent());
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        params.alpha = 1.0f;
        params.width = -1;
        this.getWindow().setAttributes(params);
        this.getWindow().setGravity(48);
        this.registerScreenBroadcastReceiver((Context)this);
    }

    private boolean isScreenOn() {
        PowerManager pm = (PowerManager)this.getSystemService("power");
        boolean isScreenOn = pm.isScreenOn();
        MLog.info((Object)"NotificationViewManager", (String)("isScreenOn:" + isScreenOn), (Object[])new Object[0]);
        return isScreenOn;
    }

    private void registerScreenBroadcastReceiver(Context context) {
        MLog.info((Object)"NotificationViewManager", (String)"registerScreenBroadcastReceiver", (Object[])new Object[0]);
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.USER_PRESENT");
        context.registerReceiver((BroadcastReceiver)this.getScreenReceiver(), filter);
    }

    private ScreenBroadcastReceiver getScreenReceiver() {
        if (this.mScreenReceiver == null) {
            this.mScreenReceiver = new ScreenBroadcastReceiver(new ScreenStateListener(){

                public void screenOnCallBack(Context context) {
                    FloatWindowActivity.this.mIsScreenOn = true;
                }

                public void screenOffCallBack(Context context) {
                    FloatWindowActivity.this.mIsScreenOn = false;
                }

                public void screenPresentCallBack(Context context) {
                    YYTaskExecutor.removeRunnableFromMainThread((Runnable)FloatWindowActivity.this.mDismissRunnable);
                    FloatWindowActivity.this.finish();
                    YYTaskExecutor.removeRunnableFromMainThread((Runnable)FloatWindowActivity.this.mShowFloatPushRunnable);
                    YYTaskExecutor.postToMainThread((Runnable)FloatWindowActivity.this.mShowFloatPushRunnable, (long)2000L);
                }
            });
        }
        return this.mScreenReceiver;
    }

    private void initPushData(Intent intent) {
        if (intent == null) {
            return;
        }
        this.mIsOffline = intent.getBooleanExtra("offline_msg", false);
        if (intent.hasExtra("push_float_data")) {
            this.mFloatPushItem = (FloatPushItem)this.getIntent().getParcelableExtra("push_float_data");
        }
        if (intent.hasExtra("payload")) {
            String payloadJsonString;
            this.mPayload = payloadJsonString = intent.getStringExtra("payload");
            if (!TextUtils.isEmpty((CharSequence)payloadJsonString)) {
                try {
                    JSONObject payloadJson = JsonParser.obtainJSONObject((String)payloadJsonString);
                    String fromChannel = payloadJson.optString("push_channel", "");
                    String content = null;
                    String title = null;
                    String avatar = null;
                    String pushSourceString = null;
                    if (this.mFloatPushItem != null) {
                        content = this.mFloatPushItem.getContent();
                        title = this.mFloatPushItem.getTitle();
                        avatar = this.mFloatPushItem.getImageUrl();
                        pushSourceString = this.mFloatPushItem.getPushSource();
                        if (StringUtils.isNotEmpty((String)avatar)) {
                            avatar = avatar + YYImageUtils.getThumbnailPostfixPx((int)ResolutionUtils.dip2Px((float)314.0f), (int)ResolutionUtils.dip2Px((float)150.0f), (boolean)true);
                        }
                    }
                    if (StringUtils.isEmpty(pushSourceString)) {
                        pushSourceString = payloadJson.optString("push_source");
                    }
                    PushSourceType pushSource = NotificationManager.Instance.getPushSourceType(pushSourceString);
                    PushNotificationData pushData = new PushNotificationData(0L, fromChannel, pushSource, payloadJson);
                    if (StringUtils.isEmpty((String)content)) {
                        content = payloadJson.optString("push_content", "");
                    }
                    if (StringUtils.isEmpty((String)title)) {
                        title = payloadJson.optString("push_title", "");
                    }
                    if (StringUtils.isEmpty((String)avatar) && StringUtils.isNotEmpty((String)(avatar = payloadJson.optString("avatar", "")))) {
                        avatar = avatar + YYImageUtils.getThumbnailPostfixPx((int)ResolutionUtils.dip2Px((float)50.0f), (int)ResolutionUtils.dip2Px((float)50.0f), (boolean)true);
                    }
                    pushData.with(content, title, avatar);
                    this.mPushData = pushData;
                }
                catch (JSONException e) {
                    MLog.error((Object)TAG, (String)"parse payload json error", (Throwable)e, (Object[])new Object[0]);
                }
            }
        }
    }

    private void jumpIntent() {
        if (this.mPushData != null) {
            Intent resultIntent = new Intent("android.intent.action.VIEW");
            resultIntent.addCategory("android.intent.category.DEFAULT");
            ComponentName cn = new ComponentName(AppKeysDef.getAppPackageName(), AppKeysDef.getLauncherActivity());
            resultIntent.setComponent(cn);
            resultIntent.putExtra("payload", this.mPushData.getPayloadString());
            resultIntent.addFlags(0x10200000);
            this.startActivity(resultIntent);
        }
        this.finish();
    }

    protected void onDestroy() {
        super.onDestroy();
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mDismissRunnable);
        this.unregisterReceiver((BroadcastReceiver)this.getScreenReceiver());
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.initView(intent);
    }

    private void initView(Intent intent) {
        if (intent == null) {
            this.finish();
            return;
        }
        this.initPushData(intent);
        if (this.mPushData == null) {
            this.finish();
            return;
        }
        RecycleImageView imageView = (RecycleImageView)this.findViewById(R.id.iv_push_avatar);
        TextView title = (TextView)this.findViewById(R.id.tv_float_push_tittle);
        TextView content = (TextView)this.findViewById(R.id.tv_float_push_content);
        ImageLoader.loadImage((ImageView)imageView, (String)this.mPushData.getAvatar());
        title.setText((CharSequence)this.mPushData.getTitle());
        content.setText((CharSequence)this.mPushData.getContent());
        this.mFlFloatPush.setOnClickListener(v -> {
            if (this.mPushData == null) {
                return;
            }
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mDismissRunnable);
            this.jumpIntent();
        });
        if (this.mIsScreenOn) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mDismissRunnable);
            YYTaskExecutor.postToMainThread((Runnable)this.mDismissRunnable, (long)5000L);
            NotificationTrack.INSTANCE.reportShowPush((Context)this, this.mPushData);
        }
    }

    @RequiresApi(api=26)
    public boolean onTouchEvent(MotionEvent event) {
        if (4 == event.getAction()) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mDismissRunnable);
            this.finish();
            return true;
        }
        return super.onTouchEvent(event);
    }
}

