/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo;

import android.content.Context;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.remoteconfig.FirebaseRemoteConfig;
import com.yy.appbase.envsetting.EnvSettingType;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.yylite.commonbase.hiido.HiidoStatis;

public class FireBaseDomain {
    private static final String KEY_BOSS_DOMAIN = "key_boss_domain";
    private static final String KEY_LOGIN_DOMAIN = "key_login_domain";
    private static final String KEY_LOGIN_IP = "key_login_ip";
    private static String sBossDomain;
    private static String sLoginDomain;
    private static String sLoginIp;
    private static boolean sHasRequested;

    public static void requestIfNeed() {
        if (sHasRequested) {
            return;
        }
        sHasRequested = true;
        FireBaseDomain.request(false);
    }

    private static void request(boolean retry) {
        try {
            FirebaseApp firebaseApp = FirebaseApp.getInstance();
            if (firebaseApp != null) {
                FireBaseDomain.doRequest(retry);
            } else {
                FireBaseDomain.asyncInitFirebaseApp(retry);
            }
        }
        catch (Exception e) {
            MLog.error((Object)"FireBaseDomain", (String)("firebase app not init: " + e.toString()), (Object[])new Object[0]);
            FireBaseDomain.asyncInitFirebaseApp(retry);
        }
    }

    private static void asyncInitFirebaseApp(final boolean retry) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FirebaseApp firebaseApp = FirebaseApp.initializeApp((Context)RuntimeContext.sApplicationContext);
                    if (firebaseApp != null) {
                        FireBaseDomain.request(retry);
                    }
                }
                catch (Throwable e) {
                    MLog.error((Object)"FireBaseDomain", (String)("asyncInitFirebaseApp failed : " + e.toString()), (Object[])new Object[0]);
                }
            }
        });
    }

    private static void doRequest(final boolean retry) {
        final long startTime = SystemClock.uptimeMillis();
        FirebaseRemoteConfig.getInstance().fetchAndActivate().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Boolean>(){

            public void onComplete(@NonNull Task<Boolean> task) {
                if (task != null && task.isSuccessful()) {
                    String bossDomain = FirebaseRemoteConfig.getInstance().getString("bossdomain");
                    String loginIp = FirebaseRemoteConfig.getInstance().getString("logindomainip");
                    String loginDomain = FirebaseRemoteConfig.getInstance().getString("logindomain");
                    if (StringUtils.isNotEmpty((String)loginIp)) {
                        SettingFlags.setStringValue((String)FireBaseDomain.KEY_LOGIN_IP, (String)loginIp);
                    }
                    if (StringUtils.isNotEmpty((String)bossDomain)) {
                        SettingFlags.setStringValue((String)FireBaseDomain.KEY_BOSS_DOMAIN, (String)bossDomain);
                    }
                    if (StringUtils.isNotEmpty((String)loginDomain)) {
                        SettingFlags.setStringValue((String)FireBaseDomain.KEY_LOGIN_DOMAIN, (String)loginDomain);
                    }
                    FireBaseDomain.updateDomains();
                    MLog.info((Object)"FireBaseDomain", (String)"login:%s, loginip:%s, boss:%s", (Object[])new Object[]{loginDomain != null ? loginDomain : "", loginIp != null ? loginIp : "", bossDomain != null ? bossDomain : ""});
                    if (StringUtils.isNotEmpty((String)loginDomain)) {
                        HiidoStatis.reportReturnCode((String)"FireBaseDomain", (long)(SystemClock.uptimeMillis() - startTime), (String)"0");
                    } else {
                        HiidoStatis.reportReturnCode((String)"FireBaseDomain", (long)(SystemClock.uptimeMillis() - startTime), (String)"1");
                    }
                } else {
                    MLog.info((Object)"FireBaseDomain", (String)"request error!", (Object[])new Object[0]);
                    if (retry) {
                        HiidoStatis.reportReturnCode((String)"FireBaseDomain", (long)(SystemClock.uptimeMillis() - startTime), (String)"2");
                    } else {
                        FireBaseDomain.doRequest(true);
                    }
                }
            }
        });
        FireBaseDomain.updateDomains();
        UriProvider.setDomainInterceptor((UriProvider.IDomainInterceptor)new UriProvider.IDomainInterceptor(){

            public void onEnvUpdate() {
                FireBaseDomain.updateDomains();
            }
        });
    }

    private static void updateDomains() {
        if (EnvSettings.instance().getUriSettingValue() != EnvSettingType.Product) {
            return;
        }
        String loginDomain = SettingFlags.getStringValue((String)KEY_LOGIN_DOMAIN, (String)"");
        String loginIp = SettingFlags.getStringValue((String)KEY_LOGIN_IP, (String)"");
        String bossDomain = SettingFlags.getStringValue((String)KEY_BOSS_DOMAIN, (String)"");
        if (StringUtils.isNotEmpty((String)loginDomain)) {
            sLoginDomain = loginDomain;
            UriProvider.updateLoginDomain((String)loginDomain);
        }
        if (StringUtils.isNotEmpty((String)loginIp)) {
            sLoginIp = loginIp;
            UriProvider.updateLoginIp((String)sLoginDomain, (String)sLoginIp);
        }
        if (StringUtils.isNotEmpty((String)bossDomain)) {
            sBossDomain = bossDomain;
            UriProvider.updateBossDomain((String)sBossDomain);
        }
    }

    static {
        sHasRequested = false;
    }
}

