/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.base;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.data.UserInfoBean;
import com.yy.appbase.web.JsEventControllerCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameMatchNotifyRes;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.module.webbussiness.base.al;
import com.yy.hiyo.module.webbussiness.base.am;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import java.util.HashMap;

class MatchGameJsEvent
implements JsEvent {
    private final JsEventControllerCallback a;

    MatchGameJsEvent(@NonNull JsEventControllerCallback jsEventControllerCallback) {
        this.a = jsEventControllerCallback;
    }

    @NonNull
    public JsMethod method() {
        return JsEventDefine.BASE.startMatchedGame;
    }

    public void jsCall(@NonNull IWebBusinessHandler iWebBusinessHandler, @NonNull String string2, @Nullable IJsEventCallback iJsEventCallback) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            MLog.error((Object)"MatchGameJsEvent", (String)"param is empty", (Object[])new Object[0]);
            if (iJsEventCallback != null) {
                BaseJsParam baseJsParam = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
                iJsEventCallback.callJs((IJsParam)baseJsParam);
            }
            return;
        }
        YYTaskExecutor.execute((Runnable)new al(this, string2, iJsEventCallback));
    }

    private void a(@NonNull String string2, @Nullable IJsEventCallback iJsEventCallback) {
        MatchGameParam matchGameParam = (MatchGameParam)((Object)JsonParser.parseJsonObject((String)string2, MatchGameParam.class));
        if (matchGameParam != null) {
            GameInfo gameInfo = ((IGameInfoService)this.a.getService().getService(IGameInfoService.class)).getGameInfoByGid(matchGameParam.getGameId());
            if (gameInfo == null) {
                this.a(iJsEventCallback, matchGameParam.getGameId(), matchGameParam.activityId, 3);
                return;
            }
            if (!((IGameService)this.a.getService().getService(IGameService.class)).isGameValid(gameInfo)) {
                this.a(iJsEventCallback, matchGameParam.getGameId(), matchGameParam.activityId, 2);
                return;
            }
            this.a(iJsEventCallback, matchGameParam.getGameId(), matchGameParam.activityId, 1);
            UserInfoBean userInfoBean = new UserInfoBean();
            userInfoBean.setNick(matchGameParam.getNick());
            userInfoBean.setSex((int)matchGameParam.getSex());
            userInfoBean.setUid(matchGameParam.getUid());
            userInfoBean.setAvatar(matchGameParam.getAvatarUrl());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("key_activity", matchGameParam.activityId);
            hashMap.put("key_show_result_mode", matchGameParam.showResultMode);
            hashMap.put("extend_from_h5", matchGameParam.extra);
            YYTaskExecutor.postToMainThread((Runnable)new am(this, matchGameParam, gameInfo, hashMap, userInfoBean));
        } else if (iJsEventCallback != null) {
            BaseJsParam baseJsParam = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
            iJsEventCallback.callJs((IJsParam)baseJsParam);
        }
    }

    private void a(@Nullable IJsEventCallback iJsEventCallback, String string2, String string3, int n2) {
        if (iJsEventCallback != null) {
            BaseJsParam.DataBuilder dataBuilder = BaseJsParam.builder().put("gameId", (Object)string2).put("result", (Object)n2);
            if (!TextUtils.isEmpty((CharSequence)string3)) {
                dataBuilder.put("activityId", (Object)string3);
            }
            BaseJsParam baseJsParam = dataBuilder.build();
            iJsEventCallback.callJs((IJsParam)baseJsParam);
        }
    }

    static /* synthetic */ void a(MatchGameJsEvent matchGameJsEvent, String string2, IJsEventCallback iJsEventCallback) {
        matchGameJsEvent.a(string2, iJsEventCallback);
    }

    static /* synthetic */ JsEventControllerCallback a(MatchGameJsEvent matchGameJsEvent) {
        return matchGameJsEvent.a;
    }

    @DontProguardClass
    static class MatchGameParam
    extends GameMatchNotifyRes {
        String showResultMode;
        String activityId;
        String extra;

        private MatchGameParam(GameMatchNotifyRes.Builder builder) {
            super(builder);
        }
    }
}

