/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.splash;

import android.text.TextUtils;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.push.tips.PushPermissionTipManager;
import com.yy.appbase.resource.file.ResPersistUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.tmp.PageResponse;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.app.ServiceManager;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.module.splash.SplashShowData;
import com.yy.hiyo.module.splash.h;
import com.yy.hiyo.module.splash.i;
import com.yy.hiyo.module.splash.j;
import com.yy.hiyo.module.splash.k;
import com.yy.hiyo.module.splash.l;
import com.yy.hiyo.module.splash.m;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public enum SplashManager {
    INSTANCE;

    private static final String TAG = "SplashManager";
    private static final String CONFIG_PATH = "/splash/sconfig.txt";
    private static final String SHOW_CONFIG_PATH = "/splash/showConfig.txt";
    private static final String GAME_IDS_PATH = "/splash/splash_cache_game_ids.txt";
    private boolean splashViewShowIng = false;
    private final Object fileLock = new Object();
    private h mLocalSplashDataRes;
    private volatile List<com.yy.hiyo.module.splash.a> mSplashs = null;
    public com.yy.hiyo.module.splash.a mLastConfigureSplashData;
    private boolean mNeedSplash = false;
    private SplashShowData mSplashShowData;
    private List<String> cacheGameIds = new ArrayList<String>();
    private boolean hasReadGidConfig = false;
    private IFrequencyLimitExecutor mLimitExecutor;
    private volatile boolean hasLoadSplash = false;

    public void loadSplash() {
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        if (PageResponse.isBusinessOpRiskEnable() && this.hasLoadSplash) {
            return;
        }
        this.hasLoadSplash = true;
        String string2 = UriProvider.getIkxdSvrHost() + "/boss/app_get_splash";
        String string3 = this.getSaveCampaign();
        if (StringUtils.isNotEmpty((String)string3)) {
            string2 = string2 + "?campaign=" + string3;
        }
        if (!MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("url: " + string2), (Object[])new Object[0]);
        }
        if (!string2.startsWith("http")) {
            return;
        }
        HttpUtil.httpReq((String)string2, null, (int)1, (INetRespCallback)new i(this));
    }

    private void handleSplash(h h2) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"handleSplash ", (Object[])new Object[0]);
        }
        if (h2 == null || FP.empty(h2.a)) {
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"handleSplash splash is empty", (Object[])new Object[0]);
            }
            return;
        }
        for (com.yy.hiyo.module.splash.a a2 : h2.a) {
            if (this.isPreload(h2.b, a2.h) || !a2.c()) continue;
            a2.e();
        }
    }

    private void preloadResource(List<h.a> list) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"preloadResource size: %d", (Object[])new Object[]{FP.size(list)});
        }
        if (FP.empty(list)) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>(list.size());
        for (h.a a2 : list) {
            if (TextUtils.isEmpty((CharSequence)a2.a)) continue;
            hashSet.add(a2.a);
        }
        ResPersistUtils.preLoad((ResPersistUtils.Dir)ResPersistUtils.Dir.SPLASH, hashSet);
    }

    private void preloadGame(h h2) {
        if (h2 == null) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        if (!FP.empty(h2.a)) {
            for (com.yy.hiyo.module.splash.a object : h2.a) {
                hashSet.add(object.j);
            }
        }
        if (!FP.empty(h2.b)) {
            for (h.a a2 : h2.b) {
                hashSet.add(a2.b);
            }
        }
        for (String string2 : hashSet) {
            GameInfo gameInfo;
            if (MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)TAG, (String)"preloadGame gameId: %s", (Object[])new Object[]{string2});
            }
            if ((gameInfo = ServiceManager.a().getService(IGameInfoService.class).getGameInfoByGid(string2)) != null) {
                ServiceManager.a().getService(IGameService.class).downloadGame(gameInfo, GameDownloadInfo.DownloadType.silent, 50);
                continue;
            }
            if (!MLog.isLogLevelBlowInfo()) continue;
            MLog.info((Object)TAG, (String)"preloadGame gid: %s, game info is null", (Object[])new Object[]{string2});
        }
    }

    private boolean isPreload(List<h.a> list, String string2) {
        if (!FP.empty(list)) {
            for (h.a a2 : list) {
                if (!StringUtils.equal((String)string2, (String)a2.a)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean needShowSplash() {
        return this.checkSplashDataValid();
    }

    private boolean checkSplashDataValid() {
        com.yy.hiyo.module.splash.a a2 = this.getWillLoadSplashData();
        return a2 != null && a2.c() && a2.d();
    }

    public com.yy.hiyo.module.splash.a getWillLoadSplashData() {
        return SplashManager.INSTANCE.mLastConfigureSplashData != null ? SplashManager.INSTANCE.mLastConfigureSplashData : INSTANCE.getFirstValidSplash();
    }

    public com.yy.hiyo.module.splash.a getFirstValidSplash() {
        List<com.yy.hiyo.module.splash.a> list = this.getSavedSplashData();
        com.yy.hiyo.module.splash.a a2 = this.getLoadStategy().a(list, false);
        if (a2 != null) {
            this.mNeedSplash = true;
        }
        return a2;
    }

    public boolean isSplashViewShowIng() {
        return this.splashViewShowIng;
    }

    public void setSplashViewShowIng(boolean bl2) {
        this.splashViewShowIng = bl2;
        PushPermissionTipManager.setIsSplashViewShowIng((boolean)bl2);
    }

    public void loadSplashConfigAsyn() {
        YYTaskExecutor.execute((Runnable)new j(this));
    }

    public void preloadSplashIcon() {
        k k2 = new k(this);
        YYTaskExecutor.execute((Runnable)k2);
    }

    public synchronized List<com.yy.hiyo.module.splash.a> getSavedSplashData() {
        if (this.mSplashs != null) {
            return this.mSplashs;
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getSavedSplashData", (Object[])new Object[0]);
        }
        this.cacheGameIds = this.getCacheGameIds();
        h h2 = this.readConfig();
        if (h2 != null && !FP.empty(h2.a)) {
            this.mSplashs = h2.a;
            if (YYTaskExecutor.isMainThread()) {
                YYTaskExecutor.execute(this::preloadPath);
            } else {
                this.preloadPath();
            }
        }
        return this.mSplashs;
    }

    private synchronized void preloadPath() {
        if (FP.empty(this.mSplashs)) {
            return;
        }
        for (com.yy.hiyo.module.splash.a a2 : this.mSplashs) {
            if (a2 == null || TextUtils.isEmpty((CharSequence)a2.h)) continue;
            ResPersistUtils.fetchFilePath((ResPersistUtils.Dir)ResPersistUtils.Dir.SPLASH, (String)a2.h);
        }
    }

    public synchronized void releaseData() {
        if (this.mSplashs != null) {
            this.mSplashs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private h readConfig() {
        if (this.mLocalSplashDataRes != null) {
            return this.mLocalSplashDataRes;
        }
        try {
            Object object = this.fileLock;
            synchronized (object) {
                String string2 = this.getSaveConfigPath();
                if (YYFileUtils.isPathExist((String)string2)) {
                    this.mLocalSplashDataRes = (h)JsonParser.parseJsonFile((String)string2, h.class);
                    return this.mLocalSplashDataRes;
                }
                MLog.error((Object)TAG, (String)"readConfig path is not exist: %s", (Object[])new Object[]{string2});
            }
        }
        catch (Exception exception) {
            MLog.error((Object)TAG, (Throwable)exception);
        }
        return null;
    }

    void writeConfig(h h2) {
        if (h2 == null) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new l(this, h2));
    }

    private String getSaveConfigPath() {
        return YYFileUtils.getConfigDir().getAbsolutePath() + CONFIG_PATH;
    }

    private String getGameIdsPath() {
        return YYFileUtils.getConfigDir().getAbsolutePath() + GAME_IDS_PATH;
    }

    public void setGameIds(List<GameInfo> list) {
        this.cacheGameIds.clear();
        StringBuilder stringBuilder = new StringBuilder();
        if (list != null && !list.isEmpty()) {
            for (GameInfo gameInfo : list) {
                stringBuilder.append(gameInfo.gid).append(",");
                this.cacheGameIds.add(gameInfo.gid);
            }
        }
        MLog.debug((Object)TAG, (String)"setGameIds :%s", (Object[])new Object[]{stringBuilder.toString()});
        if (this.mLimitExecutor == null) {
            this.mLimitExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)8000L, (boolean)false);
        }
        this.mLimitExecutor.execute((Runnable)new m(this, stringBuilder));
    }

    private List<String> getCacheGameIds() {
        if (this.hasReadGidConfig) {
            return this.cacheGameIds;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        byte[] byArray = YYFileUtils.readBytes((String)this.getGameIdsPath());
        String string2 = null;
        if (byArray != null && byArray.length > 0 && !StringUtils.isEmpty((String)(string2 = new String(byArray)))) {
            String[] stringArray = string2.split(",");
            arrayList.addAll(Arrays.asList(stringArray));
        }
        this.hasReadGidConfig = true;
        if (RuntimeContext.isInGray() && MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"getCacheGameIds :%s", (Object[])new Object[]{string2});
        }
        return arrayList;
    }

    private b getLoadStategy() {
        return new a(null);
    }

    public void clickSplash(String string2) {
        SplashShowData.a a2 = this.getTargetShowData(string2);
        if (a2 != null) {
            a2.c = true;
            if (this.mSplashShowData != null) {
                this.mSplashShowData.lastUpdateTime = System.currentTimeMillis();
                YYTaskExecutor.execute(() -> JsonParser.writeJsonFile((String)this.getShowDataSaveConfigPath(), (Object)this.mSplashShowData, SplashShowData.class));
            }
        }
    }

    public void splashShow(String string2) {
        SplashShowData.a a2 = this.getTargetShowData(string2);
        if (a2 != null) {
            ++a2.b;
        }
        if (this.mSplashShowData != null) {
            this.mSplashShowData.lastUpdateTime = System.currentTimeMillis();
            YYTaskExecutor.execute(() -> JsonParser.writeJsonFile((String)this.getShowDataSaveConfigPath(), (Object)this.mSplashShowData, SplashShowData.class));
        }
    }

    private SplashShowData.a getTargetShowData(String string2) {
        SplashShowData.a a2 = null;
        if (StringUtils.isNotEmpty((String)string2) && this.mSplashShowData != null) {
            boolean bl2 = false;
            List<SplashShowData.a> list = this.mSplashShowData.mSplashShows;
            if (list == null) {
                this.mSplashShowData.mSplashShows = list = new CopyOnWriteArrayList<SplashShowData.a>();
            }
            if (!list.isEmpty()) {
                for (SplashShowData.a a3 : list) {
                    if (!string2.equals(a3.a)) continue;
                    bl2 = true;
                    a2 = a3;
                    break;
                }
            }
            if (!bl2) {
                a2 = new SplashShowData.a();
                a2.a = string2;
                list.add(a2);
            }
        }
        return a2;
    }

    private void loadShowData() {
        if (this.mSplashShowData == null) {
            String string2 = this.getShowDataSaveConfigPath();
            if (YYFileUtils.isPathExist((String)string2)) {
                this.mSplashShowData = (SplashShowData)JsonParser.parseJsonFile((String)string2, SplashShowData.class);
            }
            if (this.mSplashShowData == null || !TimeUtils.isSameDay((long)this.mSplashShowData.lastUpdateTime, (long)System.currentTimeMillis())) {
                this.mSplashShowData = new SplashShowData();
            }
        }
    }

    private String getShowDataSaveConfigPath() {
        return YYFileUtils.getConfigDir().getAbsolutePath() + SHOW_CONFIG_PATH;
    }

    private String getSaveCampaign() {
        String string2 = SettingFlags.getStringValue((String)"key_dl_campaign_for_splash", null);
        String string3 = null;
        if (StringUtils.isNotEmpty((String)string2)) {
            try {
                long l2;
                String[] stringArray = string2.split("`");
                if (stringArray.length == 2 && (l2 = Long.parseLong(stringArray[1])) > 0L && l2 < System.currentTimeMillis() && l2 + 172800000L > System.currentTimeMillis()) {
                    string3 = stringArray[0];
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return string3;
    }

    static /* synthetic */ void access$000(SplashManager splashManager, h h2) {
        splashManager.handleSplash(h2);
    }

    static /* synthetic */ void access$100(SplashManager splashManager, List list) {
        splashManager.preloadResource(list);
    }

    static /* synthetic */ void access$200(SplashManager splashManager, h h2) {
        splashManager.preloadGame(h2);
    }

    static /* synthetic */ b access$300(SplashManager splashManager) {
        return splashManager.getLoadStategy();
    }

    static /* synthetic */ void access$400(SplashManager splashManager) {
        splashManager.loadShowData();
    }

    static /* synthetic */ Object access$500(SplashManager splashManager) {
        return splashManager.fileLock;
    }

    static /* synthetic */ String access$600(SplashManager splashManager) {
        return splashManager.getSaveConfigPath();
    }

    static /* synthetic */ String access$700(SplashManager splashManager) {
        return splashManager.getGameIdsPath();
    }

    private class a
    implements b {
        private a() {
        }

        @Override
        public com.yy.hiyo.module.splash.a a(List<com.yy.hiyo.module.splash.a> list, boolean bl2) {
            if (FP.empty(list)) {
                MLog.error((Object)SplashManager.TAG, (String)"loadSplash configureSplashData empty!!!", (Object[])new Object[0]);
                return null;
            }
            com.yy.hiyo.module.splash.a a2 = null;
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                com.yy.hiyo.module.splash.a a3 = list.get(i2);
                if (a3 == null || !a3.c()) {
                    MLog.error((Object)SplashManager.TAG, (String)"loadSplash configureSplashData check Splash id not Valid:%s !!!", (Object[])new Object[]{a3 != null ? a3.b : ""});
                    continue;
                }
                if (a3.d()) {
                    if (a2 != null) continue;
                    String string2 = a3.b;
                    if (StringUtils.isEmpty((String)string2)) {
                        MLog.error((Object)SplashManager.TAG, (String)"splashId empty!!!, res:%s", (Object[])new Object[]{a3.h});
                        continue;
                    }
                    boolean bl3 = this.a(string2);
                    if (!bl3) continue;
                    String string3 = a3.j;
                    if (StringUtils.isNotEmpty((String)string3)) {
                        IGameInfoService iGameInfoService = null;
                        if (RuntimeContext.sIsAppStartFinished) {
                            iGameInfoService = ServiceManager.a().getService(IGameInfoService.class);
                        }
                        if (iGameInfoService != null) {
                            GameInfo gameInfo = iGameInfoService.getGameInfoByGid(string3);
                            if (gameInfo == null) {
                                MLog.error((Object)SplashManager.TAG, (String)"gInfo null!!! splashId:%s, gameId:%s ", (Object[])new Object[]{string2, string3});
                                continue;
                            }
                        } else {
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)SplashManager.TAG, (String)"gameInfoService null, skip check game info!!!!", (Object[])new Object[0]);
                            }
                            if (!SplashManager.this.cacheGameIds.contains(string3)) {
                                if (!MLog.isLogLevelBlowInfo()) continue;
                                MLog.info((Object)SplashManager.TAG, (String)"cache gid not contain gid:%s !!!!", (Object[])new Object[]{string3});
                                continue;
                            }
                            if (MLog.isLogLevelBlowInfo()) {
                                MLog.info((Object)SplashManager.TAG, (String)"cache gid contain gid:%s", (Object[])new Object[]{string3});
                            }
                        }
                    }
                    a2 = a3;
                    if (bl2) continue;
                    break;
                }
                if (!bl2) continue;
                a3.e();
            }
            if (a2 == null && MLog.isLogLevelBlowInfo()) {
                MLog.info((Object)SplashManager.TAG, (String)"mLastConfigureSplashData null!!!", (Object[])new Object[0]);
            }
            return a2;
        }

        private boolean a(String string2) {
            boolean bl2 = SettingFlags.getBoolean((String)"ENV_AD_DIALOG", (boolean)false);
            if (SystemUtils.isShowEnvSetting() && bl2) {
                return true;
            }
            if (SplashManager.this.mSplashShowData != null && ((SplashManager)SplashManager.this).mSplashShowData.mSplashShows != null) {
                for (SplashShowData.a a2 : ((SplashManager)SplashManager.this).mSplashShowData.mSplashShows) {
                    if (!string2.equals(a2.a) || a2.a()) continue;
                    if (MLog.isLogLevelBlowInfo()) {
                        MLog.info((Object)SplashManager.TAG, (String)"is not valid!!! splashShow:%s", (Object[])new Object[]{a2});
                    }
                    return false;
                }
            }
            return true;
        }

        /* synthetic */ a(i i2) {
            this();
        }
    }

    private static interface b {
        public com.yy.hiyo.module.splash.a a(List<com.yy.hiyo.module.splash.a> var1, boolean var2);
    }
}

