/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.radio.lunmic.service;

import com.yy.hiyo.channel.plugins.radio.lunmic.data.TimeSection;
import com.yy.hiyo.channel.plugins.radio.lunmic.service.AnchorScheduleUtils;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0012J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u0012J\u0016\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aJ\u0016\u0010!\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001aJ\u000e\u0010\"\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010#\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\n\u001a\u0004\b\f\u0010\bR\u001b\u0010\u000e\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\n\u001a\u0004\b\u000f\u0010\b\u00a8\u0006$"}, d2={"Lcom/yy/hiyo/channel/plugins/radio/lunmic/service/AnchorScheduleUtils;", "", "()V", "MIN_30", "", "dateFormat", "Ljava/text/SimpleDateFormat;", "getDateFormat", "()Ljava/text/SimpleDateFormat;", "dateFormat$delegate", "Lkotlin/Lazy;", "hourTimeFormat", "getHourTimeFormat", "hourTimeFormat$delegate", "yearFormat", "getYearFormat", "yearFormat$delegate", "beginTodayTS", "", "ts", "endTodayTS", "getDayFormat", "", "getHourTime", "getHourTimeEnd", "getTodayTimeSection", "Lcom/yy/hiyo/channel/plugins/radio/lunmic/data/TimeSection;", "todayTS", "index", "isContainSection", "", "left", "right", "isInSection", "nextBeginDayTS", "nextBeginDayTSMill", "lunmic_debug"})
public final class AnchorScheduleUtils {
    public static final int MIN_30 = 1800;
    private static final Lazy hourTimeFormat$delegate;
    private static final Lazy dateFormat$delegate;
    private static final Lazy yearFormat$delegate;
    public static final AnchorScheduleUtils INSTANCE;

    private final SimpleDateFormat getHourTimeFormat() {
        Lazy lazy = hourTimeFormat$delegate;
        AnchorScheduleUtils anchorScheduleUtils = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SimpleDateFormat)lazy.getValue();
    }

    private final SimpleDateFormat getDateFormat() {
        Lazy lazy = dateFormat$delegate;
        AnchorScheduleUtils anchorScheduleUtils = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SimpleDateFormat)lazy.getValue();
    }

    private final SimpleDateFormat getYearFormat() {
        Lazy lazy = yearFormat$delegate;
        AnchorScheduleUtils anchorScheduleUtils = this;
        Object var3_3 = null;
        boolean bl = false;
        return (SimpleDateFormat)lazy.getValue();
    }

    public final long endTodayTS(long ts) {
        return this.nextBeginDayTSMill(ts) / (long)1000;
    }

    public final long beginTodayTS(long ts) {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"calendar");
        calendar2.setTimeInMillis(ts);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis() / (long)1000;
    }

    public final long nextBeginDayTS(long ts) {
        return this.nextBeginDayTSMill(ts) / (long)1000;
    }

    public final long nextBeginDayTSMill(long ts) {
        Calendar calendar;
        Calendar calendar2 = calendar = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)calendar2, (String)"calendar");
        calendar2.setTimeInMillis(ts);
        calendar.add(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTimeInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getHourTime(long ts) {
        SimpleDateFormat simpleDateFormat = this.getHourTimeFormat();
        boolean bl = false;
        boolean bl2 = false;
        synchronized (simpleDateFormat) {
            boolean bl3 = false;
            String string2 = INSTANCE.getHourTimeFormat().format(ts * (long)1000);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"hourTimeFormat.format(ts * 1000)");
            String string3 = string2;
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getHourTimeEnd(long ts) {
        SimpleDateFormat simpleDateFormat = this.getHourTimeFormat();
        boolean bl = false;
        boolean bl2 = false;
        synchronized (simpleDateFormat) {
            boolean bl3 = false;
            String time = INSTANCE.getHourTimeFormat().format(ts * (long)1000);
            if (Intrinsics.areEqual((Object)time, (Object)"00:00")) {
                time = "24:00";
            }
            String string2 = time;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"time");
            String string3 = string2;
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getDayFormat(long ts) {
        SimpleDateFormat simpleDateFormat = this.getDateFormat();
        boolean bl = false;
        boolean bl2 = false;
        synchronized (simpleDateFormat) {
            boolean bl3 = false;
            String string2 = INSTANCE.getDateFormat().format(ts * (long)1000);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"dateFormat.format(ts * 1000)");
            String string3 = string2;
            return string3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String getYearFormat(long ts) {
        SimpleDateFormat simpleDateFormat = this.getYearFormat();
        boolean bl = false;
        boolean bl2 = false;
        synchronized (simpleDateFormat) {
            boolean bl3 = false;
            String string2 = INSTANCE.getYearFormat().format(ts * (long)1000);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"yearFormat.format(ts * 1000)");
            String string3 = string2;
            return string3;
        }
    }

    @NotNull
    public final TimeSection getTodayTimeSection(long todayTS, int index) {
        long begin = todayTS + (long)(index * 1800);
        return new TimeSection(begin, begin + (long)1800);
    }

    public final boolean isInSection(@NotNull TimeSection left, @NotNull TimeSection right) {
        Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        return left.getBeginTS() >= right.getBeginTS() && left.getBeginTS() < right.getEndTS() || left.getEndTS() > right.getBeginTS() && left.getEndTS() <= right.getEndTS();
    }

    public final boolean isContainSection(@NotNull TimeSection left, @NotNull TimeSection right) {
        Intrinsics.checkParameterIsNotNull((Object)left, (String)"left");
        Intrinsics.checkParameterIsNotNull((Object)right, (String)"right");
        return left.getBeginTS() > right.getBeginTS() && left.getBeginTS() < right.getEndTS() && left.getEndTS() > right.getBeginTS() && left.getEndTS() < right.getEndTS();
    }

    private AnchorScheduleUtils() {
    }

    static {
        AnchorScheduleUtils anchorScheduleUtils;
        INSTANCE = anchorScheduleUtils = new AnchorScheduleUtils();
        hourTimeFormat$delegate = LazyKt.lazy((Function0)hourTimeFormat.2.INSTANCE);
        dateFormat$delegate = LazyKt.lazy((Function0)dateFormat.2.INSTANCE);
        yearFormat$delegate = LazyKt.lazy((Function0)yearFormat.2.INSTANCE);
    }
}

