/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.widget.TextView;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;

public class AZSidebar
extends YYView {
    public static final String[] DEFAULT_LETTERS = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "#"};
    public static final String[] LETTERS_ADD_HEADER = new String[]{"*", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "#"};
    public static final int DEFAULT_SELECTED = -1;
    private float mTextWidth;
    private float mTextHeight;
    private OnTouchingLetterChangedListener mListener;
    private String[] mLetters = DEFAULT_LETTERS;
    private int mSelectedIndex = -1;
    private Paint mPaint = new Paint();
    private TextView mTipView;
    private int mLetterHeight;
    private int mLetterTextSize;
    private Bitmap headerBitmap;
    private Bitmap headerSeletcedBitmap;
    private int selectedIndex = -1;

    public AZSidebar(Context context) {
        super(context);
        this.init(context);
    }

    public AZSidebar(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AZSidebar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mLetterTextSize = ResolutionUtils.dip2Px((float)10.0f);
        this.mLetterHeight = ResolutionUtils.dip2Px((float)14.0f);
    }

    public void setOnTouchingLetterChangedListener(OnTouchingLetterChangedListener onTouchingLetterChangedListener) {
        this.mListener = onTouchingLetterChangedListener;
    }

    public void setTipView(TextView mTipView) {
        this.mTipView = mTipView;
    }

    public void setLetters(String[] mLetters) {
        this.mLetters = mLetters;
    }

    public void setLettersHeader(int drawable2, int selectDrawable) {
        this.headerBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)drawable2);
        this.headerSeletcedBitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)selectDrawable);
        this.setLetters(LETTERS_ADD_HEADER);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mLetters == null || this.mLetters.length == 0) {
            return;
        }
        int width = this.getWidth();
        for (int i = 0; i < this.mLetters.length; ++i) {
            float yPos;
            float xPos;
            this.mPaint.setAntiAlias(true);
            this.mPaint.setTextSize((float)this.mLetterTextSize);
            this.calTextWH(this.mLetters[i]);
            if (i == this.selectedIndex) {
                this.mPaint.setColor(Color.parseColor((String)"#ffb504"));
                float yPos2 = this.mLetterHeight * (i + 1);
                float txtPadding = ((float)this.mLetterHeight - this.mTextHeight) / 2.0f;
                canvas.drawRect((float)this.dp2px(2.0f), yPos2 + (float)this.dp2px(txtPadding) - (float)this.mLetterHeight, (float)(width - this.dp2px(2.0f)), yPos2 + (float)this.dp2px(txtPadding), this.mPaint);
                this.mPaint.setColor(Color.parseColor((String)"#ffffff"));
            } else {
                this.mPaint.setColor(Color.parseColor((String)"#9b9b9b"));
            }
            if (null != this.headerBitmap && null != this.headerSeletcedBitmap && 0 == i && this.mLetters.length > 0) {
                xPos = (float)(width / 2) - this.mPaint.measureText(this.mLetters[i + 1]) / 2.0f;
                yPos = this.mLetterHeight * (i + 1) - this.headerBitmap.getHeight();
                canvas.drawBitmap(i == this.selectedIndex ? this.headerSeletcedBitmap : this.headerBitmap, xPos, yPos, this.mPaint);
            } else {
                xPos = (float)(width / 2) - this.mTextWidth / 2.0f;
                yPos = this.mLetterHeight * (i + 1);
                canvas.drawText(this.mLetters[i], xPos, yPos, this.mPaint);
            }
            this.mPaint.reset();
        }
    }

    private int dp2px(float dp) {
        return ResolutionUtils.dip2Px((float)dp);
    }

    public boolean dispatchTouchEvent(MotionEvent event) {
        float eventY = event.getY();
        int oldSelectedIndex = this.mSelectedIndex;
        int newSelectedIndex = (int)(eventY / (float)this.mLetterHeight);
        switch (event.getAction()) {
            case 1: {
                this.selectedIndex = -1;
                this.invalidate();
                if (this.mTipView != null) {
                    this.mTipView.setVisibility(4);
                }
                if (this.mListener == null) break;
                this.mListener.onTouchUp();
                break;
            }
            default: {
                if (oldSelectedIndex == newSelectedIndex || newSelectedIndex < 0 || newSelectedIndex >= this.mLetters.length) break;
                this.selectedIndex = newSelectedIndex;
                if (this.mListener != null) {
                    this.mListener.onTouchingLetterChanged(this.mLetters[newSelectedIndex]);
                }
                if (this.mTipView != null) {
                    this.mTipView.setText((CharSequence)this.mLetters[newSelectedIndex]);
                    this.mTipView.setVisibility(0);
                }
                this.mSelectedIndex = newSelectedIndex;
                this.invalidate();
            }
        }
        return true;
    }

    private void calTextWH(String txt) {
        Paint.FontMetrics fm = this.mPaint.getFontMetrics();
        this.mTextWidth = this.mPaint.measureText(txt);
        this.mTextHeight = fm.descent - fm.ascent;
    }

    public static interface OnTouchingLetterChangedListener {
        public void onTouchingLetterChanged(String var1);

        public void onTouchUp();
    }
}

