/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathDashPathEffect;
import android.graphics.PathEffect;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;

public class KTVMusicBar
extends YYView {
    private Paint mPaint = new Paint(1);
    private byte[] mBytes;

    public KTVMusicBar(Context context) {
        this(context, null, 0);
    }

    public KTVMusicBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public KTVMusicBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setLayerType(1, null);
        Path path = new Path();
        path.addCircle(0.0f, 0.0f, this.dp2Px(1.65f), Path.Direction.CW);
        PathDashPathEffect pathDashPathEffect = new PathDashPathEffect(path, this.dp2Px(9.9f), this.dp2Px(6.6f), PathDashPathEffect.Style.ROTATE);
        this.mPaint.setPathEffect((PathEffect)pathDashPathEffect);
        this.mPaint.setColor(Color.parseColor((String)"#5500ffde"));
    }

    private float dp2Px(float value) {
        return ResolutionUtils.dip2Px((float)value);
    }

    protected void onDraw(Canvas canvas) {
        int density = 31;
        float barWidth = (float)this.getWidth() * 1.0f / (float)density;
        if (this.mBytes != null) {
            int div = (this.mBytes.length - 50) / density;
            int height = this.getHeight();
            for (int i = 0; i < density; ++i) {
                int bytePosition = Math.min((int)Math.ceil(i * div), this.mBytes.length);
                int top = (int)((float)height - (float)(Math.abs(this.mBytes[bytePosition + i]) * height / 128) * 1.5f);
                float barX = (float)i * barWidth + barWidth / 2.0f;
                canvas.drawLine(barX, (float)this.getHeight(), barX, (float)top, this.mPaint);
            }
        } else {
            for (int i = 0; i < density; ++i) {
                float barX = (float)i * barWidth + barWidth / 2.0f;
                canvas.drawLine(barX, (float)this.getHeight(), barX, (float)this.getHeight(), this.mPaint);
            }
        }
        super.onDraw(canvas);
    }

    public void setColor(int color2) {
        this.mPaint.setColor(color2);
    }

    public void setBarData(byte[] data) {
        this.mBytes = data;
        this.invalidate();
    }

    public void clearBarData() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                KTVMusicBar.access$002(KTVMusicBar.this, null);
                KTVMusicBar.this.invalidate();
            }
        }, (long)100L);
    }

    static /* synthetic */ byte[] access$002(KTVMusicBar x0, byte[] x1) {
        x0.mBytes = x1;
        return x1;
    }
}

