/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.upload.scan;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.hiyo.channel.plugins.ktv.R;
import java.util.ArrayList;
import java.util.List;

public class KTVLocalMusicItemAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    private Context mContext;
    private List<MusicPlaylistDBBean> mData;
    private OnItemClickListener mListener;

    public KTVLocalMusicItemAdapter(Context context) {
        this.mContext = context;
        this.mData = new ArrayList<MusicPlaylistDBBean>();
    }

    public void setData(List<MusicPlaylistDBBean> data) {
        this.mData.clear();
        this.mData.addAll(data);
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mListener = listener;
    }

    public int getItemCount() {
        return this.mData.size();
    }

    @NonNull
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_song_library_channel, parent, false);
        MyViewHolder viewHolder = new MyViewHolder(view);
        return viewHolder;
    }

    public void onBindViewHolder(@NonNull MyViewHolder holder, int position) {
        final MusicPlaylistDBBean music = this.mData.get(position);
        if (music != null) {
            ImageLoader.loadImage((ImageView)holder.songCover, (String)"", (int)R.drawable.icon_song_cover_default);
            holder.songName.setText((CharSequence)music.getMusicName());
            holder.singer.setText((CharSequence)music.getSinger());
            holder.btnSing.setVisibility(8);
        }
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (KTVLocalMusicItemAdapter.this.mListener != null) {
                    KTVLocalMusicItemAdapter.this.mListener.onItemClick(music);
                }
            }
        });
    }

    public static interface OnItemClickListener {
        public void onItemClick(MusicPlaylistDBBean var1);
    }

    public class MyViewHolder
    extends RecyclerView.ViewHolder {
        public YYTextView singer;
        public YYTextView btnSing;
        public YYTextView songName;
        public RoundConerImageView songCover;

        public MyViewHolder(View view) {
            super(view);
            this.singer = (YYTextView)view.findViewById(R.id.tv_singer);
            this.btnSing = (YYTextView)view.findViewById(R.id.tv_btn_sing);
            this.songName = (YYTextView)view.findViewById(R.id.tv_name);
            this.songCover = (RoundConerImageView)view.findViewById(R.id.rviv_cover);
        }
    }
}

