/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.service;

import android.text.TextUtils;
import com.yy.appbase.extensions.AppBaseExtensionKt;
import com.yy.appbase.extensions.CommonExtensionsKt;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.plugins.ktv.service.OnNotifyCallback;
import com.yy.hiyo.proto.callback.IProtoNotify;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.ktv.srv.popularity.LevelDownMsg;
import net.ihago.ktv.srv.popularity.LevelUpMsg;
import net.ihago.ktv.srv.popularity.PopNotify;
import net.ihago.ktv.srv.popularity.SingBeginMsg;
import net.ihago.ktv.srv.popularity.SingEndMsg;
import net.ihago.ktv.srv.popularity.StageChangeMsg;
import net.ihago.ktv.srv.popularity.StageUpMsg;
import net.ihago.ktv.srv.popularity.Uri;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/yy/hiyo/channel/plugins/ktv/service/KTVPopularityNotify;", "Lcom/yy/hiyo/proto/callback/IProtoNotify;", "Lnet/ihago/ktv/srv/popularity/PopNotify;", "callback", "Lcom/yy/hiyo/channel/plugins/ktv/service/OnNotifyCallback;", "(Lcom/yy/hiyo/channel/plugins/ktv/service/OnNotifyCallback;)V", "getCallback", "()Lcom/yy/hiyo/channel/plugins/ktv/service/OnNotifyCallback;", "isValidity", "", "notify", "onNotify", "", "parseNotify", "uri", "", "serviceName", "", "ktv_debug"})
public final class KTVPopularityNotify
implements IProtoNotify<PopNotify> {
    @NotNull
    private final OnNotifyCallback callback;

    @NotNull
    public String serviceName() {
        return "net.ihago.ktv.srv.popularity";
    }

    public void onNotify(@NotNull PopNotify notify) {
        Intrinsics.checkParameterIsNotNull((Object)notify, (String)"notify");
        if (!this.isValidity(notify)) {
            return;
        }
        List list = notify.uris;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"notify.uris");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Integer it = (Integer)element$iv;
            boolean bl = false;
            Integer n = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"it");
            this.parseNotify(n, notify);
        }
    }

    private final void parseNotify(int uri, PopNotify notify) {
        block2: {
            int n;
            block6: {
                block5: {
                    block4: {
                        block3: {
                            block1: {
                                MLog.info((Object)"KTVPopularityNotify", (String)("parseNotify uri=" + uri), (Object[])new Object[0]);
                                if (TextUtils.isEmpty((CharSequence)notify.cid)) {
                                    MLog.error((Object)"KTVPopularityNotify", (String)"parseNotify cid is empty!", (Object[])new Object[0]);
                                    return;
                                }
                                n = uri;
                                if (n != Uri.URI_POP_SING_BEGIN_MSG.getValue()) break block1;
                                String string2 = notify.cid;
                                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"notify.cid");
                                SingBeginMsg singBeginMsg = notify.sing_begin_msg;
                                Intrinsics.checkExpressionValueIsNotNull((Object)singBeginMsg, (String)"notify.sing_begin_msg");
                                this.callback.onHandlePopSingBeginMsg(string2, singBeginMsg);
                                break block2;
                            }
                            if (n != Uri.URI_POP_STAGE_CHANGE_MSG.getValue()) break block3;
                            String string3 = notify.cid;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"notify.cid");
                            StageChangeMsg stageChangeMsg = notify.stage_change_msg;
                            Intrinsics.checkExpressionValueIsNotNull((Object)stageChangeMsg, (String)"notify.stage_change_msg");
                            this.callback.onHandlePopStageChanged(string3, stageChangeMsg);
                            break block2;
                        }
                        if (n != Uri.URI_POP_STAGE_UP_MSG.getValue()) break block4;
                        String string4 = notify.cid;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"notify.cid");
                        StageUpMsg stageUpMsg = notify.stage_up_msg;
                        Intrinsics.checkExpressionValueIsNotNull((Object)stageUpMsg, (String)"notify.stage_up_msg");
                        this.callback.onHandlePopStageUp(string4, stageUpMsg);
                        break block2;
                    }
                    if (n != Uri.URI_POP_SING_END_MSG.getValue()) break block5;
                    String string5 = notify.cid;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"notify.cid");
                    SingEndMsg singEndMsg = notify.sing_over_msg;
                    Intrinsics.checkExpressionValueIsNotNull((Object)singEndMsg, (String)"notify.sing_over_msg");
                    this.callback.onHandlePopSingEnd(string5, singEndMsg);
                    break block2;
                }
                if (n != Uri.URI_POP_LEVEL_UP_MSG.getValue()) break block6;
                String string6 = notify.cid;
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"notify.cid");
                LevelUpMsg levelUpMsg = notify.level_up_msg;
                Intrinsics.checkExpressionValueIsNotNull((Object)levelUpMsg, (String)"notify.level_up_msg");
                this.callback.onHandlePopLevelUp(string6, levelUpMsg);
                break block2;
            }
            if (n != Uri.URI_POP_LEVEL_DOWN_MSG.getValue()) break block2;
            String string7 = notify.cid;
            Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"notify.cid");
            LevelDownMsg levelDownMsg = notify.level_down_msg;
            Intrinsics.checkExpressionValueIsNotNull((Object)levelDownMsg, (String)"notify.level_down_msg");
            this.callback.onHandlePopLevelDown(string7, levelDownMsg);
        }
    }

    private final boolean isValidity(PopNotify notify) {
        String curChannelId = AppBaseExtensionKt.getVoiceRoomId();
        if (CommonExtensionsKt.isNotNullOrEmpty((String)curChannelId) && CommonExtensionsKt.isNotNullOrEmpty((String)notify.header.roomid) && !StringUtils.equal((String)curChannelId, (String)notify.header.roomid)) {
            String msg = "KTV\u4eba\u6c14\u5e7f\u64ad\u975e\u5f53\u524d\u623f\u95f4 cur: " + curChannelId + ", notify: " + notify.header.roomid + ", uris: " + notify.uris;
            MLog.error((Object)"KTVPopularityNotify", (String)"onNotify %s", (Object[])new Object[]{msg});
            return false;
        }
        return true;
    }

    @NotNull
    public final OnNotifyCallback getCallback() {
        return this.callback;
    }

    public KTVPopularityNotify(@NotNull OnNotifyCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.callback = callback;
    }
}

