/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.songlist;

import androidx.recyclerview.widget.DiffUtil;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import java.util.List;

public class KTVSongListDiffCallback
extends DiffUtil.Callback {
    private List<KTVRoomSongInfo> mOldData;
    private List<KTVRoomSongInfo> mNewData;

    public KTVSongListDiffCallback(List<KTVRoomSongInfo> oldData, List<KTVRoomSongInfo> newData) {
        this.mOldData = oldData;
        this.mNewData = newData;
    }

    public int getOldListSize() {
        return this.mOldData == null ? 0 : this.mOldData.size();
    }

    public int getNewListSize() {
        return this.mNewData == null ? 0 : this.mNewData.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        KTVRoomSongInfo oldItem = this.mOldData.get(oldItemPosition);
        KTVRoomSongInfo newItem = this.mNewData.get(newItemPosition);
        if (oldItemPosition == this.mOldData.size() - 1 && this.mNewData.size() > this.mOldData.size()) {
            return false;
        }
        return StringUtils.equal((String)oldItem.getSongId(), (String)newItem.getSongId());
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        KTVRoomSongInfo oldItem = this.mOldData.get(oldItemPosition);
        KTVRoomSongInfo newItem = this.mNewData.get(newItemPosition);
        if (oldItemPosition == 0 || newItemPosition == 0) {
            return false;
        }
        if (!StringUtils.equal((String)oldItem.getAvatar(), (String)newItem.getAvatar())) {
            return false;
        }
        if (!StringUtils.equal((String)oldItem.getNick(), (String)newItem.getNick())) {
            return false;
        }
        if (!StringUtils.equal((String)oldItem.getOriginalSinger(), (String)newItem.getOriginalSinger())) {
            return false;
        }
        if (!StringUtils.equal((String)oldItem.getSongName(), (String)newItem.getSongName())) {
            return false;
        }
        if (oldItem.getPosition() != newItem.getPosition()) {
            return false;
        }
        return oldItem.getStatus() == newItem.getStatus();
    }
}

