/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers.singersong;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnRefreshLoadMoreListener;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.component.base.ui.widget.BottomSecondaryPanel;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVProtoCallback;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ISelectSongListener;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.view.KTVMusicItemAdapter;
import com.yy.hiyo.channel.plugins.ktv.model.songList.KTVMusicListProvider;
import java.util.List;
import net.ihago.ktv.api.search.Singer;

public class KTVSingerSongView
extends BottomSecondaryPanel
implements View.OnClickListener,
KTVMusicItemAdapter.ItemClickListener {
    private Singer mSinger;
    private YYImageView closeIv;
    private RecyclerView songRv;
    private KTVMusicItemAdapter mAdapter;
    private SmartRefreshLayout mRefreshLayout;
    private CommonStatusLayout mStatusLayout;
    private ISelectSongListener mSelectSongListener;
    private IKTVHandler mKTVHandler;
    private boolean hasNext = true;
    private int mPageType;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public KTVSingerSongView(Context context, IKTVHandler ktvHandler, Singer singer, int pageType) {
        super(context);
        this.mKTVHandler = ktvHandler;
        this.mSinger = singer;
        this.mPageType = pageType;
        this.createView();
    }

    private void createView() {
        View.inflate((Context)this.mContext, (int)R.layout.layout_singers_song_channel, (ViewGroup)this);
        ((YYTextView)this.findViewById(R.id.tv_title)).setText((CharSequence)this.mSinger.singer_name);
        this.closeIv = (YYImageView)this.findViewById(R.id.iv_close);
        this.closeIv.setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.ll_container).setOnClickListener((View.OnClickListener)this);
        this.mRefreshLayout = (SmartRefreshLayout)this.findViewById(R.id.srl_refresh);
        this.mStatusLayout = (CommonStatusLayout)this.findViewById(R.id.statuslayout);
        this.mStatusLayout.showLoading();
        this.songRv = (RecyclerView)this.findViewById(R.id.rv_list);
        this.songRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mAdapter = new KTVMusicItemAdapter(this.getContext(), 4);
        this.mAdapter.setOnItemClickListener(this);
        this.songRv.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.fetchSingerSongList(true);
        this.mRefreshLayout.setOnRefreshLoadMoreListener(new OnRefreshLoadMoreListener(){

            public void onLoadMore(@NonNull RefreshLayout refreshLayout) {
                if (KTVSingerSongView.this.hasNext) {
                    KTVSingerSongView.this.fetchSingerSongList(false);
                } else {
                    KTVSingerSongView.this.mRefreshLayout.finishLoadMore();
                }
            }

            public void onRefresh(@NonNull RefreshLayout refreshLayout) {
                KTVSingerSongView.this.fetchSingerSongList(true);
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mBinder.singleBindSourceTo((KvoSource)((KTVMusicListProvider)this.mKTVHandler.getKTVManager().getKTVMusicListProvider()));
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mBinder.clearAllKvoConnections();
    }

    @KvoMethodAnnotation(sourceClass=KTVMusicListProvider.class, name="singerSongDataChanged")
    public void onSingerSongChanged(KvoEventIntent data) {
        if (data.isStickyNotify()) {
            return;
        }
        final List<KTVMusicInfo> list = ((KTVMusicListProvider)data.source()).getSingerSongList();
        FeatureLog.i((String)"FTKTVList", (String)"onSingerSongChanged, size = %s", (Object[])new Object[]{list == null ? 0 : list.size()});
        if (YYTaskExecutor.isMainThread()) {
            this.updateView(list);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    KTVSingerSongView.this.updateView(list);
                }
            });
        }
    }

    private void fetchSingerSongList(boolean isRefresh) {
        this.mKTVHandler.getKTVManager().getKTVMusicListProvider().getSingerSongList(this.mSinger.singer_id, isRefresh, new IKTVProtoCallback<KTVMusicListProvider.KTVSongListResponse>(){

            @Override
            public void onSuccess(@NonNull KTVMusicListProvider.KTVSongListResponse data) {
                KTVSingerSongView.this.hasNext = data.hasNext;
                KTVSingerSongView.this.updateView(data.songList);
            }

            @Override
            public void onError(int code, String errorMessage) {
                KTVSingerSongView.this.mStatusLayout.showError();
                KTVSingerSongView.this.mRefreshLayout.finishRefresh();
                KTVSingerSongView.this.mRefreshLayout.finishLoadMore();
            }
        });
    }

    private void updateView(List<KTVMusicInfo> songList) {
        this.mStatusLayout.hideAllStatus();
        if (null == songList || songList.isEmpty()) {
            this.mStatusLayout.showNoData();
        } else {
            this.mAdapter.setData(songList);
        }
        this.mRefreshLayout.finishRefresh();
        this.mRefreshLayout.finishLoadMore();
    }

    @Override
    public void onItemClick(KTVMusicInfo song) {
        if (null != this.mSelectSongListener) {
            String pgType = "";
            if (this.mPageType == 1) {
                pgType = "4";
            } else if (this.mPageType == 2) {
                pgType = "6";
            } else if (this.mPageType == 3) {
                pgType = "5";
            } else if (this.mPageType == 4) {
                pgType = "7";
            }
            this.mSelectSongListener.selectSong(song, pgType);
        }
    }

    public void setOnSelectSongListener(ISelectSongListener listener) {
        this.mSelectSongListener = listener;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_close) {
            this.closeIv.setEnabled(false);
            this.hideView();
        }
    }
}

