/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.tablayout.SlidingTabLayout;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.component.base.ui.widget.BottomSecondaryPanel;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.common.bean.KTVSingersData;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ISelectSongListener;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers.ISelectSingerListener;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers.KTVSingersMvp;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers.KTVSingersPage;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers.KTVSingersPageAdapter;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers.singersong.KTVSingerSongView;
import java.util.ArrayList;
import java.util.List;
import net.ihago.ktv.api.search.Singer;
import org.jetbrains.annotations.NotNull;

public class KTVSingersView
extends BottomSecondaryPanel
implements KTVSingersMvp.IView,
View.OnClickListener,
ISelectSingerListener {
    private KTVSingersMvp.IPresenter mPresenter;
    private IKTVHandler mKtvHandler;
    private SlidingTabLayout mStlTabLayout;
    private YYViewPager mVpPagers;
    private KTVSingersPageAdapter mPagerAdapter;
    private List<KTVSingersPage> mPageList = new ArrayList<KTVSingersPage>();
    private ISelectSongListener mSelectSongListener;
    private YYImageView closeIv;

    public KTVSingersView(Context context, IKTVHandler ktvHandler) {
        super(context);
        this.mKtvHandler = ktvHandler;
        this.createView();
    }

    private void createView() {
        View.inflate((Context)this.mContext, (int)R.layout.layout_singers_channel, (ViewGroup)this);
        ((YYTextView)this.findViewById(R.id.tv_title)).setText((CharSequence)ResourceUtils.getString((int)R.string.title_ktv_singers));
        this.mStlTabLayout = (SlidingTabLayout)this.findViewById(R.id.stl_tab_layout);
        this.mVpPagers = (YYViewPager)this.findViewById(R.id.vp_pagers);
        this.closeIv = (YYImageView)this.findViewById(R.id.iv_close);
        this.findViewById(R.id.ll_container).setOnClickListener((View.OnClickListener)this);
        this.closeIv.setOnClickListener((View.OnClickListener)this);
        this.initPagers();
    }

    private void initPagers() {
        boolean onlyShowAll;
        this.mPageList.add(new KTVSingersPage(this.mContext, 1));
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.PERFORMANCE_CONFIG);
        boolean bl = onlyShowAll = null != configData && configData.getBoolValue("ktv_singers_only_show_all", false);
        if (!onlyShowAll) {
            this.mPageList.add(new KTVSingersPage(this.mContext, 2));
            this.mPageList.add(new KTVSingersPage(this.mContext, 3));
            this.mPageList.add(new KTVSingersPage(this.mContext, 4));
        }
        this.mPagerAdapter = new KTVSingersPageAdapter(this.getContext(), this.mPageList);
        this.mVpPagers.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.mStlTabLayout.setViewPager((ViewPager)this.mVpPagers);
        for (KTVSingersPage page : this.mPageList) {
            page.setOnSelectSingerListener(this);
        }
        this.mVpPagers.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){
            private boolean isScrolling = false;

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
            }

            public void onPageScrollStateChanged(int state) {
                if (state == 0) {
                    if (!this.isScrolling) {
                        return;
                    }
                    this.isScrolling = false;
                } else {
                    if (this.isScrolling) {
                        return;
                    }
                    this.isScrolling = true;
                }
                for (KTVSingersPage page : KTVSingersView.this.mPageList) {
                    page.scrollStateChanged(this.isScrolling);
                }
            }
        });
    }

    public void setPresenter(KTVSingersMvp.IPresenter presenter) {
        this.mPresenter = presenter;
    }

    @Override
    public void onSelect(Singer singer, int pageType) {
        KTVSingerSongView ktvSingerSongView = new KTVSingerSongView(this.mContext, this.mKtvHandler, singer, pageType);
        ktvSingerSongView.setOnSelectSongListener(this.mSelectSongListener);
        this.addView((View)ktvSingerSongView);
    }

    @Override
    public void showSuccess(@NotNull KTVSingersData data) {
        for (KTVSingersPage page : this.mPageList) {
            if (null == page) continue;
            page.dataChanged(data);
        }
    }

    @Override
    public void showError() {
        for (KTVSingersPage page : this.mPageList) {
            if (null == page) continue;
            page.showError();
        }
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_close) {
            this.closeIv.setEnabled(false);
            this.hideView();
        }
    }

    public void setOnSelectSongListener(ISelectSongListener listener) {
        this.mSelectSongListener = listener;
    }
}

