/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ranking;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import com.yy.appbase.ui.widget.tablayout.SlidingTabLayout;
import com.yy.appbase.ui.widget.viewpager.YYViewPager;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.component.base.ui.widget.BottomSecondaryPanel;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ISelectSongListener;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ranking.KTVRankingMvp;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ranking.KTVRankingPage;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ranking.KTVRankingPageAdapter;
import java.util.ArrayList;
import java.util.List;
import net.ihago.ktv.api.search.RankingType;

public class KTVRankingView
extends BottomSecondaryPanel
implements KTVRankingMvp.IView,
View.OnClickListener {
    private KTVRankingMvp.IPresenter mPresenter;
    private IKTVHandler mKTVHandler;
    private SlidingTabLayout mStlTabLayout;
    private YYViewPager mVpPagers;
    private KTVRankingPageAdapter mPagerAdapter;
    private List<KTVRankingPage> mPageList = new ArrayList<KTVRankingPage>();
    private KTVRankingPage mWeekPage;
    private KTVRankingPage mMonthPage;
    private KTVRankingPage mAllPage;
    private YYImageView closeIv;

    public KTVRankingView(Context context, IKTVHandler ktvHandler) {
        super(context);
        this.mKTVHandler = ktvHandler;
        this.createView();
    }

    private void createView() {
        View.inflate((Context)this.mContext, (int)R.layout.layout_ranking_channel, (ViewGroup)this);
        ((YYTextView)this.findViewById(R.id.tv_title)).setText((CharSequence)ResourceUtils.getString((int)R.string.title_ktv_ranking_ab));
        this.mStlTabLayout = (SlidingTabLayout)this.findViewById(R.id.stl_tab_layout);
        this.mVpPagers = (YYViewPager)this.findViewById(R.id.vp_pagers);
        this.closeIv = (YYImageView)this.findViewById(R.id.iv_close);
        this.findViewById(R.id.ll_container).setOnClickListener((View.OnClickListener)this);
        this.closeIv.setOnClickListener((View.OnClickListener)this);
        this.initPagers();
    }

    private void initPagers() {
        this.mWeekPage = new KTVRankingPage(this.mContext, this.mKTVHandler, RankingType.kRankingWeek);
        this.mMonthPage = new KTVRankingPage(this.mContext, this.mKTVHandler, RankingType.kRankingMonth);
        this.mAllPage = new KTVRankingPage(this.mContext, this.mKTVHandler, RankingType.kRankingAll);
        this.mPageList.add(this.mWeekPage);
        this.mPageList.add(this.mMonthPage);
        this.mPageList.add(this.mAllPage);
        this.mPagerAdapter = new KTVRankingPageAdapter(this.getContext(), this.mPageList);
        this.mVpPagers.setAdapter((PagerAdapter)this.mPagerAdapter);
        this.mStlTabLayout.setViewPager((ViewPager)this.mVpPagers);
    }

    public void setPresenter(KTVRankingMvp.IPresenter presenter) {
        this.mPresenter = presenter;
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_close) {
            this.closeIv.setEnabled(false);
            this.hideView();
        }
    }

    public void setOnSelectSongListener(ISelectSongListener listener) {
        this.mWeekPage.setOnSelectSongListener(listener);
        this.mMonthPage.setOnSelectSongListener(listener);
        this.mAllPage.setOnSelectSongListener(listener);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        for (KTVRankingPage page : this.mPageList) {
            page.onParentAttachedToWindow();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        for (KTVRankingPage page : this.mPageList) {
            page.onParentDetachedFromWindow();
        }
    }
}

