/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ranking;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnRefreshLoadMoreListener;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.common.bean.KTVRankingInfo;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVProtoCallback;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.ISelectSongListener;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.view.KTVMusicItemAdapter;
import com.yy.hiyo.channel.plugins.ktv.model.songList.KTVMusicListProvider;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.ihago.ktv.api.search.RankingType;

public class KTVRankingPage
extends YYConstraintLayout
implements KTVMusicItemAdapter.ItemClickListener {
    private Context mContext;
    private RecyclerView rankingRv;
    private KTVMusicItemAdapter mAdapter;
    private SmartRefreshLayout mRefreshLayout;
    private CommonStatusLayout mStatusLayout;
    private ISelectSongListener mSelectSongListener;
    private IKTVHandler mKTVHandler;
    private boolean hasNext = true;
    private RankingType mPageType;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public KTVRankingPage(Context context, IKTVHandler ktvHandler, RankingType type) {
        super(context);
        this.mContext = context;
        this.mPageType = type;
        this.mKTVHandler = ktvHandler;
        this.createView();
    }

    private void createView() {
        View.inflate((Context)this.mContext, (int)R.layout.layout_ranking_page_channel, (ViewGroup)this);
        this.mRefreshLayout = (SmartRefreshLayout)this.findViewById(R.id.srl_refresh);
        this.mStatusLayout = (CommonStatusLayout)this.findViewById(R.id.statuslayout);
        this.mStatusLayout.showLoading();
        this.rankingRv = (RecyclerView)this.findViewById(R.id.rv_list);
        this.rankingRv.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.mAdapter = new KTVMusicItemAdapter(this.getContext(), 5);
        this.mAdapter.setOnItemClickListener(this);
        this.rankingRv.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.fetchRankingList(true);
        this.mRefreshLayout.setOnRefreshLoadMoreListener(new OnRefreshLoadMoreListener(){

            public void onLoadMore(@NonNull RefreshLayout refreshLayout) {
                if (KTVRankingPage.this.hasNext) {
                    KTVRankingPage.this.fetchRankingList(false);
                } else {
                    KTVRankingPage.this.mRefreshLayout.finishLoadMore();
                }
            }

            public void onRefresh(@NonNull RefreshLayout refreshLayout) {
                KTVRankingPage.this.fetchRankingList(true);
            }
        });
    }

    public void onParentAttachedToWindow() {
        this.mBinder.singleBindSourceTo((KvoSource)((KTVMusicListProvider)this.mKTVHandler.getKTVManager().getKTVMusicListProvider()));
    }

    public void onParentDetachedFromWindow() {
        this.mBinder.clearAllKvoConnections();
    }

    @KvoMethodAnnotation(sourceClass=KTVMusicListProvider.class, name="rankingDataChanged")
    public void onRankingChanged(KvoEventIntent data) {
        if (data.isStickyNotify()) {
            return;
        }
        ConcurrentHashMap<Integer, KTVRankingInfo> map = ((KTVMusicListProvider)data.source()).getRankingDataMap();
        final KTVRankingInfo rankingInfo = map.get(this.mPageType.getValue());
        FeatureLog.i((String)"FTKTVList", (String)"onRankingChanged, size = %s", (Object[])new Object[]{rankingInfo == null ? 0 : rankingInfo.getRankingList().size()});
        if (YYTaskExecutor.isMainThread()) {
            this.updateView(rankingInfo.getRankingList());
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    KTVRankingPage.this.updateView(rankingInfo.getRankingList());
                }
            });
        }
    }

    private void fetchRankingList(boolean isRefresh) {
        this.mKTVHandler.getKTVManager().getKTVMusicListProvider().getRankingList(this.mPageType, isRefresh, new IKTVProtoCallback<KTVMusicListProvider.KTVSongListResponse>(){

            @Override
            public void onSuccess(@NonNull KTVMusicListProvider.KTVSongListResponse data) {
                KTVRankingPage.this.hasNext = data.hasNext;
                KTVRankingPage.this.updateView(data.songList);
            }

            @Override
            public void onError(int code, String errorMessage) {
                KTVRankingPage.this.mStatusLayout.showError();
                KTVRankingPage.this.mRefreshLayout.finishRefresh();
                KTVRankingPage.this.mRefreshLayout.finishLoadMore();
            }
        });
    }

    private void updateView(List<KTVMusicInfo> songList) {
        this.mStatusLayout.hideAllStatus();
        if (null == songList || songList.isEmpty()) {
            this.mStatusLayout.showNoData();
        } else {
            this.mAdapter.setData(songList);
        }
        this.mRefreshLayout.finishRefresh();
        this.mRefreshLayout.finishLoadMore();
    }

    @Override
    public void onItemClick(KTVMusicInfo song) {
        if (null != this.mSelectSongListener) {
            String pgType = "";
            if (this.mPageType == RankingType.kRankingAll) {
                pgType = "8";
            } else if (this.mPageType == RankingType.kRankingWeek) {
                pgType = "10";
            } else if (this.mPageType == RankingType.kRankingMonth) {
                pgType = "11";
            }
            this.mSelectSongListener.selectSong(song, pgType);
        }
    }

    public void setOnSelectSongListener(ISelectSongListener listener) {
        this.mSelectSongListener = listener;
    }
}

