/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary;

import androidx.recyclerview.widget.DiffUtil;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import java.util.List;

public class KTVLibraryListDiffCallback
extends DiffUtil.Callback {
    private List<KTVMusicInfo> mOldData;
    private List<KTVMusicInfo> mNewData;

    public KTVLibraryListDiffCallback(List<KTVMusicInfo> oldData, List<KTVMusicInfo> newData) {
        this.mOldData = oldData;
        this.mNewData = newData;
    }

    public int getOldListSize() {
        return this.mOldData == null ? 0 : this.mOldData.size();
    }

    public int getNewListSize() {
        return this.mNewData == null ? 0 : this.mNewData.size();
    }

    public boolean areItemsTheSame(int oldItemPosition, int newItemPosition) {
        KTVMusicInfo oldItem = this.mOldData.get(oldItemPosition);
        KTVMusicInfo newItem = this.mNewData.get(newItemPosition);
        return StringUtils.equal((String)oldItem.getSongId(), (String)newItem.getSongId());
    }

    public boolean areContentsTheSame(int oldItemPosition, int newItemPosition) {
        KTVMusicInfo oldItem = this.mOldData.get(oldItemPosition);
        KTVMusicInfo newItem = this.mNewData.get(newItemPosition);
        if (!StringUtils.equal((String)oldItem.getSongName(), (String)newItem.getSongName())) {
            return false;
        }
        if (!StringUtils.equal((String)oldItem.getArtistName(), (String)newItem.getArtistName())) {
            return false;
        }
        if (!StringUtils.equal((String)oldItem.getCoverImageUrl(), (String)newItem.getCoverImageUrl())) {
            return false;
        }
        return oldItem.isRequested() == newItem.isRequested();
    }
}

