/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.widget;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.widget.KTVCircleProgressBar;

public class KTVPanelAvatarView
extends YYFrameLayout {
    private KTVCircleProgressBar mCircleProgressBar;
    private CircleImageView mIvAvatar;
    private RecycleImageView mIvCdBg;
    private int wH;
    private AnimatorSet mAnimatorSet;

    public KTVPanelAvatarView(Context context) {
        this(context, null);
    }

    public KTVPanelAvatarView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.view_ktv_panel_avatar_channel, (ViewGroup)this);
        this.mCircleProgressBar = (KTVCircleProgressBar)this.findViewById(R.id.circle_pb);
        this.mIvAvatar = (CircleImageView)this.findViewById(R.id.iv_avatar);
        this.mIvCdBg = (RecycleImageView)this.findViewById(R.id.iv_cd_bg);
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.KTVPanelAvatarView);
        this.wH = (int)ta.getDimension(R.styleable.KTVPanelAvatarView_avatar_width_height, (float)ResolutionUtils.dip2Px((float)90.0f));
        ta.recycle();
        this.mCircleProgressBar.resetCircleBarSize((float)this.wH * 74.0f / 90.0f, true);
        ViewGroup.LayoutParams avatarLayoutParam = this.mIvAvatar.getLayoutParams();
        avatarLayoutParam.width = this.wH * 56 / 90;
        avatarLayoutParam.height = this.wH * 56 / 90;
        this.mIvAvatar.setLayoutParams(avatarLayoutParam);
        ViewGroup.LayoutParams cdBgLayoutParams = this.mIvCdBg.getLayoutParams();
        cdBgLayoutParams.width = this.wH;
        cdBgLayoutParams.height = this.wH;
        this.mIvCdBg.setLayoutParams(cdBgLayoutParams);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.wH, this.wH);
    }

    public void loadAvatar(String url) {
        ImageLoader.loadImage((ImageView)this.mIvAvatar, (String)(url + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.icon_default_photo);
    }

    public KTVCircleProgressBar getCircleProgressBar() {
        return this.mCircleProgressBar;
    }

    public CircleImageView getAvatarView() {
        return this.mIvAvatar;
    }

    public RecycleImageView getCdImage() {
        return this.mIvCdBg;
    }

    public void playAnimator() {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (this.mAnimatorSet == null) {
            ObjectAnimator bgAnimator = ObjectAnimator.ofFloat((Object)this.mIvCdBg, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
            bgAnimator.setDuration(8000L);
            bgAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            bgAnimator.setRepeatCount(-1);
            bgAnimator.setRepeatMode(1);
            ObjectAnimator avatarAnimator = ObjectAnimator.ofFloat((Object)this.mIvAvatar, (String)"rotation", (float[])new float[]{0.0f, 360.0f});
            avatarAnimator.setDuration(8000L);
            avatarAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            avatarAnimator.setRepeatCount(-1);
            avatarAnimator.setRepeatMode(1);
            this.mAnimatorSet = new AnimatorSet();
            this.mAnimatorSet.playTogether(new Animator[]{bgAnimator, avatarAnimator});
            this.mAnimatorSet.setDuration(8000L);
        }
        this.mAnimatorSet.start();
    }

    public void resumeAnimator() {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (this.mAnimatorSet == null) {
            this.playAnimator();
        } else {
            this.mAnimatorSet.resume();
        }
    }

    public void pauseAnimator() {
        if (Build.VERSION.SDK_INT < 19) {
            return;
        }
        if (this.mAnimatorSet != null) {
            this.mAnimatorSet.pause();
        }
    }

    public void removeAnimator() {
        if (this.mAnimatorSet != null) {
            this.mAnimatorSet.end();
            this.mAnimatorSet = null;
        }
    }

    public void destroy() {
        this.removeAnimator();
    }
}

