/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.widget.lyric;

import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class LrcEntry
implements Comparable<LrcEntry> {
    private long time;
    private String text;
    private StaticLayout staticLayout;
    private float offset = Float.MIN_VALUE;
    public static final int GRAVITY_LEFT = 1;
    public static final int GRAVITY_CENTER = 2;
    public static final int GRAVITY_RIGHT = 3;

    public String getText() {
        return this.text;
    }

    public void setStaticLayout(StaticLayout staticLayout) {
        this.staticLayout = staticLayout;
    }

    private LrcEntry(long time, String text) {
        this.time = time;
        this.text = text;
    }

    void init(TextPaint paint, int width, int gravity) {
        Layout.Alignment align;
        switch (gravity) {
            case 1: {
                align = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            default: {
                align = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 3: {
                align = Layout.Alignment.ALIGN_OPPOSITE;
            }
        }
        this.staticLayout = new StaticLayout((CharSequence)this.text, paint, width, align, 1.0f, 0.0f, false);
    }

    long getTime() {
        return this.time;
    }

    StaticLayout getStaticLayout() {
        return this.staticLayout;
    }

    int getHeight() {
        if (this.staticLayout == null) {
            return 0;
        }
        return this.staticLayout.getHeight();
    }

    public float getOffset() {
        return this.offset;
    }

    public void setOffset(float offset) {
        this.offset = offset;
    }

    @Override
    public int compareTo(LrcEntry entry) {
        if (entry == null) {
            return -1;
        }
        return (int)(this.time - entry.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<LrcEntry> parseLrc(File lrcFile) {
        if (lrcFile == null || !lrcFile.exists()) {
            return null;
        }
        ArrayList<LrcEntry> entryList = new ArrayList<LrcEntry>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(lrcFile), "utf-8"));
            while ((line = br.readLine()) != null) {
                List<LrcEntry> list = LrcEntry.parseLine(line);
                if (list == null || list.isEmpty()) continue;
                entryList.addAll(list);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        Collections.sort(entryList);
        return entryList;
    }

    static List<LrcEntry> parseLrc(String lrcText) {
        String[] array;
        if (TextUtils.isEmpty((CharSequence)lrcText)) {
            return null;
        }
        ArrayList<LrcEntry> entryList = new ArrayList<LrcEntry>();
        for (String line : array = lrcText.split("\\n")) {
            List<LrcEntry> list = LrcEntry.parseLine(line);
            if (list == null || list.isEmpty()) continue;
            entryList.addAll(list);
        }
        Collections.sort(entryList);
        return entryList;
    }

    private static List<LrcEntry> parseLine(String line) {
        if (TextUtils.isEmpty((CharSequence)line)) {
            return null;
        }
        line = line.trim();
        String regEx = "<\\s*\\d*\\s*,\\s*\\d*\\s*>";
        Pattern pat = Pattern.compile(regEx);
        Matcher mat = pat.matcher(line);
        line = mat.replaceAll("");
        Matcher lineMatcher = Pattern.compile("((\\[\\d\\d:\\d\\d\\.\\d{2,3}\\])+)(.+)").matcher(line);
        if (!lineMatcher.matches()) {
            return null;
        }
        String times = lineMatcher.group(1);
        String text = lineMatcher.group(3);
        ArrayList<LrcEntry> entryList = new ArrayList<LrcEntry>();
        Matcher timeMatcher = Pattern.compile("\\[(\\d\\d):(\\d\\d)\\.(\\d){2,3}\\]").matcher(times);
        while (timeMatcher.find()) {
            long min = Long.parseLong(timeMatcher.group(1));
            long sec = Long.parseLong(timeMatcher.group(2));
            long mil = Long.parseLong(timeMatcher.group(3));
            long time = min * 60000L + sec * 1000L + (mil >= 100L ? mil : mil * 10L);
            entryList.add(new LrcEntry(time, text));
        }
        return entryList;
    }
}

