/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.plugins.ktv.R;

public class KTVCircleProgressBar
extends YYView {
    private Paint mCirclePaint = new Paint(1);
    private Paint mPointPaint = new Paint(1);
    private float mStartAngle = -90.0f;
    private float sweepAngle = 0.0f;
    private float strokeWidth = ResolutionUtils.dip2Px((float)1.5f);
    private float pointRadius = ResolutionUtils.dip2Px((float)2.5f);
    int mRealWidth;
    private float mCircleRadius;

    public KTVCircleProgressBar(Context context) {
        this(context, null, 0);
    }

    public KTVCircleProgressBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public KTVCircleProgressBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.KtvCirclrProgressBar);
        float centerWidth = ta.getDimension(R.styleable.KtvCirclrProgressBar_cpb_center_side_width, (float)ResolutionUtils.dip2Px((float)80.0f));
        ta.recycle();
        this.resetCircleBarSize(centerWidth, false);
        this.init();
    }

    public void updateProgress(int time, int totalDuration) {
        this.sweepAngle = totalDuration == 0 ? 0.0f : (float)(time * 360 / totalDuration);
        this.invalidate();
    }

    private void init() {
        this.mCirclePaint.setColor(Color.parseColor((String)"#00FFFE"));
        this.mCirclePaint.setStyle(Paint.Style.STROKE);
        this.mCirclePaint.setStrokeWidth(this.strokeWidth);
        this.mCirclePaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPointPaint.setColor(Color.parseColor((String)"#00FFFE"));
    }

    public void resetCircleBarSize(float centerWidth, boolean needInvalidate) {
        this.mCircleRadius = centerWidth / 2.0f;
        this.mRealWidth = (int)(centerWidth + this.pointRadius * 2.0f);
        if (needInvalidate) {
            this.invalidate();
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.mRealWidth, this.mRealWidth);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        RectF circlrRectF = new RectF();
        circlrRectF.set(this.pointRadius, this.pointRadius, this.mCircleRadius * 2.0f + this.pointRadius, this.mCircleRadius * 2.0f + this.pointRadius);
        canvas.drawArc(circlrRectF, this.mStartAngle, this.sweepAngle, false, this.mCirclePaint);
        if (this.sweepAngle != 0.0f) {
            float pointCenterX = (float)(Math.cos(Math.toRadians(this.mStartAngle + this.sweepAngle)) * (double)this.mCircleRadius + (double)((float)this.mRealWidth / 2.0f));
            float pointCenterY = (float)(Math.sin(Math.toRadians(this.mStartAngle + this.sweepAngle)) * (double)this.mCircleRadius + (double)((float)this.mRealWidth / 2.0f));
            canvas.drawCircle(pointCenterX, pointCenterY, this.pointRadius, this.mPointPaint);
        }
    }

    public float getSweepAngle() {
        return this.sweepAngle;
    }

    public void setSweepAngle(float mSweepAngle) {
        this.sweepAngle = mSweepAngle;
        this.invalidate();
    }
}

