/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.panel.view;

import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.panel.view.IPanelViewState;
import com.yy.hiyo.channel.plugins.ktv.yinxiao.KtvEffectDialog;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;

public class KTVSettingPanelView
extends YYFrameLayout
implements View.OnClickListener,
IPanelViewState {
    private View ownerLayout;
    private View singerLayout;
    private SeekBar mSbMusic;
    private SeekBar mSbVoice;
    private TextView mMusicNumberTv;
    private TextView mVoiceNumberTv;
    private ImageView mIvPause;
    private ImageView mIvOwnerPause;
    private ImageView mIvOwnerSkip;
    private YYTextView mPauseTv;
    private int mIdleCount;
    private boolean mIsPause;
    private OnSettingPanelListener mListener;
    private static boolean mHasHeadset = false;
    private boolean mIsShowing;
    private static final int DEFAULT_VOLUME = 50;
    private static final int DEFAULT_SINGING_VOICE_VOLUME = 60;
    private static final int DEFAULT_SINGING_MUSIC_VOLUME = 70;
    private static final int DEFAULT_SINGING_HEADSET_VOICE_VOLUME = 50;
    private static final int DEFAULT_SINGING_HEADSET_MUSIC_VOLUME = 70;
    Runnable countDownTask = new Runnable(){

        @Override
        public void run() {
            if (KTVSettingPanelView.this.mIdleCount <= 0) {
                if (KTVSettingPanelView.this.mListener != null) {
                    KTVSettingPanelView.this.mListener.onIdleStateEnd();
                }
                return;
            }
            KTVSettingPanelView.this.mIdleCount--;
            YYTaskExecutor.postToMainThread((Runnable)this, (long)1000L);
        }
    };

    public KTVSettingPanelView(Context context) {
        this(context, null);
    }

    public KTVSettingPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        boolean isShowBtn;
        LayoutInflater.from((Context)context).inflate(R.layout.layout_ktv_setting_panel_channel, (ViewGroup)this, true);
        this.ownerLayout = this.findViewById(R.id.layout_setting_owner);
        this.singerLayout = this.findViewById(R.id.layout_setting_singer);
        this.mSbMusic = (SeekBar)this.findViewById(R.id.sb_music);
        this.mSbVoice = (SeekBar)this.findViewById(R.id.sb_voice);
        this.mVoiceNumberTv = (TextView)this.findViewById(R.id.tv_voice_seekbar_number);
        this.mMusicNumberTv = (TextView)this.findViewById(R.id.tv_music_seekbar_number);
        this.mIvPause = (ImageView)this.findViewById(R.id.iv_pause);
        this.mIvOwnerPause = (ImageView)this.findViewById(R.id.iv_pause_owner);
        this.mIvOwnerSkip = (ImageView)this.findViewById(R.id.iv_skip_owner);
        this.mPauseTv = (YYTextView)this.findViewById(R.id.tv_pause);
        this.findViewById(R.id.layout_pause).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.layout_skip).setOnClickListener((View.OnClickListener)this);
        this.findViewById(R.id.iv_back).setOnClickListener((View.OnClickListener)this);
        this.mIvOwnerPause.setOnClickListener((View.OnClickListener)this);
        this.mIvOwnerSkip.setOnClickListener((View.OnClickListener)this);
        this.mSbVoice.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                KTVSettingPanelView.this.resetIdleCount();
                KTVSettingPanelView.this.mVoiceNumberTv.setText((CharSequence)String.valueOf(progress));
                ConstraintLayout.LayoutParams paramsStrength = new ConstraintLayout.LayoutParams((ConstraintLayout.LayoutParams)KTVSettingPanelView.this.mVoiceNumberTv.getLayoutParams());
                if (Build.VERSION.SDK_INT >= 16) {
                    Rect rect = seekBar.getThumb().getBounds();
                    paramsStrength.leftMargin = (int)((float)rect.left + seekBar.getX() - (float)KTVSettingPanelView.this.mVoiceNumberTv.getWidth() - (float)ResolutionUtils.dip2Px((float)16.0f));
                } else {
                    Rect rect = seekBar.getProgressDrawable().getBounds();
                    paramsStrength.leftMargin = (int)((float)(progress * rect.width() / 100) + seekBar.getX() - (float)KTVSettingPanelView.this.mVoiceNumberTv.getWidth() - (float)ResolutionUtils.dip2Px((float)16.0f));
                }
                KTVSettingPanelView.this.mVoiceNumberTv.setLayoutParams((ViewGroup.LayoutParams)paramsStrength);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                KTVSettingPanelView.this.mVoiceNumberTv.setVisibility(0);
                KTVSettingPanelView.this.resetIdleCount();
                KTVSettingPanelView.this.mListener.onStartTrackingTouch(true);
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                KTVSettingPanelView.this.mVoiceNumberTv.setVisibility(8);
                int progress = seekBar.getProgress();
                KTVSettingPanelView.this.saveVoiceProgress(progress);
                KTVSettingPanelView.this.updateVoice(progress);
            }
        });
        this.mSbMusic.setOnSeekBarChangeListener(new SeekBar.OnSeekBarChangeListener(){

            public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
                KTVSettingPanelView.this.resetIdleCount();
                KTVSettingPanelView.this.mMusicNumberTv.setText((CharSequence)String.valueOf(progress));
                ConstraintLayout.LayoutParams paramsStrength = new ConstraintLayout.LayoutParams((ConstraintLayout.LayoutParams)KTVSettingPanelView.this.mMusicNumberTv.getLayoutParams());
                if (Build.VERSION.SDK_INT >= 16) {
                    Rect rect = seekBar.getThumb().getBounds();
                    paramsStrength.leftMargin = (int)((float)rect.left + seekBar.getX() - (float)KTVSettingPanelView.this.mMusicNumberTv.getWidth() - (float)ResolutionUtils.dip2Px((float)16.0f));
                } else {
                    Rect rect = seekBar.getProgressDrawable().getBounds();
                    paramsStrength.leftMargin = (int)((float)(progress * rect.width() / 100) + seekBar.getX() - (float)KTVSettingPanelView.this.mMusicNumberTv.getWidth() - (float)ResolutionUtils.dip2Px((float)16.0f));
                }
                KTVSettingPanelView.this.mMusicNumberTv.setLayoutParams((ViewGroup.LayoutParams)paramsStrength);
            }

            public void onStartTrackingTouch(SeekBar seekBar) {
                KTVSettingPanelView.this.mMusicNumberTv.setVisibility(0);
                KTVSettingPanelView.this.resetIdleCount();
                KTVSettingPanelView.this.mListener.onStartTrackingTouch(false);
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                KTVSettingPanelView.this.mMusicNumberTv.setVisibility(8);
                int progress = seekBar.getProgress();
                KTVSettingPanelView.this.saveMusicProgress(progress);
                KTVSettingPanelView.this.updateMusic(progress);
            }
        });
        if (RuntimeContext.sIsDebuggable && (isShowBtn = SettingFlags.getBoolean((String)"ktvyinxiaoswitch", (boolean)false))) {
            this.findViewById(R.id.btn_yinxiao_setting).setVisibility(0);
            this.findViewById(R.id.btn_yinxiao_setting).setOnClickListener((View.OnClickListener)this);
        }
    }

    private int getVoiceProgress() {
        return SettingFlags.getIntValue((String)("key_ktv_voice_progress" + AccountUtil.getUid()), (int)(mHasHeadset ? 50 : 60));
    }

    private void saveVoiceProgress(int progress) {
        SettingFlags.setIntValue((String)("key_ktv_voice_progress" + AccountUtil.getUid()), (int)progress);
        if (!SettingFlags.containKey((String)("key_ktv_music_progress" + AccountUtil.getUid()))) {
            this.saveMusicProgress(70);
        }
    }

    private int getMusicProgress() {
        return SettingFlags.getIntValue((String)("key_ktv_music_progress" + AccountUtil.getUid()), (int)(mHasHeadset ? 70 : 70));
    }

    private void saveMusicProgress(int progress) {
        SettingFlags.setIntValue((String)("key_ktv_music_progress" + AccountUtil.getUid()), (int)progress);
        if (!SettingFlags.containKey((String)("key_ktv_voice_progress" + AccountUtil.getUid()))) {
            this.saveVoiceProgress(60);
        }
    }

    private void resetIdleCount() {
        this.mIdleCount = 5;
    }

    private void startCalIdleTime() {
        this.resetIdleCount();
        YYTaskExecutor.postToMainThread((Runnable)this.countDownTask);
    }

    public void updatePauseBtnState(boolean isPause) {
        this.mIvPause.setImageResource(isPause ? R.drawable.ico_ktv_panel_setting_resume : R.drawable.ico_ktv_panel_setting_pause);
        this.mIvOwnerPause.setImageResource(isPause ? R.drawable.ico_ktv_owne_panel_setting_resume : R.drawable.ico_ktv_owne_panel_setting_pause);
        this.mPauseTv.setText((CharSequence)ResourceUtils.getString((int)(isPause ? R.string.title_ktv_setting_resume : R.string.title_ktv_setting_pause)));
    }

    private void updateVoice(int progress) {
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setMicVolume(progress);
    }

    private void updateMusic(int progress) {
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).adjustAudioMixingVolume(progress);
    }

    public void setSdkVolume(boolean isSinging) {
        this.updateVoice(isSinging ? this.getVoiceProgress() : 50);
        this.updateMusic(isSinging ? this.getMusicProgress() : 50);
    }

    private void updateVoiceVolume() {
        this.mSbVoice.setProgress(this.getVoiceProgress());
    }

    private void updateMusicVolume() {
        this.mSbMusic.setProgress(this.getMusicProgress());
    }

    public void headsetChanged(boolean hasHeadset, boolean isSinging) {
        KTVSettingPanelView.setHasHeadset(hasHeadset);
        this.setSdkVolume(isSinging);
        this.updateVoiceVolume();
        this.updateMusicVolume();
    }

    public static void setHasHeadset(boolean hasHeadset) {
        mHasHeadset = hasHeadset;
    }

    public void onClick(View v) {
        int vId = v.getId();
        if (vId == R.id.layout_pause || vId == R.id.iv_pause_owner) {
            this.resetIdleCount();
            if (this.mListener != null) {
                this.mListener.clickPauseBtn(v);
            }
        } else if (vId == R.id.layout_skip || vId == R.id.iv_skip_owner) {
            this.resetIdleCount();
            if (this.mListener != null) {
                this.mListener.clickSkipBtn(v);
            }
        } else if (vId == R.id.btn_yinxiao_setting) {
            KtvEffectDialog dialog2 = new KtvEffectDialog(this.getContext());
            dialog2.show();
        } else if (vId == R.id.iv_back) {
            this.resetIdleCount();
            if (this.mListener != null) {
                this.mListener.clickBack();
            }
        }
    }

    public void setOnSettingPanelListener(OnSettingPanelListener listener) {
        this.mListener = listener;
    }

    @Override
    public void onPanelViewShow(boolean hasPausePolicy, boolean isSinger, boolean isPause) {
        this.mIsShowing = true;
        this.mIsPause = isPause;
        if (isSinger) {
            this.ownerLayout.setVisibility(8);
            this.singerLayout.setVisibility(0);
        } else {
            this.ownerLayout.setVisibility(hasPausePolicy ? 0 : 8);
            this.singerLayout.setVisibility(hasPausePolicy ? 8 : 0);
        }
        this.updateMusicVolume();
        this.updateVoiceVolume();
        this.updatePauseBtnState(this.mIsPause);
        this.startCalIdleTime();
    }

    @Override
    public void onPanelViewHide() {
        this.mIsShowing = false;
        YYTaskExecutor.removeTask((Runnable)this.countDownTask);
    }

    @Override
    public void onIsPauseState(boolean isPause) {
        this.mIsPause = isPause;
    }

    @Override
    public boolean isShowing() {
        return this.mIsShowing;
    }

    public static interface OnSettingPanelListener {
        public void clickPauseBtn(View var1);

        public void clickSkipBtn(View var1);

        public void onIdleStateEnd();

        public void onStartTrackingTouch(boolean var1);

        public void clickBack();
    }
}

