/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.panel.utils;

import android.content.Context;
import android.media.AudioManager;
import androidx.annotation.Nullable;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemServiceUtils;

public class KTVVolumeUtils {
    private static final String TAG = "KTVVolumeUtils";
    private static volatile int mPlayerVolume = 100;

    @Nullable
    public static AudioManager getAudioManager() {
        return SystemServiceUtils.getAudioManager((Context)RuntimeContext.sApplicationContext);
    }

    public static void adjustVoiceVolume(final int volume) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                AudioManager audioManager = KTVVolumeUtils.getAudioManager();
                if (audioManager == null) {
                    return;
                }
                double percent = (double)volume / 100.0;
                int playerVolume = (int)(percent * (double)KTVVolumeUtils.getVoiceMaxVolume());
                audioManager.setStreamVolume(0, playerVolume, 0);
                if (volume == 0) {
                    // empty if block
                }
                mPlayerVolume = volume;
            }
        });
    }

    public static int getVoiceVolume() {
        AudioManager audioManager = KTVVolumeUtils.getAudioManager();
        if (audioManager == null) {
            return 0;
        }
        int callVolume = audioManager.getStreamVolume(0);
        if (mPlayerVolume == 0 && callVolume <= 1) {
            return 0;
        }
        if (mPlayerVolume > 0 && callVolume == 0) {
            return 1;
        }
        return callVolume;
    }

    public static int getVoiceMaxVolume() {
        AudioManager audioManager = KTVVolumeUtils.getAudioManager();
        if (audioManager == null) {
            return 0;
        }
        return audioManager.getStreamMaxVolume(0);
    }

    public static void adjustPlayMusicVolume(final int volume) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                AudioManager audioManager = KTVVolumeUtils.getAudioManager();
                if (audioManager == null) {
                    return;
                }
                double percent = (double)volume / 100.0;
                int gameVolume = (int)(percent * (double)KTVVolumeUtils.getPlayMusicMaxVolume());
                if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)KTVVolumeUtils.TAG, (String)"adjustGameVolume max %d", (Object[])new Object[]{KTVVolumeUtils.getPlayMusicMaxVolume()});
                }
                if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)KTVVolumeUtils.TAG, (String)"adjustGameVolume %d", (Object[])new Object[]{gameVolume});
                }
                if (!MLog.isLogLevelAboveDebug() && !MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)KTVVolumeUtils.TAG, (String)"adjustGameVolume mode:%d", (Object[])new Object[]{audioManager.getMode()});
                }
                audioManager.setMode(0);
                try {
                    audioManager.setStreamVolume(3, gameVolume, 0);
                }
                catch (SecurityException e) {
                    MLog.error((Object)KTVVolumeUtils.TAG, (Throwable)e);
                }
            }
        });
    }

    public static int getPlayMusicVolume() {
        AudioManager audioManager = KTVVolumeUtils.getAudioManager();
        if (audioManager == null) {
            return 0;
        }
        return audioManager.getStreamVolume(3);
    }

    public static int getPlayMusicMaxVolume() {
        AudioManager audioManager = KTVVolumeUtils.getAudioManager();
        if (audioManager == null) {
            return 0;
        }
        return audioManager.getStreamMaxVolume(3);
    }
}

