/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.model.player;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.media.AppMsgData;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.channel.cbase.module.ktv.KTVCommonCallback;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVAudioPosition;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomData;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomOperateInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.cbase.module.ktv.room.IKTVNotifyHandler;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVManager;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseContext;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseModel;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVPanelUICallback;
import com.yy.hiyo.channel.plugins.ktv.model.player.IKTVPlayer;
import com.yy.hiyo.channel.plugins.ktv.model.player.IKTVPlayerCallback;
import com.yy.hiyo.voice.base.bean.event.VoiceCallBack;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.channelvoice.IVoiceService;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import okio.ByteString;

public class KTVPlayer
extends KTVBaseModel
implements IKTVPlayer,
IVoiceService.OnAudioPlayCallback,
VoiceCallBack {
    private IKTVPlayerCallback mPlayerCallback;
    private IKTVPanelUICallback mUICallback;
    private TreeMap<Long, Integer> mTimestampMap = new TreeMap();
    private TreeMap<Long, Long> mAudiencePositionMap = new TreeMap();
    private long mLastSendUserAppMsgTime = 0L;
    private static final long SEND_USER_APP_MSG_INTERVAL = 500L;
    private volatile KTVAudioPosition mCurrentKTVAudioPosition = null;
    private long mCurrentSingerTime = 0L;
    private long mCurrentAudienceTime = 0L;
    private static final long PRINT_LOG_INTERVAL = 3000L;
    private IKTVNotifyHandler<KTVRoomOperateInfo> mTerminateSongNotify = notify -> this.getKtvManager().getKTVPlayer().stop();
    private Runnable mCurrDelayPlayTask = null;

    public KTVPlayer(IKTVManager iktvManager) {
        super(iktvManager);
    }

    @Override
    public void onCreate(KTVBaseContext context) {
        super.onCreate(context);
        FeatureLog.i((String)"FTKTVPlayer", (String)"KTVPlayer onCreate", (Object[])new Object[0]);
        this.getKtvManager().getKTVRoomServices().registerTerminateSongNotify(this.mTerminateSongNotify);
        if (null != this.getKtvManager().getContext()) {
            this.getKtvManager().getContext().getRoomContext().getChannel().getMediaService().registerOnSpeakListener((VoiceCallBack)this);
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        FeatureLog.i((String)"FTKTVPlayer", (String)"KTVPlayer onDestroy", (Object[])new Object[0]);
        this.getKtvManager().getKTVRoomServices().unRegisterTerminateSongNotify(this.mTerminateSongNotify);
        if (null != this.getKtvManager().getContext()) {
            this.getKtvManager().getContext().getRoomContext().getChannel().getMediaService().unregisterOnSpeakListener((VoiceCallBack)this);
        }
        this.stop();
    }

    @Override
    public void play(final @NonNull String resourceId, final @Nullable IKTVPlayerCallback callback, final long minimumTime) {
        FeatureLog.i((String)"FTKTVPlayer", (String)"play song resource id: %s", (Object[])new Object[]{resourceId});
        this.mPlayerCallback = callback;
        if (StringUtils.isEmpty((String)resourceId)) {
            if (this.mPlayerCallback != null) {
                this.mPlayerCallback.onPlayFail();
            }
            return;
        }
        final long startTime = System.currentTimeMillis();
        this.getKtvManager().getKTVMusicListProvider().queryMusic(resourceId, new KTVCommonCallback<KTVMusicInfo>(){

            public void onSuccess(KTVMusicInfo data) {
                String filePath = KTVPlayer.this.getKtvManager().getKTVDownloader().getLocalInstrumentalFilePath(data);
                FeatureLog.i((String)"FTKTVPlayer", (String)"query music success file path: %s", (Object[])new Object[]{filePath});
                if (StringUtils.isNotEmpty((String)filePath) && KTVPlayer.this.checkServiceAvailable()) {
                    KTVPlayer.this.stop();
                    if (KTVPlayer.this.mCurrDelayPlayTask != null) {
                        YYTaskExecutor.removeRunnableFromMainThread((Runnable)KTVPlayer.this.mCurrDelayPlayTask);
                    }
                    Runnable playTask = () -> {
                        String currResId = KTVPlayer.this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getResourceId();
                        if (!FP.eq((Object)resourceId, (Object)currResId)) {
                            return;
                        }
                        KTVPlayer.this.getKtvManager().getContext().getRoomContext().getChannel().getMediaService().enablePublishMic(1);
                        if (callback != null) {
                            callback.onPrePlay();
                        }
                        if (SettingFlags.containKey((String)("key_ktv_voice_progress" + AccountUtil.getUid()))) {
                            int intValue = SettingFlags.getIntValue((String)("key_ktv_voice_progress" + AccountUtil.getUid()));
                            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).setMicVolume(intValue);
                        }
                        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).startAudioMixing(filePath, null, (IVoiceService.OnAudioPlayCallback)KTVPlayer.this, true);
                        KTVPlayer.this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().setStatus(1);
                        KTVPlayer.this.mCurrDelayPlayTask = null;
                    };
                    long costTime = System.currentTimeMillis() - startTime;
                    if (costTime < minimumTime) {
                        KTVPlayer.this.mCurrDelayPlayTask = playTask;
                        YYTaskExecutor.postToMainThread((Runnable)KTVPlayer.this.mCurrDelayPlayTask, (long)(minimumTime - costTime));
                    } else {
                        playTask.run();
                    }
                }
            }

            public void onFail(int code, String errorMessage) {
                FeatureLog.e((String)"FTKTVPlayer", (String)"query music error: %s", (Object[])new Object[]{errorMessage});
                if (KTVPlayer.this.mPlayerCallback != null) {
                    KTVPlayer.this.mPlayerCallback.onPlayFail();
                }
                if (KTVPlayer.this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData() != null && KTVPlayer.this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo() != null) {
                    String songId = KTVPlayer.this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getSongId();
                    KTVPlayer.this.getKtvManager().getKTVRoomServices().terminateSong(songId, 1, null);
                }
            }
        });
    }

    @Override
    public void play(@NonNull String resourceId, @Nullable IKTVPlayerCallback callback) {
        this.play(resourceId, callback, 0L);
    }

    @Override
    public void pause() {
        FeatureLog.i((String)"FTKTVPlayer", (String)"KTVPlayer pause", (Object[])new Object[0]);
        if (this.checkServiceAvailable()) {
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).pauseAudioMixing();
            this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().setStatus(2);
        }
    }

    @Override
    public void resume() {
        FeatureLog.i((String)"FTKTVPlayer", (String)"KTVPlayer resume", (Object[])new Object[0]);
        if (this.checkServiceAvailable()) {
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).resumeAudioMixing(true);
            this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().setStatus(1);
        }
    }

    @Override
    public void stop() {
        FeatureLog.i((String)"FTKTVPlayer", (String)"KTVPlayer stop", (Object[])new Object[0]);
        if (this.checkServiceAvailable()) {
            IKtvLiveServiceExtend service = (IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class);
            service.stopAudioMixing();
            service.setMicVolume(100);
        }
    }

    @Override
    public void adjustVolume(int volume) {
        FeatureLog.i((String)"FTKTVPlayer", (String)"adjust volume: %d", (Object[])new Object[]{volume});
        if (this.checkServiceAvailable()) {
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).adjustAudioMixingVolume(volume);
        }
    }

    @Override
    public void registerKTVPanelUICallback(IKTVPanelUICallback uiCallback) {
        this.mUICallback = uiCallback;
    }

    public void onAudioFilePlayEnd() {
        FeatureLog.i((String)"FTKTVPlayer", (String)"onAudioFilePlayEnd", (Object[])new Object[0]);
        if (this.mPlayerCallback != null) {
            this.mPlayerCallback.onPlayEnd();
        }
        if (this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData() != null && this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo() != null) {
            String songId = this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getSongId();
            this.getKtvManager().getKTVRoomServices().terminateSong(songId, 0, null);
        }
        this.mTimestampMap.clear();
        this.mCurrentKTVAudioPosition = null;
        this.mLastSendUserAppMsgTime = 0L;
    }

    public void onAudioFilePlayFail(int errorCode) {
        FeatureLog.i((String)"FTKTVPlayer", (String)"onAudioFilePlayFail", (Object[])new Object[0]);
        if (this.mPlayerCallback != null) {
            this.mPlayerCallback.onPlayFail();
        }
        if (this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData() != null && this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo() != null) {
            String songId = this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getSongId();
            this.getKtvManager().getKTVRoomServices().terminateSong(songId, 1, null);
        }
        this.mTimestampMap.clear();
        this.mCurrentKTVAudioPosition = null;
        this.mLastSendUserAppMsgTime = 0L;
    }

    public void onAudioFilePlaySuccess() {
        FeatureLog.i((String)"FTKTVPlayer", (String)"onAudioFilePlaySuccess", (Object[])new Object[0]);
        if (this.mPlayerCallback != null) {
            this.mPlayerCallback.onPlaySuccess();
        }
        if (this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData() != null && this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo() != null) {
            String songId = this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo().getSongId();
            this.getKtvManager().getKTVRoomServices().startSong(songId, null);
        }
        int volume = SettingFlags.getIntValue((String)("key_ktv_music_progress" + AccountUtil.getUid()), (int)50);
        ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).adjustAudioMixingVolume(volume);
    }

    public void onAudioPlaySpectrumData(byte[] data) {
        KTVRoomData currentKTVRoomData = this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            return;
        }
        if (currentSongInfo.getStatus() != 1) {
            return;
        }
        if (this.mUICallback != null) {
            this.mUICallback.onAudioPlaySpectrumData(data);
        }
    }

    public void onAudioPlayTimestamp(int playTimestamp) {
        if (System.currentTimeMillis() - this.mLastSendUserAppMsgTime < 500L) {
            return;
        }
        this.handlePlayerAudio(playTimestamp);
    }

    public void onAudioPlayTimestamp(Map<Long, Integer> audioVolumeMap) {
        if (audioVolumeMap == null || audioVolumeMap.size() == 0) {
            return;
        }
        KTVRoomData currentKTVRoomData = this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            return;
        }
        if (this.mCurrentKTVAudioPosition == null) {
            return;
        }
        if (!StringUtils.equal((String)currentSongInfo.getSongId(), (String)this.mCurrentKTVAudioPosition.getSongId())) {
            return;
        }
        for (Map.Entry<Long, Integer> volumeInfo : audioVolumeMap.entrySet()) {
            if (volumeInfo == null || currentSongInfo.getUid() != volumeInfo.getKey().longValue() || this.mCurrentKTVAudioPosition == null) continue;
            this.handleLyricsLocation(volumeInfo.getValue().intValue(), this.mCurrentKTVAudioPosition.getTotalDuration());
            break;
        }
    }

    public void onReceiveUserAppMsgData(byte[] data, String uid) {
        KTVRoomData currentKTVRoomData = this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            return;
        }
        if (currentSongInfo.isSinger()) {
            return;
        }
        if (data == null || data.length == 0) {
            FeatureLog.i((String)"FTKTVPlayer", (String)"onReceiveUserAppMsgData data.length == 0.", (Object[])new Object[0]);
            return;
        }
        YYTaskExecutor.execute(() -> {
            ByteString byteString = ByteString.of((byte[])data, (int)0, (int)data.length);
            String json = byteString.string(Charset.forName("utf-8"));
            AppMsgData msgData = (AppMsgData)JsonParser.parseJsonTye((String)json, AppMsgData.class);
            if (msgData != null && msgData.getEventId() == 1) {
                String jsonString = msgData.getData();
                this.mCurrentKTVAudioPosition = (KTVAudioPosition)JsonParser.parseJsonTye((String)jsonString, KTVAudioPosition.class);
                YYTaskExecutor.postToMainThread(() -> {
                    if (this.mCurrentKTVAudioPosition != null) {
                        this.mTimestampMap.put(this.mCurrentKTVAudioPosition.getAudioTs(), this.mCurrentKTVAudioPosition.getPosition());
                    }
                });
            }
        });
    }

    public void onReceiveAppMsgDataFailedStatus(int status) {
        FeatureLog.e((String)"FTKTVPlayer", (String)"onReceiveAppMsgDataFailedStatus status: %d", (Object[])new Object[]{status});
    }

    private void handlePlayerAudio(int playTimestamp) {
        if (!this.checkServiceAvailable()) {
            return;
        }
        long playerTimeMS = ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).getCurrentPlayerTimeMS();
        KTVRoomData currentKTVRoomData = this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            return;
        }
        int currentSongInfoStatus = currentSongInfo.getStatus();
        if (currentSongInfoStatus != 1) {
            return;
        }
        long singerUid = currentSongInfo.getUid();
        String songId = currentSongInfo.getSongId();
        int totalDuration = (int)((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).getTotalPlayTimeMS();
        if (AccountUtil.getUid() == singerUid) {
            long currentTime;
            if (this.mUICallback != null) {
                this.mUICallback.onLyricsTime((int)playerTimeMS, totalDuration);
            }
            if ((currentTime = System.currentTimeMillis()) - this.mCurrentSingerTime > 3000L) {
                FeatureLog.i((String)"FTKTVPlayer", (String)"mOriginSinger report player timestamp: %s,current time: %s,music total time: %s", (Object[])new Object[]{playTimestamp, playerTimeMS, totalDuration});
                this.mCurrentSingerTime = currentTime;
            }
            this.reportAudioPosition(songId, playTimestamp, (int)playerTimeMS, totalDuration);
        }
    }

    private void reportAudioPosition(String songId, long playTimestamp, int playerTimeMS, int totalDuration) {
        KTVAudioPosition ktvAudioPosition = new KTVAudioPosition.Builder().songId(songId).audioTs(playTimestamp).position(playerTimeMS).totalDuration(totalDuration).build();
        YYTaskExecutor.execute(() -> {
            String json = JsonParser.toJson((Object)ktvAudioPosition);
            AppMsgData msgData = new AppMsgData();
            msgData.setEventId(1);
            msgData.setData(json);
            byte[] data = JsonParser.toJson((Object)msgData).getBytes(Charset.forName("utf-8"));
            ((IKtvLiveServiceExtend)ServiceManagerProxy.getServiceManager().getService(IKtvLiveServiceExtend.class)).sendUserAppMsgData(data, AccountUtil.getUid(), playTimestamp);
        });
        this.mLastSendUserAppMsgTime = System.currentTimeMillis();
    }

    private void handleLyricsLocation(long singerPlayerTimeStamp, int totalDuration) {
        if (FP.empty(this.mTimestampMap)) {
            FeatureLog.i((String)"FTKTVPlayer", (String)"mTimestampMap size == 0", (Object[])new Object[0]);
            if (this.mUICallback != null) {
                this.mUICallback.onLyricsTime(0, totalDuration);
            }
        } else {
            Map.Entry<Long, Long> firstEntry;
            if (singerPlayerTimeStamp == 0L) {
                FeatureLog.i((String)"FTKTVPlayer", (String)"singerPlayerTimeStamp == 0L", (Object[])new Object[0]);
                return;
            }
            int targetValue = 0;
            for (long key : this.mTimestampMap.keySet()) {
                if (key == singerPlayerTimeStamp) {
                    targetValue = this.mTimestampMap.get(key);
                    break;
                }
                long newKey = Math.abs(key - singerPlayerTimeStamp);
                this.mAudiencePositionMap.put(newKey, key);
            }
            if (!FP.empty(this.mAudiencePositionMap) && (firstEntry = this.mAudiencePositionMap.firstEntry()) != null) {
                Long value = firstEntry.getValue();
                targetValue = this.mTimestampMap.get(value);
            }
            int finalTargetValue = targetValue;
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.mCurrentAudienceTime > 3000L) {
                FeatureLog.i((String)"FTKTVPlayer", (String)"audience receive mOriginSinger report lyric time: %s,music total time: %s", (Object[])new Object[]{finalTargetValue, totalDuration});
                this.mCurrentSingerTime = currentTime;
            }
            if (this.mUICallback != null) {
                this.mUICallback.onLyricsTime(finalTargetValue, totalDuration);
            }
            this.mAudiencePositionMap.clear();
        }
    }

    @Override
    public void onNetChanged(int status) {
        if (status == 2) {
            KTVRoomData previousKTVRoomData = this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData();
            if (previousKTVRoomData == null) {
                return;
            }
            KTVRoomSongInfo currentSongInfo = previousKTVRoomData.getCurrentSongInfo();
            if (currentSongInfo != null && currentSongInfo.isSinger() && currentSongInfo.getStatus() == 1) {
                this.pause();
            }
        }
    }
}

