/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.model.extra;

import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomData;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomOperateInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.cbase.module.ktv.room.IKTVNotifyHandler;
import com.yy.hiyo.channel.cbase.publicscreen.IPublicScreenService;
import com.yy.hiyo.channel.cbase.publicscreen.callback.IPublicScreenModulePresenter;
import com.yy.hiyo.channel.cbase.publicscreen.msg.PureTextMsg;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVManager;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseContext;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseModel;
import com.yy.hiyo.channel.publicscreen.BaseImMsg;
import java.util.List;

public class KTVExtHandler
extends KTVBaseModel {
    private IKTVNotifyHandler<KTVRoomSongInfo> mAddSongNotify = this::handleAddNotify;
    private IKTVNotifyHandler<List<KTVRoomOperateInfo>> mDeleteSongNotify = this::handleDeleteSongNotify;
    private IKTVNotifyHandler<KTVRoomOperateInfo> mTerminateSongNotify = this::handleTerminateSongNotify;
    private IKTVNotifyHandler<KTVRoomOperateInfo> mSetTopSongNotify = this::handleSetTopSongNotify;

    public KTVExtHandler(IKTVManager iktvManager) {
        super(iktvManager);
    }

    @Override
    public void onCreate(KTVBaseContext context) {
        super.onCreate(context);
        FeatureLog.i((String)"FTKTVPlayer", (String)"KTVExtHandler onKTVCreate", (Object[])new Object[0]);
        this.getKtvManager().getKTVRoomServices().registerAddSongNotify(this.mAddSongNotify);
        this.getKtvManager().getKTVRoomServices().registerDelSongNotify(this.mDeleteSongNotify);
        this.getKtvManager().getKTVRoomServices().registerTerminateSongNotify(this.mTerminateSongNotify);
        this.getKtvManager().getKTVRoomServices().registerSetTopSongNotify(this.mSetTopSongNotify);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        FeatureLog.i((String)"FTKTVPlayer", (String)"KTVExtHandler onKTVDestroy", (Object[])new Object[0]);
        this.getKtvManager().getKTVRoomServices().unRegisterAddSongNotify(this.mAddSongNotify);
        this.getKtvManager().getKTVRoomServices().unRegisterDelSongNotify(this.mDeleteSongNotify);
        this.getKtvManager().getKTVRoomServices().unRegisterTerminateSongNotify(this.mTerminateSongNotify);
        this.getKtvManager().getKTVRoomServices().unRegisterSetTopSongNotify(this.mSetTopSongNotify);
    }

    private void handleAddNotify(KTVRoomSongInfo songInfo) {
        if (songInfo == null) {
            return;
        }
        if (this.getContext() == null || this.getContext().getRoomContext() == null || this.getContext().getRoomContext().isDestroy()) {
            return;
        }
        KTVRoomData currentKTVRoomData = this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            return;
        }
        String content = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.tips_add_song_public_screen), (Object[])new Object[]{songInfo.getSongName()});
        IPublicScreenModulePresenter presenter = (IPublicScreenModulePresenter)this.getContext().getRoomContext().getPresenter(IPublicScreenModulePresenter.class);
        PureTextMsg pureTextMsg = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateLocalPureTextMsg(this.getContext().getRoomContext().getChannel().getChannelId(), (CharSequence)content, this.getContext().getRoomContext().getChannel().getRoleService().getRoleCache(songInfo.getUid()), songInfo.getUid());
        pureTextMsg.setMsgState(1);
        if (presenter.getPublicScreenPresenter() != null) {
            presenter.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)pureTextMsg);
        }
    }

    private void handleDeleteSongNotify(List<KTVRoomOperateInfo> operateInfoList) {
        if (FP.empty(operateInfoList) || operateInfoList.size() > 1 || this.getContext() == null || this.getContext().getRoomContext() == null || this.getContext().getRoomContext().isDestroy()) {
            return;
        }
        if (operateInfoList.size() == 1) {
            KTVRoomData currentKTVRoomData = this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData();
            if (currentKTVRoomData == null) {
                return;
            }
            KTVRoomOperateInfo operateInfo = operateInfoList.get(0);
            if (operateInfo == null) {
                return;
            }
            if (operateInfo.getOperateFlag() != 0) {
                return;
            }
            KTVRoomSongInfo ktvRoomSongInfo = operateInfo.getKTVRoomSongInfo();
            if (ktvRoomSongInfo == null) {
                return;
            }
            String content = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.tips_delete_song_public_screen), (Object[])new Object[]{ktvRoomSongInfo.getSongName()});
            IPublicScreenModulePresenter presenter = (IPublicScreenModulePresenter)this.getContext().getRoomContext().getPresenter(IPublicScreenModulePresenter.class);
            PureTextMsg pureTextMsg = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateLocalPureTextMsg(this.getContext().getRoomContext().getChannel().getChannelId(), (CharSequence)content, this.getContext().getRoomContext().getChannel().getRoleService().getRoleCache(operateInfo.getOperatorUid()), operateInfo.getOperatorUid());
            pureTextMsg.setMsgState(1);
            if (presenter.getPublicScreenPresenter() != null) {
                presenter.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)pureTextMsg);
            }
        }
    }

    private void handleTerminateSongNotify(KTVRoomOperateInfo operateInfo) {
        if (operateInfo == null || operateInfo.getKTVRoomSongInfo() == null || this.getContext() == null || this.getContext().getRoomContext() == null || this.getContext().getRoomContext().isDestroy()) {
            return;
        }
        if (operateInfo.getOperateFlag() != 1) {
            return;
        }
        KTVRoomData currentKTVRoomData = this.getKtvManager().getKTVRoomServices().getCurrentKTVRoomData();
        if (currentKTVRoomData == null) {
            return;
        }
        KTVRoomSongInfo currentSongInfo = currentKTVRoomData.getCurrentSongInfo();
        if (currentSongInfo == null) {
            return;
        }
        String content = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.tips_terminate_song_public_screen), (Object[])new Object[]{operateInfo.getKTVRoomSongInfo().getSongName()});
        IPublicScreenModulePresenter presenter = (IPublicScreenModulePresenter)this.getContext().getRoomContext().getPresenter(IPublicScreenModulePresenter.class);
        PureTextMsg pureTextMsg = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateLocalPureTextMsg(this.getContext().getRoomContext().getChannel().getChannelId(), (CharSequence)content, this.getContext().getRoomContext().getChannel().getRoleService().getRoleCache(operateInfo.getOperatorUid()), operateInfo.getOperatorUid());
        pureTextMsg.setMsgState(1);
        if (presenter.getPublicScreenPresenter() != null) {
            presenter.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)pureTextMsg);
        }
    }

    private void handleSetTopSongNotify(KTVRoomOperateInfo operateInfo) {
        if (operateInfo == null || this.getContext().getRoomContext().isDestroy()) {
            return;
        }
        KTVRoomSongInfo songInfo = operateInfo.getKTVRoomSongInfo();
        if (songInfo == null) {
            return;
        }
        String content = StringUtils.formatWitUSLocal((String)ResourceUtils.getString((int)R.string.tips_set_top_song_public_screen), (Object[])new Object[]{songInfo.getSongName()});
        IPublicScreenModulePresenter presenter = (IPublicScreenModulePresenter)this.getContext().getRoomContext().getPresenter(IPublicScreenModulePresenter.class);
        PureTextMsg pureTextMsg = ((IPublicScreenService)ServiceManagerProxy.getService(IPublicScreenService.class)).getMsgItemFactory().generateLocalPureTextMsg(this.getContext().getRoomContext().getChannel().getChannelId(), (CharSequence)content, this.getContext().getRoomContext().getChannel().getRoleService().getRoleCache(operateInfo.getOperatorUid()), operateInfo.getOperatorUid());
        pureTextMsg.setMsgState(1);
        if (presenter.getPublicScreenPresenter() != null) {
            presenter.getPublicScreenPresenter().appendLocalMsg((BaseImMsg)pureTextMsg);
        }
    }
}

