/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.searchsong;

import android.app.Activity;
import android.content.Context;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.flexbox.FlexboxLayoutManager;
import com.scwang.smartrefresh.layout.SmartRefreshLayout;
import com.scwang.smartrefresh.layout.api.RefreshLayout;
import com.scwang.smartrefresh.layout.listener.OnRefreshLoadMoreListener;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYEditText;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.ImeUtil;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.cbase.channelhiido.RadioUtils;
import com.yy.hiyo.channel.cbase.module.ktv.base.IKTVSearchWindow;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.list.KTVAnimator;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.KTVLibraryPresenter;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.view.KTVMusicItemAdapter;
import com.yy.hiyo.channel.plugins.ktv.list.searchsong.KTVAssociateSearchAdapter;
import com.yy.hiyo.channel.plugins.ktv.list.searchsong.KTVAssociateSearchModel;
import com.yy.hiyo.channel.plugins.ktv.list.searchsong.KTVSearchContract;
import com.yy.hiyo.channel.plugins.ktv.list.searchsong.KTVSearchHistoryItemAdapter;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import java.util.ArrayList;
import java.util.List;
import net.ihago.ktv.api.search.SearchType;
import net.ihago.ktv.api.search.SuggestedRecord;
import net.ihago.ktv.api.search.SuggestedRecordType;

public class KTVSearchWindow
extends DefaultWindow
implements View.OnClickListener,
IKTVSearchWindow,
KTVSearchContract.View,
KTVMusicItemAdapter.ItemClickListener,
KTVSearchHistoryItemAdapter.OnItemClickListener,
KTVAssociateSearchAdapter.OnItemClickListener {
    private YYEditText mEtInput;
    private YYTextView mTvBtnSongList;
    private YYTextView mTvSearchHistory;
    private YYImageView mIvClear;
    private YYImageView mTvBack;
    private YYImageView mIvClearHistory;
    private RecyclerView mRvSongList;
    private RecyclerView mRvSearchHistory;
    private CommonStatusLayout mCslStatus;
    private SmartRefreshLayout mSrlRefresh;
    private RecyclerView mRvKtvAssociate;
    private YYTextView mTvNoSongs;
    private YYTextView mTvPopularSongs;
    private KTVAnimator mKTVAnimator;
    private KTVMusicItemAdapter mAdapter;
    private KTVMusicItemAdapter mDirectlySearchAdapter;
    private KTVSearchHistoryItemAdapter mSearchHistoryAdapter;
    private KTVAssociateSearchAdapter mKtvAssociateSearchAdapter;
    private KTVSearchContract.Presenter mPresenter;
    private static final String TAG = "KTVSearchWindow";

    public KTVSearchWindow(Context context, UICallBacks callBacks) {
        super(context, callBacks, "KTVSearch");
        this.creatView();
    }

    private void creatView() {
        View rootView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.window_search_song_channel, (ViewGroup)this.getBarLayer(), true);
        this.mTvBack = (YYImageView)rootView.findViewById(R.id.iv_back);
        this.mEtInput = (YYEditText)rootView.findViewById(R.id.et_input);
        this.mIvClear = (YYImageView)rootView.findViewById(R.id.iv_clear);
        this.mCslStatus = (CommonStatusLayout)rootView.findViewById(R.id.csl_status);
        this.mSrlRefresh = (SmartRefreshLayout)rootView.findViewById(R.id.srl_refresh);
        this.mRvSongList = (RecyclerView)rootView.findViewById(R.id.rv_song_list);
        this.mTvBtnSongList = (YYTextView)rootView.findViewById(R.id.tv_btn_song_list);
        this.mIvClearHistory = (YYImageView)rootView.findViewById(R.id.iv_clear_history);
        this.mTvSearchHistory = (YYTextView)rootView.findViewById(R.id.tv_title_search_history);
        this.mRvSearchHistory = (RecyclerView)rootView.findViewById(R.id.rv_search_history_list);
        this.mRvKtvAssociate = (RecyclerView)rootView.findViewById(R.id.rl_ktv_associate_list);
        this.mTvNoSongs = (YYTextView)rootView.findViewById(R.id.tv_no_songs);
        this.mTvPopularSongs = (YYTextView)rootView.findViewById(R.id.tv_popular_songs);
        this.mTvBtnSongList.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mTvBack.setOnClickListener((View.OnClickListener)this);
        this.mTvBtnSongList.setOnClickListener((View.OnClickListener)this);
        this.mIvClearHistory.setOnClickListener(this::onClick);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mAdapter = new KTVMusicItemAdapter(this.getContext(), 3);
        this.mAdapter.setOnItemClickListener(this);
        this.mRvSongList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mRvSongList.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.mDirectlySearchAdapter = new KTVMusicItemAdapter(this.getContext(), 3);
        this.mDirectlySearchAdapter.setOnItemClickListener(this::onItemClick);
        this.initInputView();
        this.initRefreshLayout();
        FlexboxLayoutManager flexboxLayoutManager = new FlexboxLayoutManager(this.getContext());
        flexboxLayoutManager.setFlexDirection(0);
        flexboxLayoutManager.setFlexWrap(1);
        this.mRvSearchHistory.setLayoutManager((RecyclerView.LayoutManager)flexboxLayoutManager);
        this.mSearchHistoryAdapter = new KTVSearchHistoryItemAdapter(this.getContext());
        this.mSearchHistoryAdapter.setOnItemClickListener(this::onItemClick);
        this.mRvSearchHistory.setAdapter((RecyclerView.Adapter)this.mSearchHistoryAdapter);
        LinearLayoutManager linearLayoutManager = new LinearLayoutManager(this.getContext());
        linearLayoutManager.setOrientation(1);
        this.mRvKtvAssociate.setLayoutManager((RecyclerView.LayoutManager)linearLayoutManager);
        this.mKtvAssociateSearchAdapter = new KTVAssociateSearchAdapter(this.getContext());
        this.mKtvAssociateSearchAdapter.setOnItemClickListener(this);
        this.mRvKtvAssociate.setAdapter((RecyclerView.Adapter)this.mKtvAssociateSearchAdapter);
        this.mKTVAnimator = new KTVAnimator(this.getContext());
        this.mRvKtvAssociate.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
                ImeUtil.hideIME((Context)KTVSearchWindow.this.getContext(), (View)KTVSearchWindow.this.mEtInput);
            }
        });
    }

    private void initInputView() {
        this.mEtInput.addTextChangedListener(new TextWatcher(){

            public void beforeTextChanged(CharSequence s, int start2, int count, int after) {
            }

            public void onTextChanged(CharSequence s, int start2, int before, int count) {
            }

            public void afterTextChanged(Editable s) {
                if (KTVSearchWindow.this.mPresenter.isClickHistory()) {
                    KTVSearchWindow.this.mPresenter.setClickHistory(false);
                    return;
                }
                if (!TextUtils.isEmpty((CharSequence)s.toString())) {
                    KTVSearchWindow.this.mIvClear.setVisibility(0);
                } else {
                    KTVSearchWindow.this.mIvClear.setVisibility(8);
                }
                KTVSearchWindow.this.mPresenter.delayKtvAssociateSearch(KTVSearchWindow.this.getInput());
            }
        });
        this.mEtInput.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
                if (actionId == 3 || event != null && event.getKeyCode() == 66) {
                    ImeUtil.hideIME((Context)KTVSearchWindow.this.getContext(), (View)KTVSearchWindow.this.mEtInput);
                    KTVEventReportUtil.reportSearchPageSearchBtnClick();
                    return true;
                }
                return false;
            }
        });
        this.mIvClear.setOnClickListener(this::onClick);
    }

    private void initRefreshLayout() {
        this.mSrlRefresh.setOnRefreshLoadMoreListener(new OnRefreshLoadMoreListener(){

            public void onLoadMore(@NonNull RefreshLayout refreshLayout) {
                if (KTVSearchWindow.this.mPresenter.getHasNext()) {
                    KTVSearchWindow.this.mPresenter.searchSongs(KTVSearchWindow.this.getInput(), false, SearchType.kSearchDefault);
                } else {
                    KTVSearchWindow.this.mSrlRefresh.finishLoadMore();
                }
            }

            public void onRefresh(@NonNull RefreshLayout refreshLayout) {
                KTVSearchWindow.this.mPresenter.searchSongs(KTVSearchWindow.this.getInput(), true, SearchType.kSearchDefault);
            }
        });
    }

    private String getInput() {
        return this.mEtInput.getText() == null ? "" : this.mEtInput.getText().toString();
    }

    public void setPresenter(KTVSearchContract.Presenter presenter) {
        this.mPresenter = presenter;
        this.mPresenter.start();
    }

    @Override
    public void showLoading() {
        this.mCslStatus.showLoading();
    }

    @Override
    public void hideLoading() {
        this.mCslStatus.hideLoading();
    }

    @Override
    public void updateSearchResult(List<KTVMusicInfo> list, boolean isFirstPage, boolean isPopularSongs) {
        MLog.info((Object)TAG, (String)("updateSearchResult size and is" + list.size()), (Object[])new Object[0]);
        if (isPopularSongs) {
            this.showPopularTextView();
        } else {
            this.hidePopularTextView();
        }
        ImeUtil.hideIME((Context)this.getContext(), (View)this.mEtInput);
        this.mAdapter.setData(list);
        if (isFirstPage) {
            this.mSrlRefresh.finishRefresh();
        } else {
            this.mSrlRefresh.finishLoadMore();
        }
        this.mDirectlySearchAdapter.setData(list);
        this.mRvSongList.setAdapter((RecyclerView.Adapter)this.mDirectlySearchAdapter);
    }

    @Override
    public void setSearchData(List<KTVMusicInfo> list, boolean isFirstPage, boolean isPopularSongs) {
        MLog.info((Object)TAG, (String)("setSearchData size and is" + list.size()), (Object[])new Object[0]);
        if (isPopularSongs) {
            this.showPopularTextView();
        } else {
            this.hidePopularTextView();
        }
        ImeUtil.hideIME((Context)this.getContext(), (View)this.mEtInput);
        this.mAdapter.setData(list);
        if (isFirstPage) {
            this.mSrlRefresh.finishRefresh();
        } else {
            this.mSrlRefresh.finishLoadMore();
        }
        this.mRvSongList.setAdapter((RecyclerView.Adapter)this.mAdapter);
    }

    private void hideSearchHistory() {
        this.mIvClearHistory.setVisibility(8);
        this.mTvSearchHistory.setVisibility(8);
        this.mRvSearchHistory.setVisibility(8);
        this.mCslStatus.setVisibility(0);
    }

    private void hidePopularTextView() {
        this.mTvPopularSongs.setVisibility(8);
        this.mTvNoSongs.setVisibility(8);
    }

    private void showPopularTextView() {
        this.mRvKtvAssociate.setVisibility(8);
        this.mCslStatus.setVisibility(0);
        this.mTvPopularSongs.setVisibility(0);
        this.mTvNoSongs.setVisibility(0);
    }

    private void showSearchResultRv() {
        this.mCslStatus.setVisibility(0);
        this.mRvKtvAssociate.setVisibility(8);
    }

    @Override
    public void updateSearchHistory(List<String> list) {
        if (FP.empty(list)) {
            this.mIvClearHistory.setVisibility(8);
            this.mTvSearchHistory.setVisibility(8);
        } else {
            this.mIvClearHistory.setVisibility(0);
            this.mTvSearchHistory.setVisibility(0);
        }
        this.mSearchHistoryAdapter.setData(list);
    }

    @Override
    public void updateKTVAssociateSearch(List<KTVAssociateSearchModel> mList) {
        MLog.info((Object)TAG, (String)("updateKTVAssociateSearch size: " + mList.size()), (Object[])new Object[0]);
        if (this.mKtvAssociateSearchAdapter != null) {
            this.mRvKtvAssociate.setVisibility(0);
            this.mCslStatus.setVisibility(8);
            this.mAdapter.setData(new ArrayList<KTVMusicInfo>());
            this.mAdapter.notifyDataSetChanged();
            this.mRvKtvAssociate.setVisibility(0);
            this.mIvClearHistory.setVisibility(8);
            this.mTvSearchHistory.setVisibility(8);
            this.mRvSearchHistory.setVisibility(8);
            this.hidePopularTextView();
            this.mRvKtvAssociate.setAdapter((RecyclerView.Adapter)this.mKtvAssociateSearchAdapter);
            this.mKtvAssociateSearchAdapter.updateData(mList);
        }
    }

    @Override
    public void updateDirectlySearchResult(List<KTVMusicInfo> list) {
        MLog.info((Object)TAG, (String)"updateDirectlySearchResult size = %s", (Object[])new Object[]{list == null ? 0 : list.size()});
        this.mRvKtvAssociate.setVisibility(0);
        this.mCslStatus.setVisibility(8);
        this.mAdapter.setData(new ArrayList<KTVMusicInfo>());
        this.mAdapter.notifyDataSetChanged();
        this.mRvKtvAssociate.setVisibility(0);
        this.mIvClearHistory.setVisibility(8);
        this.mTvSearchHistory.setVisibility(8);
        this.mRvSearchHistory.setVisibility(8);
        this.hidePopularTextView();
        this.mRvKtvAssociate.setAdapter((RecyclerView.Adapter)this.mDirectlySearchAdapter);
        this.mDirectlySearchAdapter.setData(list);
    }

    @Override
    public void updateBtnSongListCount(int count) {
        int curCount = StringUtils.parseInt((String)this.mTvBtnSongList.getText().toString());
        if (count > curCount) {
            this.mTvBtnSongList.startAnimation(this.mKTVAnimator.getZoomInOut());
        }
        this.mTvBtnSongList.setText((CharSequence)String.valueOf(count));
    }

    public void onShown() {
        super.onShown();
        ((Activity)this.getContext()).getWindow().setSoftInputMode(48);
        this.mEtInput.requestFocus();
        ImeUtil.showIME((Activity)((Activity)this.getContext()), (View)this.mEtInput);
    }

    public void onHidden() {
        super.onHidden();
        this.mPresenter.stop();
    }

    @Override
    public void showNodata() {
        this.mCslStatus.showNoData(R.drawable.icon_search_result_no_data, ResourceUtils.getString((int)R.string.tips_search_song_no_result), (View)this.getNoDataExtendView());
    }

    private YYTextView getNoDataExtendView() {
        YYTextView textView = new YYTextView(this.getContext());
        textView.setText((CharSequence)ResourceUtils.getString((int)R.string.title_upload_local_song));
        textView.setTextColor(ResourceUtils.getColor((int)R.color.color_ffc102));
        textView.setTextSize(2, 15.0f);
        textView.getPaint().setFlags(8);
        textView.getPaint().setAntiAlias(true);
        textView.setId(R.id.search_music_no_data_upload_id);
        textView.setOnClickListener(this::onClick);
        return textView;
    }

    @Override
    public void hideNoData() {
        this.mCslStatus.hideNoData();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.iv_clear) {
            this.mEtInput.setText((CharSequence)"");
            this.mIvClear.setVisibility(8);
        } else if (v.getId() == R.id.iv_back) {
            this.mPresenter.closeWindow();
        } else if (v.getId() == R.id.tv_btn_song_list) {
            this.mPresenter.openSongListPanel();
            KTVEventReportUtil.reportOpenSongList("3");
        } else if (v.getId() == R.id.iv_clear_history) {
            this.mPresenter.clearSearchHistory();
        } else if (v.getId() == R.id.search_music_no_data_upload_id) {
            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.OPEN_UPLOAD_SONG_WINDOW);
            if (KTVLibraryPresenter.mMode == 0) {
                KTVEventReportUtil.reportUploadEnterClick("2");
            } else {
                RadioUtils.INSTANCE.reportUploadEnterClick("2");
            }
        }
    }

    @Override
    public void onItemClick(KTVMusicInfo song) {
        this.mPresenter.selectSong(song);
        ImeUtil.hideIME((Context)this.getContext(), (View)this.mEtInput);
    }

    @Override
    public void onItemClick(String keyword) {
        if (KTVLibraryPresenter.mMode == 0) {
            KTVEventReportUtil.reportHistorySearchClick();
        } else {
            RadioUtils.INSTANCE.reportHistorySearchClick();
        }
        this.mPresenter.setClickHistory(true);
        this.mEtInput.setText((CharSequence)keyword);
        this.mPresenter.searchSongs(keyword, true, SearchType.kSearchDefault);
        this.hideSearchHistory();
        this.mCslStatus.showLoading();
    }

    @Override
    public void onItemClickListener(int position, KTVAssociateSearchModel ktvAssociateSearchModel) {
        SuggestedRecord record = ktvAssociateSearchModel.getRecord();
        if (record != null) {
            this.showSearchResultRv();
            if (record.type == SuggestedRecordType.kSuggestedIsSong) {
                KTVEventReportUtil.reportAssociateClick(2);
                this.mPresenter.searchSongs(record.value, true, SearchType.kSearchSong);
            } else if (record.type == SuggestedRecordType.kSuggestedIsSinger) {
                KTVEventReportUtil.reportAssociateClick(1);
                this.mPresenter.searchSongs(record.value, true, SearchType.kSearchSinger);
            } else {
                KTVEventReportUtil.reportAssociateClick(3);
                this.mPresenter.searchSongs(record.value, true, SearchType.kSearchDefault);
            }
        }
    }
}

