/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.searchsong;

import android.content.Context;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.common.Callback;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.cbase.module.ktv.KTVCommonCallback;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVCommonPresenter;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVProtoCallback;
import com.yy.hiyo.channel.plugins.ktv.list.searchsong.KTVSearchContract;
import com.yy.hiyo.channel.plugins.ktv.list.searchsong.OptionSearch;
import com.yy.hiyo.channel.plugins.ktv.model.room.KTVRoomServices;
import com.yy.hiyo.channel.plugins.ktv.model.songList.KTVMusicListProvider;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import java.util.List;
import net.ihago.ktv.api.search.ErrCode;
import net.ihago.ktv.api.search.SearchType;

public class KTVSearchPresenter
extends KTVCommonPresenter
implements KTVSearchContract.Presenter,
OptionSearch.IFinishListener {
    public static final String TAG = "KTVSearchPresenter";
    private Context mContext;
    private KTVSearchContract.View mView;
    private boolean mHasNext;
    private OptionSearch optionSearch;
    private boolean isClickHistory = false;
    private boolean isPopularSongs = false;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public KTVSearchPresenter(Context context, KTVSearchContract.View view, IKTVHandler handler) {
        super(handler);
        this.mView = view;
        this.mContext = context;
        this.optionSearch = new OptionSearch(Looper.getMainLooper());
        this.optionSearch.setListener(this);
    }

    @KvoMethodAnnotation(name="mKTVRoomSongInfoList", sourceClass=KTVRoomServices.class)
    public void onSongListChanged(KvoEventIntent data) {
        final List<KTVRoomSongInfo> list = ((KTVRoomServices)data.source()).getKTVRoomSongInfoList();
        FeatureLog.i((String)"FTKTVList_KTVSearchPresenter", (String)"onSongListChanged, size = %s", (Object[])new Object[]{list == null ? 0 : list.size()});
        if (YYTaskExecutor.isMainThread()) {
            if (this.mView != null) {
                this.mView.updateBtnSongListCount(list.size());
            }
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (KTVSearchPresenter.this.mView != null) {
                        KTVSearchPresenter.this.mView.updateBtnSongListCount(list.size());
                    }
                }
            });
        }
    }

    @KvoMethodAnnotation(sourceClass=KTVMusicListProvider.class, name="searchDataChanged")
    public void onSearchResultChanged(KvoEventIntent data) {
        final List<KTVMusicInfo> list = ((KTVMusicListProvider)data.source()).getSearchResult();
        FeatureLog.i((String)"FTKTVList", (String)"onSearchResultChanged, size = %s", (Object[])new Object[]{list == null ? 0 : list.size()});
        if (YYTaskExecutor.isMainThread()) {
            if (this.mView != null) {
                this.mView.updateSearchResult(list, true, false);
            }
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (KTVSearchPresenter.this.mView != null) {
                        KTVSearchPresenter.this.mView.updateSearchResult(list, true, false);
                    }
                }
            });
        }
    }

    private void getSearchHistory() {
        List<String> list = this.getHandler().getKTVManager().getKTVMusicListProvider().getSearchHistory();
        if (this.mView != null) {
            this.mView.updateSearchHistory(list);
        }
    }

    public void start() {
        this.getSearchHistory();
        this.mBinder.singleBindSourceTo((KvoSource)((KTVMusicListProvider)this.getHandler().getKTVManager().getKTVMusicListProvider()));
        this.mBinder.singleBindSourceTo((KvoSource)((KTVRoomServices)this.getHandler().getKTVManager().getKTVRoomServices()));
    }

    @Override
    public void stop() {
        this.mBinder.clearKvoConnection(KTVRoomServices.class.getName());
        this.mBinder.clearKvoConnection(KTVMusicListProvider.class.getName());
    }

    @Override
    public void openSongListPanel() {
        this.closeWindow();
        this.getHandler().getKTVOperateProvider().getIKTVMusicLibraryOperator().hideMusicLibrary();
        this.getHandler().getKTVOperateProvider().getIKTVSongListOperator().showSongListPanel();
    }

    @Override
    public void clearSearchHistory() {
        this.getHandler().getKTVManager().getKTVMusicListProvider().clearSearchHistory();
        this.getSearchHistory();
    }

    @Override
    public void searchSongs(String keyword, final boolean isFirstPage, SearchType searchType) {
        this.getHandler().getKTVManager().getKTVMusicListProvider().searchMusic(isFirstPage, keyword, searchType, new IKTVProtoCallback<KTVMusicListProvider.KTVSongListResponse>(){

            @Override
            public void onSuccess(@NonNull KTVMusicListProvider.KTVSongListResponse data) {
                KTVSearchPresenter.this.mHasNext = data.hasNext;
                KTVSearchPresenter.this.isPopularSongs = data.isPopularSongs;
                if (KTVSearchPresenter.this.mView != null) {
                    KTVSearchPresenter.this.mView.setSearchData(data.songList, isFirstPage, data.isPopularSongs);
                }
                if (KTVSearchPresenter.this.mView != null && isFirstPage) {
                    KTVSearchPresenter.this.mView.hideLoading();
                    if (FP.empty(data.songList)) {
                        KTVSearchPresenter.this.mView.showNodata();
                    } else {
                        KTVSearchPresenter.this.mView.hideNoData();
                    }
                }
                if (isFirstPage) {
                    KTVEventReportUtil.reportSearchPageResultBack("1");
                }
            }

            @Override
            public void onError(int code, String errorMessage) {
                if (!NetworkUtils.isNetworkAvailable((Context)KTVSearchPresenter.this.mContext)) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                }
                KTVSearchPresenter.this.mView.hideLoading();
                if (isFirstPage) {
                    KTVEventReportUtil.reportSearchPageResultBack("2");
                }
            }
        });
    }

    @Override
    public void selectSong(final KTVMusicInfo songInfo) {
        if (songInfo == null) {
            return;
        }
        if (this.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getSelectSongPolicy() == 1 && !this.getHandler().getKTVManager().getContext().getRoomData().getSeatData().isInSeat(AccountUtil.getUid())) {
            if (this.getHandler().getKTVManager().getContext().getRoomData().getSeatData().isSeatFullWithLocked()) {
                TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.select_song_must_inseat), (int)0);
                KTVEventReportUtil.reportClickSong(songInfo.getSongId(), this.getClickSongEvent(), "2", "4");
            } else if (null != this.getHandler().getKTVOperateProvider().getRoomOperater()) {
                this.getHandler().getKTVOperateProvider().getRoomOperater().getExtRoomOperater().onSitDownRandom(new Callback(){

                    public void onResponse(Object data) {
                        if (data == null) {
                            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.select_song_must_inseat), (int)0);
                        } else {
                            KTVSearchPresenter.this.requestMusic(songInfo);
                        }
                    }
                });
            }
        } else {
            this.requestMusic(songInfo);
        }
    }

    private void requestMusic(final KTVMusicInfo musicInfo) {
        FeatureLog.i((String)"FTKTVList_KTVSearchPresenter", (String)"requestMusic, musicInfo : %s", (Object[])new Object[]{musicInfo});
        if (musicInfo != null) {
            if (!this.getHandler().getKTVManager().getKTVRoomServices().isMySong(musicInfo.getSongId())) {
                if (!this.getHandler().getKTVManager().getKTVRoomServices().canAddSong()) {
                    TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.tips_request_song_reach_limit), (int)0);
                    String reason = "";
                    if (this.getHandler().getKTVManager().getKTVRoomServices().getMySongList().size() >= 25) {
                        reason = "3";
                    } else if (this.getHandler().getKTVManager().getKTVRoomServices().getKTVRoomSongInfoList().size() >= 50) {
                        reason = "2";
                    }
                    KTVEventReportUtil.reportClickSong(musicInfo.getSongId(), this.getClickSongEvent(), "2", reason);
                    return;
                }
                if (this.mView != null) {
                    this.mView.showLoading();
                }
                this.getHandler().getKTVManager().getKTVRoomServices().addSong(musicInfo.getSongId(), (KTVCommonCallback)new KTVCommonCallback<Boolean>(){

                    public void onSuccess(Boolean data) {
                        if (KTVSearchPresenter.this.mView != null) {
                            KTVSearchPresenter.this.mView.hideLoading();
                        }
                        KTVSearchPresenter.this.getHandler().getKTVManager().getKTVMusicListProvider().setMusicRequestStatus(musicInfo.getSongId(), true);
                        KTVEventReportUtil.reportClickSong(musicInfo.getSongId(), KTVSearchPresenter.this.getClickSongEvent(), "1", "");
                    }

                    public void onFail(int code, String errorMessage) {
                        if (KTVSearchPresenter.this.mView != null) {
                            KTVSearchPresenter.this.mView.hideLoading();
                        }
                        if (!NetworkUtils.isNetworkAvailable((Context)KTVSearchPresenter.this.mContext)) {
                            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                        }
                        if (code == ErrCode.kErrNotFound.getValue()) {
                            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.tips_song_not_exist), (int)0);
                            KTVEventReportUtil.reportClickSong(musicInfo.getSongId(), KTVSearchPresenter.this.getClickSongEvent(), "2", "5");
                        } else if (code == ErrCode.kErrSongStatusDiscontinued.getValue()) {
                            TopToastUtils.showToast((CharSequence)ResourceUtils.getString((int)R.string.tips_song_removed), (int)0);
                            KTVEventReportUtil.reportClickSong(musicInfo.getSongId(), KTVSearchPresenter.this.getClickSongEvent(), "2", "6");
                        }
                    }
                });
            } else {
                KTVEventReportUtil.reportClickSong(musicInfo.getSongId(), this.getClickSongEvent(), "2", "8");
            }
        }
    }

    @Override
    public boolean getHasNext() {
        return this.mHasNext;
    }

    @Override
    public void ktvAssociateSearch(String keyWord) {
        this.getHandler().getKTVManager().getKTVMusicListProvider().directlySearch(keyWord, "", new KTVCommonCallback<List<KTVMusicInfo>>(){

            public void onSuccess(List<KTVMusicInfo> data) {
                if (KTVSearchPresenter.this.mView != null) {
                    KTVSearchPresenter.this.mView.updateDirectlySearchResult(data);
                }
            }

            public void onFail(int code, String errorMessage) {
            }
        });
    }

    @Override
    public void delayKtvAssociateSearch(String keyWord) {
        if (this.optionSearch != null) {
            this.optionSearch.optionSearch(keyWord);
        }
    }

    @Override
    public void closeWindow() {
        this.getHandler().getKTVManager().getKTVMusicListProvider().clearSearchResult();
        MsgDispatcher.getInstance().sendMessage(BaseMsgDef.CLOSE_SEARCH_SONG_WINDOW);
    }

    @Override
    public void getKeyword(String keyword) {
        this.ktvAssociateSearch(keyword);
    }

    @Override
    public boolean isClickHistory() {
        return this.isClickHistory;
    }

    @Override
    public void setClickHistory(boolean clickHistory) {
        this.isClickHistory = clickHistory;
    }

    @Override
    public String getClickSongEvent() {
        int type = 3;
        if (this.isPopularSongs) {
            type = 12;
        }
        return String.valueOf(type);
    }
}

