/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.searchsong;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.flexbox.FlexboxLayoutManager;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.hiyo.channel.plugins.ktv.R;
import java.util.ArrayList;
import java.util.List;

public class KTVSearchHistoryItemAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    private Context mContext;
    private List<String> mData;
    private OnItemClickListener mListener;

    public KTVSearchHistoryItemAdapter(Context context) {
        this.mContext = context;
        this.mData = new ArrayList<String>(10);
    }

    public void setData(List<String> data) {
        this.mData.clear();
        if (!FP.empty(data)) {
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mListener = listener;
    }

    public int getItemCount() {
        return this.mData.size();
    }

    @NonNull
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_search_history_channel, parent, false);
        MyViewHolder viewHolder = new MyViewHolder(itemView);
        return viewHolder;
    }

    public void onBindViewHolder(@NonNull MyViewHolder holder, final int position) {
        String keyword = this.mData.get(position);
        holder.mTvItem.setText((CharSequence)this.mData.get(position));
        ViewGroup.LayoutParams lp = holder.mTvItem.getLayoutParams();
        if (lp instanceof FlexboxLayoutManager.LayoutParams) {
            FlexboxLayoutManager.LayoutParams flexboxLp = (FlexboxLayoutManager.LayoutParams)lp;
            flexboxLp.leftMargin = ResolutionUtils.dip2Px((float)10.0f);
            flexboxLp.bottomMargin = ResolutionUtils.dip2Px((float)10.0f);
        }
        holder.mTvItem.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (KTVSearchHistoryItemAdapter.this.mListener != null) {
                    KTVSearchHistoryItemAdapter.this.mListener.onItemClick((String)KTVSearchHistoryItemAdapter.this.mData.get(position));
                }
            }
        });
    }

    public static interface OnItemClickListener {
        public void onItemClick(String var1);
    }

    public class MyViewHolder
    extends RecyclerView.ViewHolder {
        public YYTextView mTvItem;

        public MyViewHolder(View view) {
            super(view);
            this.mTvItem = (YYTextView)view.findViewById(R.id.tv_item_view);
        }
    }
}

