/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.searchsong;

import android.os.Message;
import com.yy.appbase.core.DefaultController;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.list.searchsong.KTVSearchPresenter;
import com.yy.hiyo.channel.plugins.ktv.list.searchsong.KTVSearchWindow;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;

public class KTVSearchController
extends DefaultController {
    private KTVSearchWindow mWindow;
    private KTVSearchPresenter mPresenter;

    public KTVSearchController(Environment environment) {
        super(environment);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == BaseMsgDef.OPEN_SEARCH_SONG_WINDOW) {
            if (msg.obj instanceof IKTVHandler) {
                this.openWindow((IKTVHandler)msg.obj);
            }
        } else if (msg.what == BaseMsgDef.CLOSE_SEARCH_SONG_WINDOW) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
            }
            this.mWindow = null;
            this.mPresenter = null;
        }
    }

    private void openWindow(IKTVHandler handler) {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
        }
        this.mWindow = new KTVSearchWindow(this.mContext, (UICallBacks)this);
        this.mPresenter = new KTVSearchPresenter(this.mContext, this.mWindow, handler);
        this.mWindow.setPresenter(this.mPresenter);
        this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
        KTVEventReportUtil.reportSearchPageShow();
    }
}

